/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialMeterUnitListImportImpl")
public class PurchaseMaterialMeterUnitListImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialMeterUnitListImportImpl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialUnitService purchaseMaterialUnitService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<PurchaseMaterialUnitDTO> list = new ArrayList<PurchaseMaterialUnitDTO>();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        for (Object data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            if (!CharSequenceUtil.isNotBlank((CharSequence)materialNumber) || materialNumberList.contains(materialNumber)) continue;
            materialNumberList.add(materialNumber);
        }
        Map<String, PurchaseMaterialHead> materialIdMap = this.purchaseMaterialHeadService.listMaterialHeadByNumbers(materialNumberList, TenantContext.getTenant());
        for (Map data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            if (CharSequenceUtil.isBlank((CharSequence)materialNumber) || !materialIdMap.containsKey(materialNumber)) {
                String msg = I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (materialIdMap.containsKey(materialNumber)) {
                PurchaseMaterialHead head = materialIdMap.get(materialNumber);
                if (!(AuditStatusEnum.AUDIT_NEW.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(head.getAuditStatus()))) {
                    String msg = I18nUtil.translate((String)"", (String)"\u5f53\u524d\u7269\u6599\u72b6\u6001\u4e0d\u5141\u8bb8\u66f4\u6539\u8ba1\u91cf\u5355\u4f4d");
                    this.errorAdd(excelImportDTO, msg, data);
                    continue;
                }
            }
            PurchaseMaterialUnitDTO entity = (PurchaseMaterialUnitDTO)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialUnitDTO.class);
            entity.setChangeUnit("=");
            entity.setElsAccount(TenantContext.getTenant());
            entity.setIsDefault(CharSequenceUtil.emptyToDefault((CharSequence)entity.getIsDefault(), (String)"1"));
            list.add(entity);
        }
        ArrayList<PurchaseMaterialUnit> result = new ArrayList<PurchaseMaterialUnit>();
        for (PurchaseMaterialUnitDTO dto : list) {
            if (!materialIdMap.containsKey(dto.getMaterialNumber())) continue;
            PurchaseMaterialUnit materialUnit = (PurchaseMaterialUnit)((Object)Convert.convert(PurchaseMaterialUnit.class, (Object)dto));
            materialUnit.setHeadId(materialIdMap.get(dto.getMaterialNumber()).getId());
            materialUnit.setElsAccount(TenantContext.getTenant());
            result.add(materialUnit);
        }
        if (CollUtil.isNotEmpty(result)) {
            this.purchaseMaterialUnitService.saveBatch(result);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

