/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.mapper.PurchaseMaterialRelationMapper;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialRelationServiceImpl
extends BaseOpenServiceImpl<PurchaseMaterialRelationMapper, PurchaseMaterialRelation, PurchaseMaterialRelation>
implements PurchaseMaterialRelationService {
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    public void savePurchaseMaterialRelation(PurchaseMaterialRelation purchaseMaterialRelation) {
        ((PurchaseMaterialRelationMapper)this.baseMapper).insert((Object)purchaseMaterialRelation);
    }

    @Override
    public void updatePurchaseMaterialRelation(PurchaseMaterialRelation purchaseMaterialRelation) {
        int count = ((PurchaseMaterialRelationMapper)this.baseMapper).updateById((Object)purchaseMaterialRelation);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchaseMaterialRelation(String id) {
        ((PurchaseMaterialRelationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialRelation(List<String> idList) {
        ((PurchaseMaterialRelationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public PurchaseMaterialRelation findByMaterialAndAccount(String materialNumber, String toElsAccount) {
        PurchaseMaterialRelation materialRelation = (PurchaseMaterialRelation)((Object)((PurchaseMaterialRelationMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"material_number", (Object)materialNumber)).eq((Object)"to_els_account", (Object)toElsAccount)).eq((Object)"is_blocked", (Object)"0")));
        return materialRelation;
    }

    @Override
    public Map<String, PurchaseMaterialRelation> findByMaterialAndAccount(List<String> materialNumberList, List<String> toElsAccountList) {
        HashMap<String, PurchaseMaterialRelation> relationMap = new HashMap<String, PurchaseMaterialRelation>();
        if (CollectionUtil.isNotEmpty(materialNumberList) && CollectionUtil.isNotEmpty(toElsAccountList)) {
            List materialRelationList = ((PurchaseMaterialRelationMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"to_els_account", toElsAccountList)).in((Object)"material_number", materialNumberList)).eq((Object)"is_blocked", (Object)"0"));
            for (PurchaseMaterialRelation relation : materialRelationList) {
                relationMap.put(relation.getMaterialNumber() + relation.getToElsAccount(), relation);
            }
        }
        return relationMap;
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseMaterialRelation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialRelationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialRelation head2 : materialRelationList) {
            this.pushDataToErp(head2);
        }
    }

    private void pushDataToErp(PurchaseMaterialRelation head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseMaterialRelation", (Object)head);
    }
}

