/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBomAuditAdapter")
public class PurchaseBomAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    PurchaseBomHeadService purchaseBomHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateBom(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseBomHead bomHead = new PurchaseBomHead();
        bomHead.setId(flowCallbackDTO.getBusinessId());
        bomHead.setBomStatus(PurchaseBomStatus.NORMAL.getValue());
        bomHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        bomHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseBomHeadService.updateById((Object)bomHead);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateBom(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateBom(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseBomHead head = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateBom(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseBomHead bomHead = new PurchaseBomHead();
        bomHead.setId(flowCallbackDTO.getBusinessId());
        bomHead.setAuditStatus(auditStatus);
        bomHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseBomHeadService.updateById((Object)bomHead);
    }
}

