/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.vo.PurchaseInformationRecordsVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@RpcService(value="purchaseInformationAuditDubboAdapter")
public class PurchaseInformationRecordsAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseInformationRecordsVO records = (PurchaseInformationRecordsVO)((Object)JSON.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseInformationRecordsVO.class));
        this.purchaseInformationRecordsService.cutOffPriceDate(records, true);
        this.purchaseInformationRecordsService.updatePurchaseInformationRecords(records, records.getAttachmentList());
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        boolean count;
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)this.purchaseInformationRecordsService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        records.setId(flowCallbackDTO.getBusinessId());
        records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        records.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(AuditStatusEnum.AUDIT_FINISH.getValue())) {
            records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            this.purchaseInformationRecordsService.cutOffPriceDate(records, false);
            this.purchaseInformationRecordsService.checkStatus(records);
        }
        if (!(count = this.purchaseInformationRecordsService.updateById((Object)records))) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseInformationRecords head = (PurchaseInformationRecords)((Object)this.purchaseInformationRecordsService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseInformationRecords records = new PurchaseInformationRecords();
        records.setId(flowCallbackDTO.getBusinessId());
        records.setAuditStatus(auditStatus);
        records.setFlowId(flowCallbackDTO.getProcessInstanceId());
        boolean count = this.purchaseInformationRecordsService.updateById((Object)records);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    public void batchStartCallBack(List<FlowCallBackDTO> inputParamDTOList) {
        for (FlowCallBackDTO inputParamDTO : inputParamDTOList) {
            this.startProcessCallBack(inputParamDTO);
        }
    }
}

