/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.service.AiInvokeSrmRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RpcService(value="batchMaterialPriceAgentCollectEnhance")
public class BatchPriceAgentCollectEnhanceServiceImpl
implements AiInvokeSrmRpcService<String> {
    public String invoke(com.alibaba.fastjson2.JSONObject jsonObject) {
        com.alibaba.fastjson2.JSONObject llmRequest = jsonObject.getJSONObject("llmRequest");
        com.alibaba.fastjson2.JSONObject preStepParam = jsonObject.getJSONObject("preStepParam");
        List materialNumberList = preStepParam.getJSONArray("materialNumber").toJavaList(String.class, new JSONReader.Feature[0]);
        if (CollectionUtil.isEmpty((Collection)materialNumberList)) {
            return "";
        }
        String groupFiled = preStepParam.getString("groupFiled");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(PurchaseInformationRecords::getMaterialNumber, (Collection)materialNumberList)).in(PurchaseInformationRecords::getRecordStatus, new Object[]{"6"});
        List list = ((PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class)).list((Wrapper)wrapper);
        ArrayList<JSONObject> historyPriceList = new ArrayList<JSONObject>();
        for (PurchaseInformationRecords records : list) {
            String supplierName = records.getSupplierName();
            BigDecimal price = records.getPrice();
            BigDecimal netPrice = records.getNetPrice();
            Date quoteDate = records.getQuoteDate();
            if (null == quoteDate) {
                quoteDate = records.getEffectiveDate();
            }
            JSONObject item = new JSONObject();
            item.put("\u516c\u53f8\u540d\u79f0", (Object)supplierName);
            item.put("\u7269\u6599\u7f16\u7801", (Object)records.getMaterialNumber());
            item.put("\u542b\u7a0e\u5355\u4ef7", (Object)price);
            item.put("\u4e0d\u542b\u7a0e\u5355\u4ef7", (Object)netPrice);
            String dateFormat = quoteDate == null ? "" : DateUtil.format((Date)quoteDate, (String)"yyyy-MM-dd");
            item.put("\u4ef7\u683c\u65e5\u671f", (Object)dateFormat);
            historyPriceList.add(item);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)groupFiled)) {
            Map<String, List<JSONObject>> historyPriceListMap = historyPriceList.stream().collect(Collectors.groupingBy(x -> x.getString(groupFiled)));
            return JSON.toJSONString(historyPriceListMap);
        }
        return JSON.toJSONString(historyPriceList);
    }
}

