/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.enumerate.MaterialCateStatusEnum;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@RpcService
public class GetMaterialCodeFromJingHuaU8DbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialCodeFromJingHuaU8DbImpl.class);
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public JSONObject before(JSONObject obj, Object custom) {
        String sql = "select * from MINdMatClassQQT_Q3SendInfo";
        obj.put("body", (Object)sql);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetMaterialFromJingHuaU8DbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray u8ItemList = this.handlerResultListInfo(interfaceResult);
        Assert.notEmpty((Collection)u8ItemList, (String)"\u6682\u65e0\u7269\u6599\u5206\u7c7b\u6570\u636e\u9700\u8981\u540c\u6b65");
        ArrayList<PurchaseMaterialCode> insertList = new ArrayList<PurchaseMaterialCode>();
        ArrayList<PurchaseMaterialCode> updateList = new ArrayList<PurchaseMaterialCode>();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        Map codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, Function.identity()));
        for (Object object : u8ItemList) {
            JSONObject item = (JSONObject)object;
            String cateCode = item.getString("MatClass");
            PurchaseMaterialCode dbCode = (PurchaseMaterialCode)((Object)codeMap.get(cateCode));
            if (dbCode == null) {
                PurchaseMaterialCode insert = new PurchaseMaterialCode();
                insert.setCateCode(cateCode);
                insert.setCateName(item.getString("ClassName"));
                insert.setCateLevelCode("1");
                insert.setCateStatus(MaterialCateStatusEnum.NORMAL.getValue());
                insert.setSourceType("1");
                insert.setQuotaStrategy("0");
                insert.setCreateBy(loginUser.getSubAccount());
                insert.setCreateById(loginUser.getId());
                insert.setCreateTime(new Date());
                insert.setUpdateBy(loginUser.getSubAccount());
                insert.setUpdateById(loginUser.getId());
                insert.setUpdateTime(new Date());
                insertList.add(insert);
                continue;
            }
            dbCode.setCateName(item.getString("ClassName"));
            updateList.add(dbCode);
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.purchaseMaterialCodeService.saveBatch(insertList, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.purchaseMaterialCodeService.updateBatchById(updateList, 2000);
        }
        return interfaceResult;
    }

    private JSONArray handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        Assert.isTrue((result.getIntValue("status") == 200 ? 1 : 0) != 0, (String)result.getString("message"));
        return result.getJSONArray("result");
    }
}

