/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@RpcService
public class GetMaterialFromJingHuaU8DbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetMaterialFromJingHuaU8DbImpl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    @Resource
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Resource
    private BaseRpcService baseRpcService;
    @Resource
    private TemplateRpcService templateRpcService;

    public JSONObject before(JSONObject obj, Object custom) {
        String sql = "select * from MINdMatQQT_Q3SendInfo";
        obj.put("body", (Object)sql);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetMaterialFromJingHuaU8DbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray u8ItemList = this.handlerResultListInfo(interfaceResult);
        Assert.notEmpty((Collection)u8ItemList, (String)"\u6682\u65e0\u7269\u6599\u6570\u636e\u9700\u8981\u540c\u6b65");
        ArrayList<PurchaseMaterialHead> insertList = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialHead> updateList = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialUnit> unitList = new ArrayList<PurchaseMaterialUnit>();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List templateList = this.templateRpcService.getDefaultTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f");
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
        List dictList = this.baseRpcService.queryDictItemsByCode("unitCode", TenantContext.getTenant());
        Map<String, String> codeMap = this.purchaseMaterialCodeService.list().stream().collect(Collectors.toMap(PurchaseMaterialCode::getCateCode, PurchaseMaterialCode::getCateName, (newVal, oldVal) -> oldVal));
        Map materialMap = this.purchaseMaterialHeadService.list().stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        for (Object object : u8ItemList) {
            JSONObject item = (JSONObject)object;
            String materialNumber = item.getString("Partnum");
            PurchaseMaterialHead dbHead = (PurchaseMaterialHead)((Object)materialMap.get(materialNumber));
            String unit = this.getUnitCodeByName(item.getString("Unit"), dictList);
            String cateCode = item.getString("MatClass");
            if (dbHead == null) {
                PurchaseMaterialHead insert = (PurchaseMaterialHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)headDefaultValue), PurchaseMaterialHead.class));
                insert.setId(IdWorker.getIdStr());
                insert.setElsAccount(TenantContext.getTenant());
                insert.setTemplateNumber(template.getTemplateNumber());
                insert.setTemplateName(template.getTemplateName());
                insert.setTemplateAccount(template.getElsAccount());
                insert.setTemplateVersion(template.getTemplateVersion());
                insert.setMaterialNumber(materialNumber);
                insert.setMaterialName(item.getString("MatName"));
                insert.setMaterialDesc(item.getString("MatName"));
                insert.setCateCode(cateCode);
                insert.setCateName(codeMap.get(cateCode));
                insert.setCateLevelCode("1");
                insert.setBaseUnit(unit);
                insert.setPurchaseUnit(unit);
                insert.setNeedAudit("0");
                insert.setSubmitStatus("0");
                insert.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                insert.setSourceType("erp");
                insert.setCreateBy(loginUser.getSubAccount());
                insert.setCreateById(loginUser.getId());
                insert.setCreateTime(new Date());
                insert.setUpdateBy(loginUser.getSubAccount());
                insert.setUpdateById(loginUser.getId());
                insert.setUpdateTime(new Date());
                insertList.add(insert);
                unitList.addAll(this.generateUnit(insert));
                continue;
            }
            if (!this.isUpdate(dbHead, item, unit)) continue;
            dbHead.setMaterialName(item.getString("MatName"));
            dbHead.setMaterialDesc(item.getString("MatName"));
            dbHead.setCateCode(cateCode);
            dbHead.setCateName(codeMap.get(cateCode));
            dbHead.setBaseUnit(unit);
            dbHead.setPurchaseUnit(unit);
            dbHead.setUpdateBy(loginUser.getSubAccount());
            dbHead.setUpdateById(loginUser.getId());
            dbHead.setUpdateTime(new Date());
            updateList.add(dbHead);
            unitList.addAll(this.generateUnit(dbHead));
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.purchaseMaterialHeadService.saveBatch(insertList, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.purchaseMaterialHeadService.updateBatchById(updateList, 2000);
            List<String> headIdList = updateList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            this.purchaseMaterialUnitService.deleteByMainIdList(headIdList);
        }
        if (CollectionUtil.isNotEmpty(unitList)) {
            this.purchaseMaterialUnitService.saveBatch(unitList, 2000);
        }
        return interfaceResult;
    }

    private JSONArray handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        Assert.isTrue((result.getIntValue("status") == 200 ? 1 : 0) != 0, (String)result.getString("message"));
        return result.getJSONArray("result");
    }

    private String getUnitCodeByName(String unitName, List<DictDTO> dictList) {
        Map<String, String> unitMap = dictList.stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue, (newVal, oldVal) -> oldVal));
        return unitMap.get(unitName);
    }

    private List<PurchaseMaterialUnit> generateUnit(PurchaseMaterialHead head) {
        ArrayList<PurchaseMaterialUnit> purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
        PurchaseMaterialUnit purchaseUnit = new PurchaseMaterialUnit();
        purchaseUnit.setType("0");
        purchaseUnit.setBasicUnit(head.getBaseUnit());
        purchaseUnit.setObjectUnit(head.getBaseUnit());
        head.setPurchaseUnit(purchaseUnit.getObjectUnit());
        purchaseUnit.setElsAccount(head.getElsAccount());
        purchaseUnit.setCreateBy(head.getCreateBy());
        purchaseUnit.setCreateTime(head.getCreateTime());
        purchaseUnit.setUpdateBy(head.getUpdateBy());
        purchaseUnit.setCreateTime(head.getUpdateTime());
        purchaseUnit.setDeleted(head.getDeleted());
        purchaseUnit.setBasicAmount(BigDecimal.ONE);
        purchaseUnit.setObjectAmount(BigDecimal.ONE);
        purchaseUnit.setChangeUnit("=");
        purchaseUnit.setIsDefault("1");
        purchaseUnit.setHeadId(head.getId());
        purchaseUnit.setElsAccount(head.getElsAccount());
        SysUtil.setSysParam((BaseEntity)purchaseUnit, (BaseEntity)head);
        purchaseMaterialUnitList.add(purchaseUnit);
        PurchaseMaterialUnit repertoryUnit = new PurchaseMaterialUnit();
        repertoryUnit.setType("1");
        repertoryUnit.setBasicUnit(head.getBaseUnit());
        repertoryUnit.setObjectUnit(head.getBaseUnit());
        head.setRepertoryUnit(repertoryUnit.getObjectUnit());
        repertoryUnit.setElsAccount(head.getElsAccount());
        repertoryUnit.setCreateBy(head.getCreateBy());
        repertoryUnit.setCreateTime(head.getCreateTime());
        repertoryUnit.setUpdateBy(head.getUpdateBy());
        repertoryUnit.setCreateTime(head.getUpdateTime());
        repertoryUnit.setDeleted(head.getDeleted());
        repertoryUnit.setBasicAmount(BigDecimal.ONE);
        repertoryUnit.setObjectAmount(BigDecimal.ONE);
        repertoryUnit.setChangeUnit("=");
        repertoryUnit.setIsDefault("1");
        repertoryUnit.setHeadId(head.getId());
        repertoryUnit.setElsAccount(head.getElsAccount());
        SysUtil.setSysParam((BaseEntity)repertoryUnit, (BaseEntity)head);
        purchaseMaterialUnitList.add(repertoryUnit);
        return purchaseMaterialUnitList;
    }

    private boolean isUpdate(PurchaseMaterialHead dbHead, JSONObject item, String interfaceUnit) {
        return !this.isSame(dbHead.getBaseUnit(), interfaceUnit) || !this.isSame(dbHead.getMaterialName(), item.getString("MatName")) || !this.isSame(dbHead.getCateCode(), item.getString("MatClass"));
    }

    private boolean isSame(String source, String target) {
        source = source == null ? "" : source;
        target = target == null ? "" : target;
        return source.equals(target);
    }
}

