/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.exchange.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.exchange.entity.BpExchangeRate;
import com.els.modules.exchange.service.BpExchangeRateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="BP\u6c47\u7387\u7ef4\u62a4")
@RestController
@RequestMapping(value={"/exchange/bpExchangeRate"})
@BusinessModule(module="bpExchangeRate")
public class BpExchangeRateController
extends BaseController<BpExchangeRate, BpExchangeRateService> {
    @Autowired
    private BpExchangeRateService bpExchangeRateService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:list"})
    @PermissionDataView(businessType="bpExchangeRate")
    public Result<?> queryPageList(BpExchangeRate bpExchangeRate, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)bpExchangeRate), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.bpExchangeRateService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="BP\u6c47\u7387\u7ef4\u62a4-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:add"})
    public Result<?> add(@RequestBody BpExchangeRate bpExchangeRate) {
        this.bpExchangeRateService.saveBpExchangeRate(bpExchangeRate);
        return Result.ok((Object)((Object)bpExchangeRate));
    }

    @SrmValidated
    @AutoLog(value="BP\u6c47\u7387\u7ef4\u62a4-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:edit"})
    @PermissionDataOpt(businessType="bpExchangeRate", beanClass=BpExchangeRateService.class)
    public Result<?> edit(@RequestBody BpExchangeRate bpExchangeRate) {
        this.bpExchangeRateService.updateBpExchangeRate(bpExchangeRate);
        String id = bpExchangeRate.getId();
        return this.queryById(id);
    }

    @AutoLog(value="BP\u6c47\u7387\u7ef4\u62a4-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:delete"})
    @PermissionDataOpt(businessType="bpExchangeRate", beanClass=BpExchangeRateService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.bpExchangeRateService.delBpExchangeRate(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="BP\u6c47\u7387\u7ef4\u62a4-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.bpExchangeRateService.delBatchBpExchangeRate(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="BP\u6c47\u7387\u7ef4\u62a4-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:queryById"})
    @PermissionDataOpt(businessType="bpExchangeRate", beanClass=BpExchangeRateService.class)
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        BpExchangeRate bpExchangeRate = (BpExchangeRate)((Object)this.bpExchangeRateService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)bpExchangeRate));
    }

    @AutoLog(value="BP\u6c47\u7387\u7ef4\u62a4-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u6839\u636e\u552f\u4e00\u503c\u83b7\u53d6\u6c47\u7387\u4fe1\u606f", description="\u6839\u636e\u552f\u4e00\u503c\u83b7\u53d6\u6c47\u7387\u4fe1\u606f")
    @GetMapping(value={"/getOnlyInfo"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:list"})
    public Result<?> getOnlyInfo(@RequestParam(name="originalCurrency", required=true) String originalCurrency, @RequestParam(name="targetCurrency", required=true) String targetCurrency, @RequestParam(name="exchangeUse", required=false) String exchangeUse, @RequestParam(name="elsAccount", required=false) String elsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BpExchangeRate::getOriginalCurrency, (Object)originalCurrency);
        queryWrapper.lambda().eq(BpExchangeRate::getTargetCurrency, (Object)targetCurrency);
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)(StrUtil.isNotBlank((CharSequence)elsAccount) ? elsAccount : TenantContext.getTenant()));
        if (StrUtil.isBlank((CharSequence)exchangeUse)) {
            queryWrapper.lambda().eq(BpExchangeRate::getExchangeUse, (Object)"0");
        } else {
            queryWrapper.lambda().eq(BpExchangeRate::getExchangeUse, (Object)exchangeUse);
        }
        List list = this.bpExchangeRateService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }

    @Operation(summary="\u83b7\u53d6ERP\u6570\u636e", description="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:getDataByErp"})
    public Result<?> getDataByErp() {
        this.bpExchangeRateService.getDataByErp();
        return Result.ok();
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.bpExchangeRateService.pushDataToErp(ids);
        return Result.ok();
    }

    @GetMapping(value={"/getByOrderData"})
    @RequiresPermissions(value={"srmExchangeRate#BpExchangeRate:list"})
    public Result<?> getByOrderData(@RequestParam(name="originalCurrency") String originalCurrency, @RequestParam(name="targetCurrency") String targetCurrency, @RequestParam(name="orderDate") String orderDate, @RequestParam(name="elsAccount", required=false) String elsAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BpExchangeRate::getOriginalCurrency, (Object)originalCurrency);
        queryWrapper.lambda().eq(BpExchangeRate::getTargetCurrency, (Object)targetCurrency);
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)(StrUtil.isNotBlank((CharSequence)elsAccount) ? elsAccount : TenantContext.getTenant()));
        queryWrapper.lambda().eq(BpExchangeRate::getExchangeUse, (Object)"0");
        queryWrapper.lambda().le(BpExchangeRate::getEffectiveTime, (Object)orderDate);
        queryWrapper.lambda().ge(BpExchangeRate::getExpireTime, (Object)orderDate);
        List list = this.bpExchangeRateService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }
}

