/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.excel.PurchaseMaterialRelationExportServiceImpl;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import com.els.modules.material.service.SaleMaterialRelationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb")
@RestController
@RequestMapping(value={"/material/purchaseMaterialRelation"})
@BusinessModule(module="materialRelation")
public class PurchaseMaterialRelationController
extends BaseController<PurchaseMaterialRelation, PurchaseMaterialRelationService> {
    @Autowired
    private PurchaseMaterialRelationService purchaseMaterialRelationService;
    @Autowired
    private SaleMaterialRelationService saleMaterialRelationService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:list"})
    @PermissionDataView(businessType="materialRelation")
    public Result<?> queryPageList(PurchaseMaterialRelation purchaseMaterialRelation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialRelation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialRelationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:add"})
    public Result<?> add(@RequestBody PurchaseMaterialRelation purchaseMaterialRelation) {
        this.purchaseMaterialRelationService.savePurchaseMaterialRelation(purchaseMaterialRelation);
        return Result.ok((Object)((Object)purchaseMaterialRelation));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:edit"})
    @PermissionDataOpt(businessType="materialRelation", beanClass=PurchaseMaterialRelationService.class)
    public Result<?> edit(@RequestBody PurchaseMaterialRelation purchaseMaterialRelation) {
        this.purchaseMaterialRelationService.updatePurchaseMaterialRelation(purchaseMaterialRelation);
        String id = purchaseMaterialRelation.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u51bb\u7ed3/\u89e3\u51bb")
    @Operation(summary="\u51bb\u7ed3/\u89e3\u51bb", description="\u51bb\u7ed3/\u89e3\u51bb")
    @GetMapping(value={"/blockOpt"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:blockOpt"})
    @PermissionDataOpt(businessType="materialRelation", beanClass=PurchaseMaterialRelationService.class)
    public Result<?> blockOpt(@RequestParam(name="id") String id) {
        PurchaseMaterialRelation materialRelation = (PurchaseMaterialRelation)((Object)this.purchaseMaterialRelationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (!TenantContext.getTenant().equals(materialRelation.getCreateAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ROtkvCcIjWFW_e703a08d", (String)"\u53ea\u80fd\u64cd\u4f5c\u672c\u65b9\u521b\u5efa\u7684\u6570\u636e\uff01"));
        }
        PurchaseMaterialRelation relation = new PurchaseMaterialRelation();
        relation.setId(id);
        if ("1".equals(materialRelation.getBlocked())) {
            relation.setBlocked("0");
        } else {
            relation.setBlocked("1");
        }
        this.purchaseMaterialRelationService.updateById((Object)relation);
        SaleMaterialRelation saleMaterialRelation = new SaleMaterialRelation();
        saleMaterialRelation.setBlocked(relation.getBlocked());
        saleMaterialRelation.setId(materialRelation.getRelationId());
        this.saleMaterialRelationService.updateById((Object)saleMaterialRelation);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:delete"})
    @PermissionDataOpt(businessType="materialRelation", beanClass=PurchaseMaterialRelationService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseMaterialRelationService.delPurchaseMaterialRelation(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseMaterialRelationService.delBatchPurchaseMaterialRelation(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMaterialRelation purchaseMaterialRelation = (PurchaseMaterialRelation)((Object)this.purchaseMaterialRelationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchaseMaterialRelation));
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(businessType="materialRelation")
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseMaterialRelationExportServiceImpl.class);
    }

    @Operation(summary="\u83b7\u53d6ERP\u6570\u636e", description="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseMaterialRelationService.getDataByErp();
        return Result.ok();
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseMaterialRelationService.pushDataToErp(ids);
        return Result.ok();
    }
}

