/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseOrganizationInfo_create")
public class PurchaseOrganizationInfoCreateOpenServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseOrganizationInfoService purchaseInformationRecordsService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String msg;
        Object orgCode;
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseOrganizationInfo> headList = new ArrayList<PurchaseOrganizationInfo>();
        ArrayList<String> codeList = new ArrayList<String>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            orgCode = object.getString("orgCode");
            if (CharSequenceUtil.isEmpty((CharSequence)orgCode)) {
                msg = I18nUtil.translate((String)"i18n_alert_VRAo[orgCode]xOLV_fb3530c9", (String)"\u7ec4\u7ec7\u7f16\u7801[orgCode]\u4e0d\u80fd\u4e3a\u7a7a");
                throw new ELSBootException(msg);
            }
            String orgCategoryCode = object.getString("orgCategoryCode");
            if (CharSequenceUtil.isEmpty((CharSequence)orgCategoryCode)) {
                String msg2 = I18nUtil.translate((String)"i18n_alert_VRAc[orgCategoryCode]xOLV_a6c070fb", (String)"\u7ec4\u7ec7\u7c7b\u578b[orgCategoryCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String[])new String[]{orgCategoryCode});
                throw new ELSBootException(msg2);
            }
            String code = orgCategoryCode + "_" + (String)orgCode;
            if (codeList.contains(code)) {
                String msg3 = I18nUtil.translate((String)"i18n_alert_VRAo[0]nVRAc[1]IOMKVIm_ec397c32", (String)"\u7ec4\u7ec7\u7f16\u7801[${0}]\u548c\u7ec4\u7ec7\u7c7b\u578b[${1}]\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5\uff01", (String[])new String[]{orgCode, orgCategoryCode});
                throw new ELSBootException(msg3);
            }
            codeList.add(code);
            PurchaseOrganizationInfo head = (PurchaseOrganizationInfo)((Object)ConvertUtils.convertDefault(PurchaseOrganizationInfo.class, (JSONObject)object, defaultHeadMap));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            head.setTemplateAccount(TenantContext.getTenant());
            head.setDataSource(CharSequenceUtil.emptyToDefault((CharSequence)head.getDataSource(), (String)"1"));
            headList.add(head);
        }
        Map<String, String> orgMap = this.purchaseInformationRecordsService.mapIdsByOrgCodeAndOrgCategoryCode(codeList);
        for (PurchaseOrganizationInfo obj : headList) {
            orgCode = obj.getOrgCategoryCode() + "," + obj.getOrgCode();
            if (!orgMap.containsKey(orgCode)) continue;
            msg = I18nUtil.translate((String)"i18n_alert_VRAo[0]nVRAc[1]IOMKVIm_ec397c32", (String)"\u7ec4\u7ec7\u7f16\u7801[${0}]\u548c\u7ec4\u7ec7\u7c7b\u578b[${1}]\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5!", (String[])new String[]{obj.getOrgCode(), obj.getOrgCategoryCode()});
            throw new ELSBootException(msg);
        }
        this.purchaseInformationRecordsService.saveBatch(headList);
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", headList);
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "org";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseOrganizationInfo.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }
}

