/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.api.dto.PurchaseBomItemPreViewDTO;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.mapper.PurchaseBomHeadMapper;
import com.els.modules.material.mapper.PurchaseBomItemMapper;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.vo.PurchaseBomHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBomHeadServiceImpl
extends BaseOpenServiceImpl<PurchaseBomHeadMapper, PurchaseBomHead, PurchaseBomHeadVO>
implements PurchaseBomHeadService {
    @Resource
    private PurchaseBomHeadMapper purchaseBomHeadMapper;
    @Resource
    private PurchaseBomItemMapper purchaseBomItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        if ("0".equals(purchaseBomHead.getNeedAudit())) {
            purchaseBomHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (StringUtils.isBlank((CharSequence)purchaseBomHead.getBomNumber())) {
            purchaseBomHead.setBomNumber(this.invokeBaseRpcService.getNextCode("bomNumber", (Object)purchaseBomHead));
        }
        this.purchaseBomHeadMapper.insert((Object)purchaseBomHead);
        this.insertData(purchaseBomHead, purchaseBomItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        int count;
        boolean flag;
        if (StrUtil.isNotBlank((CharSequence)purchaseBomHead.getVersion())) {
            try {
                if (Integer.parseInt(purchaseBomHead.getVersion()) <= 0) {
                    purchaseBomHead.setVersion("1");
                }
            }
            catch (Exception e) {
                purchaseBomHead.setVersion("1");
            }
        }
        boolean bl = flag = null != purchaseBomHead.getEffectiveDate() && null != purchaseBomHead.getExpiryDate() && purchaseBomHead.getExpiryDate().before(purchaseBomHead.getEffectiveDate());
        if (flag) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PurchaseBomHead::getMaterialNumber, (Object)purchaseBomHead.getMaterialNumber())).eq(PurchaseBomHead::getFactory, (Object)purchaseBomHead.getFactory())).eq(PurchaseBomHead::getVersion, (Object)purchaseBomHead.getVersion())).ne(BaseEntity::getId, (Object)purchaseBomHead.getId())).last(" limit 1");
        PurchaseBomHead bomHead = (PurchaseBomHead)((Object)((PurchaseBomHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        Assert.isTrue((null == bomHead || bomHead.getId().equals(purchaseBomHead.getId()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWWWtFIOMK_2f383a6c", (String)"\u5f53\u524dBOM\u5355\u636e\u5df2\u7ecf\u5b58\u5728"));
        if ("0".equals(purchaseBomHead.getNeedAudit())) {
            purchaseBomHead.setAuditStatus("");
            purchaseBomHead.setBomStatus(PurchaseBomStatus.NORMAL.getValue());
        }
        if ((count = this.purchaseBomHeadMapper.updateById((Object)purchaseBomHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBomItemMapper.deleteByMainId(purchaseBomHead.getId());
        this.insertData(purchaseBomHead, purchaseBomItemList);
    }

    private List<PurchaseBomItem> buildTree(List<PurchaseBomItem> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (PurchaseBomItem item : all) {
            item.setParentMaterialNumberList(Lists.newArrayList((Object[])new String[]{item.getParentMaterialNumber()}));
            item.setChildren(this.getChildren(item, all));
            if (!rootId.equals(item.getParentMaterialNumber()) || item.getMaterialNumber().equals(item.getParentMaterialNumber())) continue;
            parent.add(item);
        }
        return parent;
    }

    private List<PurchaseBomItem> getChildren(PurchaseBomItem bom, List<PurchaseBomItem> all) {
        ArrayList<PurchaseBomItem> childList = new ArrayList<PurchaseBomItem>(8);
        for (PurchaseBomItem child : all) {
            if (!bom.getMaterialNumber().equals(child.getParentMaterialNumber()) || bom.getMaterialNumber().equals(bom.getParentMaterialNumber())) continue;
            if (bom.getParentMaterialNumberList().contains(child.getMaterialNumber())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u5141\u8bb8\u7236\u9879\u7269\u6599\u7f16\u7801\u548c\u7269\u6599\u7f16\u7801\u76f8\u4e92\u5f15\u7528"));
            }
            if (null == child.getParentMaterialNumberList()) {
                child.setParentMaterialNumberList(Lists.newArrayList((Object[])new String[]{bom.getParentMaterialNumber()}));
                child.getParentMaterialNumberList().addAll(bom.getParentMaterialNumberList());
            }
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    private void insertData(PurchaseBomHead purchaseBomHead, List<PurchaseBomItem> purchaseBomItemList) {
        if (CollectionUtil.isNotEmpty(purchaseBomItemList)) {
            for (PurchaseBomItem entity : purchaseBomItemList) {
                entity.setMaterialOrder(StrUtil.emptyToDefault((CharSequence)entity.getMaterialOrder(), (String)"1"));
                entity.setParentMaterialNumber(StrUtil.emptyToDefault((CharSequence)entity.getParentMaterialNumber(), (String)""));
            }
            List<PurchaseBomItem> itemsTree = this.buildTree(purchaseBomItemList, "");
            this.sort(itemsTree);
            List<PurchaseBomItem> resultList = this.recursionTreeToList(itemsTree, null);
            int i = 1;
            for (PurchaseBomItem entity : resultList) {
                entity.setItemNumber(Integer.toString(i));
                entity.setHeadId(purchaseBomHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBomHead);
                entity.setId(IdWorker.getIdStr());
                ++i;
            }
            ((PurchaseBomItemService)SpringContextUtils.getBean(PurchaseBomItemService.class)).saveBatch(resultList);
        }
    }

    public List<PurchaseBomItem> recursionTreeToList(List<PurchaseBomItem> tree, List<PurchaseBomItem> result) {
        if (null == result) {
            result = new ArrayList<PurchaseBomItem>();
        }
        for (PurchaseBomItem item : tree) {
            result.add(item);
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.recursionTreeToList(item.getChildren(), result);
        }
        return result;
    }

    private void sort(List<PurchaseBomItem> itemsTree) {
        if (CollUtil.isNotEmpty(itemsTree)) {
            itemsTree.sort(Comparator.comparingDouble(x -> Double.parseDouble(x.getMaterialOrder())));
        }
        for (PurchaseBomItem item : itemsTree) {
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.sort(item.getChildren());
        }
    }

    @Override
    public void frozenBom(String id) {
        this.purchaseBomHeadMapper.frozenBom(id);
    }

    @Override
    public void thawBom(String id) {
        this.purchaseBomHeadMapper.thawBom(id);
    }

    @Override
    public void cancelBom(String id) {
        this.purchaseBomHeadMapper.cancelBom(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBomItemMapper.deleteByMainId(id);
        this.purchaseBomHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.purchaseBomItemMapper.deleteByMainIds(idList);
        ((PurchaseBomHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseBom", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List bomHeadList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseBomHead head2 : bomHeadList) {
            this.pushDataToErp(head2);
        }
    }

    @Override
    public Map<String, PurchaseBomHead> listBomByBomNumber(List<String> bomNumberList, String elsAccount) {
        if (CollUtil.isEmpty(bomNumberList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(PurchaseBomHead::getBomNumber, bomNumberList);
        wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseBomHead::getBomNumber, PurchaseBomHead::getNeedAudit, PurchaseBomHead::getAuditStatus, PurchaseBomHead::getBomStatus});
        List purchaseBomHeads = ((PurchaseBomHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return purchaseBomHeads.stream().collect(Collectors.toMap(PurchaseBomHead::getBomNumber, Function.identity(), (v1, v2) -> v2));
    }

    @Override
    public PurchaseBomHeadVO preView(String id) {
        PurchaseBomHead head = (PurchaseBomHead)((Object)((PurchaseBomHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseBomItem> itemList = this.purchaseBomItemMapper.selectByMainId(id);
        List<PurchaseBomItem> itemsTree = this.buildTree(itemList, "");
        this.sort(itemsTree);
        TreeMap<String, String> columnMap = this.recursionCol(itemsTree, null, 1);
        List<TreeMap<String, List<String>>> mapList = this.recursionLevel(itemsTree, null, 1);
        PurchaseBomHeadVO purchaseBomHeadVO = new PurchaseBomHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)purchaseBomHeadVO));
        purchaseBomHeadVO.setPurchaseBomItemPreViewList(mapList);
        List<PurchaseBomItemPreViewDTO> columnList = columnMap.keySet().stream().map(k -> {
            PurchaseBomItemPreViewDTO dto = new PurchaseBomItemPreViewDTO();
            dto.setColumnName(k);
            dto.setColumnTitle((String)columnMap.get(k));
            dto.setColumnOrder(Integer.valueOf(Integer.parseInt(k.replace("level", ""))));
            return dto;
        }).sorted(Comparator.comparingInt(PurchaseBomItemPreViewDTO::getColumnOrder)).collect(Collectors.toList());
        purchaseBomHeadVO.setColumnList(columnList);
        return purchaseBomHeadVO;
    }

    public TreeMap<String, String> recursionCol(List<PurchaseBomItem> tree, TreeMap<String, String> col, Integer level) {
        if (null == col) {
            col = new TreeMap();
        }
        for (PurchaseBomItem item : tree) {
            col.putIfAbsent("level" + level, I18nUtil.translate((String)"i18n_alert_n0DtSLAo_fbd522b0", (String)"\u7b2c${0}\u5c42\u7ea7\u7269\u6599\u7f16\u7801", (String[])new String[]{level + ""}));
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            this.recursionCol(item.getChildren(), col, level + 1);
        }
        return col;
    }

    public List<TreeMap<String, List<String>>> recursionLevel(List<PurchaseBomItem> tree, List<TreeMap<String, List<String>>> result, Integer level) {
        if (null == result) {
            result = new ArrayList<TreeMap<String, List<String>>>();
        }
        for (PurchaseBomItem item : tree) {
            TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
            map.put("level" + level, Lists.newArrayList((Object[])new String[]{item.getMaterialNumber()}));
            if (CollUtil.isNotEmpty(item.getChildren())) {
                List nextLevelList = item.getChildren().stream().map(PurchaseBomItem::getMaterialNumber).collect(Collectors.toList());
                map.put("level" + (level + 1), nextLevelList);
                this.recursionLevelChild(item.getChildren(), result, map, level + 2);
            }
            result.add(map);
        }
        return result;
    }

    public void recursionLevelChild(List<PurchaseBomItem> tree, List<TreeMap<String, List<String>>> result, TreeMap<String, List<String>> map, Integer level) {
        if (null == result) {
            result = new ArrayList<TreeMap<String, List<String>>>();
        }
        for (PurchaseBomItem item : tree) {
            if (!CollUtil.isNotEmpty(item.getChildren())) continue;
            List nextLevelList = item.getChildren().stream().map(PurchaseBomItem::getMaterialNumber).collect(Collectors.toList());
            ArrayList list = map.get("level" + level);
            if (CollUtil.isEmpty(list)) {
                list = Lists.newArrayList();
                map.put("level" + level, list);
            }
            map.get("level" + level).addAll(nextLevelList);
            this.recursionLevelChild(item.getChildren(), result, map, level + 1);
        }
    }

    private void pushDataToErp(PurchaseBomHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseBom", (Object)head);
    }

    protected List<PurchaseBomHeadVO> queryDetailByOpenApi(List<PurchaseBomHead> headList) {
        List headIds = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapperItem = Wrappers.lambdaQuery();
        wrapperItem.in(PurchaseBomItem::getHeadId, headIds);
        List purchaseMaterialItemList = this.purchaseBomItemMapper.selectList((Wrapper)wrapperItem);
        Map<String, List<PurchaseBomItem>> itemMap = purchaseMaterialItemList.stream().collect(Collectors.groupingBy(PurchaseBomItem::getHeadId));
        ArrayList<PurchaseBomHeadVO> result = new ArrayList<PurchaseBomHeadVO>();
        for (PurchaseBomHead head : headList) {
            PurchaseBomHeadVO vo = new PurchaseBomHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)vo));
            vo.setPurchaseBomItemList(itemMap.get(vo.getId()));
            result.add(vo);
        }
        return result;
    }

    public void deleteDetailByOpenApi(List<String> headIds, String halfDelete) {
        this.purchaseBomHeadMapper.deleteBatchIds(headIds);
        for (String id : headIds) {
            this.purchaseBomItemMapper.deleteByMainId(id);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(headIds);
    }

    public int insertBatchSomeColumn(List<PurchaseBomHead> entityList) {
        return ((PurchaseBomHeadMapper)this.baseMapper).insertBatchSomeColumn(entityList);
    }
}

