/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.excel.ExcelExportDTO;
import com.els.common.excel.poi.excel.entity.vo.ExcelTemplateHeadVO;
import com.els.common.excel.service.BaseExportService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateGroupDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.survey.entity.PurchaseSurveyAnswerLibrary;
import com.els.modules.survey.entity.PurchaseSurveyAnswerOption;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.enumerate.ServeyLibraryTypeEnum;
import com.els.modules.survey.service.PurchaseSurveyAnswerLibraryService;
import com.els.modules.survey.service.PurchaseSurveyAnswerService;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyItemService;
import com.els.modules.survey.service.PurchaseSurveyLibraryService;
import com.els.modules.survey.vo.PurchaseSurveyHeadVO;
import com.els.modules.survey.vo.PurchaseSurveyItemVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseSurveyHeadExportServiceImpl")
public class PurchaseSurveyHeadExportServiceImpl
extends BaseExportService<PurchaseSurveyHead, PurchaseSurveyHeadVO, PurchaseSurveyHead> {
    @Autowired
    private PurchaseSurveyHeadService purchaseSurveyHeadService;
    @Autowired
    private PurchaseSurveyLibraryService purchaseSurveyLibraryService;
    @Autowired
    private PurchaseSurveyItemService purchaseSurveyItemService;
    @Autowired
    private PurchaseSurveyAnswerService purchaseSurveyAnswerService;
    @Autowired
    private PurchaseSurveyAnswerLibraryService purchaseSurveyAnswerLibraryService;

    private TemplateConfigHeadDTO buildTemplateConfigHeadDTO(String fieldLabel, String fieldName, String fieldType) {
        TemplateConfigHeadDTO configHeadDTO = new TemplateConfigHeadDTO();
        configHeadDTO.setFieldLabel(fieldLabel);
        configHeadDTO.setFieldName(fieldName);
        configHeadDTO.setFieldType(fieldType);
        return configHeadDTO;
    }

    private TemplateConfigItemDTO buildTemplateConfigItemDTO(String fieldLabel, String fieldName, String fieldType, String groupCode) {
        TemplateConfigItemDTO item = new TemplateConfigItemDTO();
        item.setFieldLabel(fieldLabel);
        item.setFieldName(fieldName);
        item.setFieldType(fieldType);
        item.setGroupCode(groupCode);
        return item;
    }

    public ExcelTemplateHeadVO buildTemplateHeadVO(Map<String, Object> map) {
        String id = (String)map.get("id");
        PurchaseSurveyHead dbPurchaseSurveyHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)id)));
        String current = TenantContext.getTenant();
        TenantContext.setTenant((String)dbPurchaseSurveyHead.getElsAccount());
        List<PurchaseSurveyLibrary> purchaseSurveyLibraryList = this.purchaseSurveyLibraryService.selectByMainId(id);
        TenantContext.setTenant((String)current);
        TemplateHeadDTO headDTO = new TemplateHeadDTO();
        ArrayList headList = Lists.newArrayList();
        headList.add(this.buildTemplateConfigHeadDTO("\u7b54\u9898\u65f6\u95f4", "answerDate", "date"));
        headList.add(this.buildTemplateConfigHeadDTO("\u7b54\u9898\u4f01\u4e1a\u8d26\u53f7", "answerAccount", ""));
        headList.add(this.buildTemplateConfigHeadDTO("\u7b54\u9898\u4eba\u5b50\u8d26\u53f7", "answerSubAccount", ""));
        headList.add(this.buildTemplateConfigHeadDTO("\u7b54\u9898\u4eba\u540d\u5b57", "answerName", ""));
        headList.add(this.buildTemplateConfigHeadDTO("\u7b54\u9898\u4ebaip", "answerIp", ""));
        headDTO.setTemplateConfigHeadList((List)headList);
        TemplateGroupDTO groupDTO = new TemplateGroupDTO();
        groupDTO.setGroupName(dbPurchaseSurveyHead.getSurveyName());
        groupDTO.setGroupCode("purchaseSurveyAnswerLibraryList");
        headDTO.setTemplateGroupList((List)Lists.newArrayList((Object[])new TemplateGroupDTO[]{groupDTO}));
        ArrayList itemDTOList = Lists.newArrayList();
        for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraryList) {
            itemDTOList.add(this.buildTemplateConfigItemDTO(purchaseSurveyLibrary.getItemName(), purchaseSurveyLibrary.getItemName(), "", "purchaseSurveyAnswerLibraryList"));
        }
        headDTO.setTemplateConfigItemList((List)itemDTOList);
        return (ExcelTemplateHeadVO)Convert.convert(ExcelTemplateHeadVO.class, (Object)headDTO);
    }

    public List<PurchaseSurveyHeadVO> queryExportData(QueryWrapper<PurchaseSurveyHead> queryWrapper, PurchaseSurveyHead map, Map<String, String[]> paramMap) {
        String id = map.getId();
        PurchaseSurveyHead purchaseSurveyHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)id)));
        if (null == id) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        PurchaseSurveyHeadVO vo = (PurchaseSurveyHeadVO)((Object)Convert.convert(PurchaseSurveyHeadVO.class, (Object)((Object)purchaseSurveyHead)));
        String current = TenantContext.getTenant();
        TenantContext.setTenant((String)purchaseSurveyHead.getElsAccount());
        List<PurchaseSurveyItem> purchaseSurveyItemList = this.purchaseSurveyItemService.selectByMainId(id);
        vo.setPurchaseSurveyItemList(purchaseSurveyItemList);
        TenantContext.setTenant((String)current);
        return Lists.newArrayList((Object[])new PurchaseSurveyHeadVO[]{vo});
    }

    public long queryExportDataCount(QueryWrapper<PurchaseSurveyHead> queryWrapper, PurchaseSurveyHead map, Map<String, String[]> paramMap) {
        return 0L;
    }

    public String getBusinessType() {
        return "";
    }

    public String getBeanName() {
        return "";
    }

    private ExcelExportClassColumnDTO buildColumn(String fileName) {
        ExcelExportClassColumnDTO d = new ExcelExportClassColumnDTO();
        d.setFileName(fileName);
        d.setFileType("");
        return d;
    }

    public ExcelExportDTO builderExcelEntityList(List<PurchaseSurveyHeadVO> queryDataList, Class<PurchaseSurveyHeadVO> clazz, String taskId, Long count) {
        PurchaseSurveyHeadVO vo = queryDataList.get(0);
        List<ExcelExportClassColumnDTO> column = this.buildExcelExportData(PurchaseSurveyItemVO.class, null, null);
        ArrayList cList = Lists.newArrayList();
        for (ExcelExportClassColumnDTO c : column) {
            if (!c.getFileName().equals("purchaseSurveyAnswerLibraryList")) continue;
            c.setChildren((List)cList);
        }
        ArrayList dataList = new ArrayList();
        String current = TenantContext.getTenant();
        if (CollUtil.isNotEmpty(queryDataList)) {
            TenantContext.setTenant((String)queryDataList.get(0).getElsAccount());
        }
        List<PurchaseSurveyLibrary> purchaseSurveyLibraryList = this.purchaseSurveyLibraryService.selectByMainId(vo.getId());
        for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraryList) {
            cList.add(this.buildColumn(purchaseSurveyLibrary.getItemName()));
        }
        for (PurchaseSurveyItem purchaseSurveyItem : vo.getPurchaseSurveyItemList()) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("answerDate", null == purchaseSurveyItem.getAnswerDate() ? "" : DateUtils.formatDate((Date)purchaseSurveyItem.getAnswerDate(), (String)"yyyy-MM-dd"));
            values.put("answerAccount", purchaseSurveyItem.getAnswerAccount());
            values.put("answerSubAccount", purchaseSurveyItem.getAnswerSubAccount());
            values.put("answerName", purchaseSurveyItem.getAnswerName());
            values.put("answerIp", purchaseSurveyItem.getAnswerIp());
            ArrayList surveyResultList = new ArrayList();
            HashMap<String, StringBuffer> surveyResultMap = new HashMap<String, StringBuffer>();
            List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList = this.purchaseSurveyAnswerLibraryService.selectByMainId(purchaseSurveyItem.getId());
            for (PurchaseSurveyAnswerLibrary purchaseSurveyAnswerLibrary : purchaseSurveyAnswerLibraryList) {
                StringBuffer stringBuffer;
                String itemType = purchaseSurveyAnswerLibrary.getItemType();
                List<PurchaseSurveyAnswerOption> purchaseSurveyAnswerOptionList = purchaseSurveyAnswerLibrary.getPurchaseSurveyAnswerOptionList();
                if (ServeyLibraryTypeEnum.SCORE.getValue().equals(itemType) || ServeyLibraryTypeEnum.INPUT.getValue().equals(itemType)) {
                    stringBuffer = new StringBuffer();
                    for (PurchaseSurveyAnswerOption purchaseSurveyAnswerOption : purchaseSurveyAnswerOptionList) {
                        if (StrUtil.isNotBlank((CharSequence)purchaseSurveyAnswerOption.getOptionName())) {
                            stringBuffer.append(purchaseSurveyAnswerOption.getOptionName() + ":" + purchaseSurveyAnswerOption.getOptionComment() + "  ");
                            continue;
                        }
                        stringBuffer.append(purchaseSurveyAnswerOption.getOptionComment());
                    }
                    surveyResultMap.put(purchaseSurveyAnswerLibrary.getItemName(), stringBuffer);
                }
                if (!ServeyLibraryTypeEnum.CHECK_BOX.getValue().equals(itemType) && !ServeyLibraryTypeEnum.RADIO.getValue().equals(itemType) && !ServeyLibraryTypeEnum.SELECT.getValue().equals(itemType)) continue;
                stringBuffer = new StringBuffer();
                for (PurchaseSurveyAnswerOption purchaseSurveyAnswerOption : purchaseSurveyAnswerOptionList) {
                    if (!StrUtil.isNotBlank((CharSequence)purchaseSurveyAnswerOption.getOptionName()) || !"1".equals(purchaseSurveyAnswerOption.getSelected())) continue;
                    stringBuffer.append(purchaseSurveyAnswerOption.getOptionName() + ";");
                }
                surveyResultMap.put(purchaseSurveyAnswerLibrary.getItemName(), stringBuffer);
            }
            surveyResultList.add(surveyResultMap);
            values.put("purchaseSurveyAnswerLibraryList", surveyResultList);
            dataList.add(values);
        }
        TenantContext.setTenant((String)current);
        return new ExcelExportDTO(column, JSON.toJSONString(dataList), null, null, null);
    }

    public List<ExcelExportClassColumnDTO> buildExcelExportData(Class<?> clazz, List<ExcelExportClassColumnDTO> result, Set<String> typeList) {
        return super.buildExcelExportData(clazz, result, typeList);
    }
}

