/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.trace.MqKeyHolder;
import com.els.modules.message.service.MsgService;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class BusinessMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(BusinessMessageConsumer.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private MsgService msgService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(value="input")
    public void receive(Message<String> message) {
        String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
        MqKeyHolder.set((String)key);
        String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
        if ("1".equals(msgStatus)) {
            log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
            return;
        }
        String msgBody = (String)message.getPayload();
        log.info("msgBody: " + msgBody);
        String errorInfo = "";
        try {
            JSONObject msgObj = JSONObject.parseObject((String)msgBody);
            if (!msgObj.containsKey((Object)"busAccount")) {
                throw new ELSBootException("busAccount can not be blank");
            }
            if (!msgObj.containsKey((Object)"msgKey")) {
                throw new ELSBootException("msgKey can not be blank");
            }
            if (!msgObj.containsKey((Object)"businessType")) {
                throw new ELSBootException("businessType can not be blank");
            }
            if (!msgObj.containsKey((Object)"operateType")) {
                throw new ELSBootException("operateType can not be blank");
            }
            if (!msgObj.containsKey((Object)"receiveList")) {
                throw new ELSBootException("receiveList can not be blank");
            }
            if (!msgObj.containsKey((Object)"sendObj")) {
                throw new ELSBootException("sendObj can not be blank");
            }
            if (!msgObj.containsKey((Object)"businessObj")) {
                throw new ELSBootException("businessObj can not be blank");
            }
            this.msgService.sendMsg(msgObj);
            msgStatus = "1";
        }
        catch (Exception e) {
            log.error("send_msg_failed:" + msgBody, (Throwable)e);
            msgStatus = "2";
            errorInfo = e.getMessage();
        }
        finally {
            this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
            MqKeyHolder.remove();
        }
    }
}

