/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.vo.MsgVO;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendMsgImpl
implements ISendMsgService {
    private static final Logger log = LoggerFactory.getLogger(AbstractSendMsgImpl.class);
    protected static final String DING_TALK_SEND_MSG_URL = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    protected static final String DING_TALK_OAUTH2_URL = "/els/account/thirdLogin/render/%s/mobile/dingtalk_account";
    protected static final String FEISHU_SEND_MSG_URL = "https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=union_id";
    protected static final String FEISHU_OAUTH2_URL = "/els/account/thirdLogin/render/%s/mobile/feishu";
    protected static final String WECHAT_EP_SEND_MSG_URL = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
    protected static final String WECHAT_EP_OAUTH2_URL = "/els/account/thirdLogin/render/%s/mobile/wechat_enterprise_web";
    protected static final String WECHAT_MP_SEND_MSG_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send";
    protected static final String WECHAT_MP_OAUTH2_URL = "/els/account/thirdLogin/render/%s/mobile/wechat_mp";
    protected static final String WECHAT_MP_DEVELOP_OAUTH2_URL = "/els/account/thirdLogin/render/%s/mobile/wechat_enterprise_develop";
    protected Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private static final InvokeAccountRpcService RPC_SERVICE = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);

    public abstract void doSendMsg(MsgVO var1);

    @Override
    public void sendMsg(MsgVO msgVO) {
        this.doSendMsg(msgVO);
        try {
            JSONObject object = new JSONObject();
            object.put("logType", (Object)2);
            object.put("elsAccount", (Object)msgVO.getSendAccount().getElsAccount());
            object.put("userid", (Object)msgVO.getSendAccount().getSubAccount());
            object.put("username", (Object)msgVO.getSendAccount().getRealname());
            object.put("busModule", (Object)msgVO.getBusinessType());
            object.put("operateName", (Object)msgVO.getOperateType());
            String msgContent = msgVO.getMsgContent();
            if (StrUtil.isNotBlank((CharSequence)msgContent)) {
                if (msgVO.getParams() != null) {
                    HashMap paramsMap = new HashMap();
                    BeanUtil.copyProperties((Object)msgVO.getParams(), paramsMap, (String[])new String[0]);
                    msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, paramsMap);
                }
                object.put("logContent", (Object)msgContent);
            }
            MqUtil.sendLogMsg((String)object.toJSONString());
        }
        catch (Exception e) {
            log.error("AbstractSendMsgImpl_log failed:", (Throwable)e);
        }
    }

    protected String getConcat(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return "?";
        }
        return url.contains("?") ? "&" : "?";
    }

    protected StringBuilder getServiceBuilder() {
        return new StringBuilder(this.config.get("service.address"));
    }

    protected String getUrl(String urlParam, String busAccount) {
        String routeUri = URLUtil.encodeAll((String)urlParam);
        return this.getServiceBuilder().append(String.format(this.getOauthUrl(), busAccount)).append("?routeUri=").append(routeUri).toString();
    }

    protected String getOauthUrl() {
        throw new ELSBootException("Please rewrite method to get oauth url");
    }

    protected JustAuthConfigDTO getJustConfig(String busAccount, String type) {
        JustAuthConfigDTO config = RPC_SERVICE.getOneConfig(busAccount, type);
        if (null == config) {
            log.error(":::\u8bf7\u5148\u5b8c\u5584\u7b2c\u4e09\u65b9\u51ed\u8bc1\u7ba1\u7406\u4e2d\u7684\u914d\u7f6e:{}", (Object)type);
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWMQnICUiER_2444fda8", (String)"\u8bf7\u5148\u5b8c\u5584\u7b2c\u4e09\u65b9\u51ed\u8bc1\u914d\u7f6e:") + type);
        }
        return config;
    }

    protected boolean checkIfConfigByCurrentAccount(MsgVO msg, String bussAccount) {
        Map<String, List<ElsMsgConfigItem>> msgItemAccountMap = msg.getMsgItemAccountMap();
        return msgItemAccountMap.containsKey(bussAccount);
    }
}

