/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxEnterpriseSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxEnterpriseSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("enter into WxEnterpriseSendMsgImpl.doSendMsg");
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccountDTO account = msg.getReceiveAccount();
            MessageInvokeAccountService thirdAccountService = (MessageInvokeAccountService)SpringContextUtils.getBean(MessageInvokeAccountService.class);
            List<ThirdAccountDTO> list = thirdAccountService.getThirdAccount(msg.getBusAccount(), account.getId(), "WECHAT_ENTERPRISE");
            if (list.isEmpty()) {
                log.error("receive not bind wechat_enterprise");
                return;
            }
            JustAuthConfigDTO config = this.getJustConfig(msg.getBusAccount(), "WECHAT_ENTERPRISE");
            if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
                log.error("::: JustAuthConfig \u914d\u7f6e\u4e0d\u5b58\u5728");
                return;
            }
            String urlString = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + ThirdTokenUtil.getWechatEpToken((String)msg.getBusAccount(), (JustAuthConfigDTO)config);
            JSONObject body = new JSONObject();
            if (StrUtil.isEmpty((CharSequence)config.getAgentId())) {
                log.warn("::: JustAuthConfig \u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            body.put("agentid", (Object)config.getAgentId());
            body.put("msgtype", (Object)"textcard");
            JSONObject textcard = new JSONObject();
            textcard.put("btntxt", (Object)"");
            textcard.put("title", (Object)item.getMsgTitle());
            textcard.put("url", (Object)this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam(), msg.getBusAccount()));
            log.info(":::\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u6d88\u606furl:{}", textcard.get((Object)"url"));
            if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
                textcard.put("description", (Object)msgContent);
            }
            body.put("textcard", (Object)textcard);
            for (ThirdAccountDTO thirdAccount : list) {
                body.put("touser", (Object)thirdAccount.getThirdUserUuid());
                log.info(":::WxEnterpriseSendMsgImpl msgBody:{}", (Object)body.toString());
                String result = HttpUtil.post((String)urlString, (String)body.toString());
                log.info(":::WxEnterpriseSendMsgImpl send message result:{}", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("WxEnterpriseSendMsgImpl.doSendMsg failed:", (Throwable)e);
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/wechat_enterprise_web";
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

