/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.entity.ElsMsgRecord;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.service.ElsMsgRecordService;
import com.els.modules.message.service.impl.ElsMsgRecordServiceImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.uflo.enums.WorkFlowType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstationMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(InstationMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccountDTO account = msg.getReceiveAccount();
            ElsSubAccountDTO sendAccount = msg.getSendAccount();
            ElsMsgRecord record = new ElsMsgRecord();
            if (StrUtil.isEmpty((CharSequence)account.getId())) {
                return;
            }
            if (msg.getOperateType().contains("submitAudit")) {
                String link = null;
                BaseRpcService baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class);
                List todoListLink = baseRpcService.queryDictItemsByCode("todo_list_link", account.getElsAccount());
                Map<String, String> todoListLinkMap = todoListLink.stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
                link = msg.getOperateType().contains(WorkFlowType.BPMN.getValue()) ? todoListLinkMap.get(WorkFlowType.BPMN.getValue()) : todoListLinkMap.get(WorkFlowType.UFLO.getValue());
                item.setLinkUrl(link);
            }
            record.setBusinessType(msg.getBusinessType());
            record.setOperateType(msg.getOperateType());
            record.setElsAccount(account.getElsAccount());
            record.setSubAccount(account.getSubAccount());
            record.setReceiverId(account.getId());
            record.setReceiverName(account.getRealname());
            record.setSendElsAccount(sendAccount.getElsAccount());
            record.setSendSubAccount(sendAccount.getSubAccount());
            record.setSendId(sendAccount.getId());
            record.setSendName(sendAccount.getRealname());
            String msgTitle = item.getMsgTitle();
            if (StrUtil.isNotBlank((CharSequence)msgTitle) && msg.getParams() != null) {
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                BeanUtil.copyProperties((Object)msg.getParams(), paramsMap, (String[])new String[0]);
                try {
                    msgTitle = TemplateParseUtil.getTemplateText("", msgTitle, paramsMap);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            record.setMsgTitle(msgTitle);
            record.setSendTime(new Date());
            record.setCreateBy(sendAccount.getRealname());
            record.setCreateTime(new Date());
            record.setHandleFlag("0");
            String msgContent = item.getMsgContent();
            if (StrUtil.isNotBlank((CharSequence)msgContent)) {
                if (msg.getParams() != null) {
                    HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                    BeanUtil.copyProperties((Object)msg.getParams(), paramsMap, (String[])new String[0]);
                    msgContent = TemplateParseUtil.getTemplateText("", msgContent, paramsMap);
                }
                record.setMsgContent(msgContent);
            }
            if (StrUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                record.setLinkUrl(item.getLinkUrl().trim() + "?" + msg.getUrlParam());
            }
            ElsMsgRecordService msgRecordService = (ElsMsgRecordService)SpringContextUtils.getBean(ElsMsgRecordServiceImpl.class);
            msgRecordService.save((Object)record);
        }
        catch (Exception e) {
            log.error("InstationMsgImpl_doSendMsg_failed:", (Throwable)e);
        }
    }
}

