/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsMsgConfigItem item = msg.getElsMsgConfigItem();
        ElsSubAccountDTO account = msg.getReceiveAccount();
        MessageInvokeAccountService thirdAccountService = (MessageInvokeAccountService)SpringContextUtils.getBean(MessageInvokeAccountService.class);
        List<ThirdAccountDTO> list = thirdAccountService.getThirdAccount(msg.getBusAccount(), account.getId(), "WECHAT_MP");
        if (list.isEmpty()) {
            log.error("receive not bind WECHAT_MP");
            return;
        }
        if (StrUtil.isBlank((CharSequence)item.getTemplateNumber())) {
            log.error(":::\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u914d\u7f6e\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u53f7...");
            return;
        }
        JustAuthConfigDTO config = this.getJustConfig(msg.getBusAccount(), "WECHAT_MP");
        if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
            log.error("::: JustAuthConfig \u914d\u7f6e\u4e0d\u5b58\u5728");
            return;
        }
        String urlString = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + ThirdTokenUtil.getWechatMpToken((String)msg.getBusAccount(), (JustAuthConfigDTO)config);
        JSONObject body = new JSONObject();
        body.put("template_id", (Object)item.getTemplateNumber());
        body.put("url", (Object)this.getUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), msg.getBusAccount()));
        if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
            JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
            String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
            body.put("data", JSONObject.parse((String)msgContent));
        }
        for (ThirdAccountDTO thirdAccount : list) {
            body.put("touser", (Object)thirdAccount.getThirdUserUuid());
            log.info(":::WxSendMsgImpl msgBody:{}", (Object)body.toString());
            String result = HttpUtil.post((String)urlString, (String)body.toString());
            log.info(":::WxSendMsgImpl send message result:{}", (Object)result);
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/wechat_mp";
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

