/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.entity.ElsMsgRecord;
import com.els.modules.message.service.ElsMsgRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d88\u606f\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/message/elsMsgRecord"})
public class ElsMsgRecordController
extends BaseController<ElsMsgRecord, ElsMsgRecordService> {
    @Autowired
    private ElsMsgRecordService elsMsgRecordService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsMsgRecord elsMsgRecord, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsMsgRecord), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"sub_account", (Object)this.getCurrentUser().getSubAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsMsgRecordService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u6d88\u606f\u8bb0\u5f55-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsMsgRecord elsMsgRecord) {
        this.elsMsgRecordService.saveElsMsgRecord(elsMsgRecord);
        return Result.ok((Object)((Object)elsMsgRecord));
    }

    @AutoLog(value="\u6d88\u606f\u8bb0\u5f55-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsMsgRecord elsMsgRecord) {
        this.elsMsgRecordService.updateElsMsgRecord(elsMsgRecord);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6d88\u606f\u8bb0\u5f55-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsMsgRecordService.delElsMsgRecord(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6d88\u606f\u8bb0\u5f55-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsMsgRecordService.delBatchElsMsgRecord(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u6279\u91cf\u5df2\u8bfb", notes="\u6279\u91cf\u5df2\u8bfb")
    @PostMapping(value={"/readBatch"})
    @RequiresPermissions(value={"elsMsgRecord#ElsMsgRecord:readBatch"})
    public Result<?> readBatch(@RequestBody List<String> ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.set(ElsMsgRecord::getHandleFlag, (Object)"1")).set(ElsMsgRecord::getHandleTime, (Object)new Date());
        wrapper.in(BaseEntity::getId, ids);
        this.elsMsgRecordService.update((Object)new ElsMsgRecord(), (Wrapper)wrapper);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsMsgRecord elsMsgRecord = (ElsMsgRecord)((Object)this.elsMsgRecordService.getById((Serializable)((Object)id)));
        if ("0".equals(elsMsgRecord.getHandleFlag())) {
            ElsMsgRecord update = new ElsMsgRecord();
            update.setHandleFlag("1");
            update.setId(elsMsgRecord.getId());
            update.setHandleTime(new Date());
            this.elsMsgRecordService.updateById((Object)update);
        }
        return Result.ok((Object)((Object)elsMsgRecord));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e\u6570\u91cf", notes="\u67e5\u8be2\u5f85\u529e\u6570\u91cf")
    @GetMapping(value={"/queryBacklogCount"})
    public Result<?> queryBacklogCount() {
        List recordList = this.elsMsgRecordService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"handle_flag", (Object)"0")).eq((Object)"sub_account", (Object)this.getCurrentUser().getSubAccount()));
        Map<String, List<ElsMsgRecord>> map = recordList.stream().collect(Collectors.groupingBy(ElsMsgRecord::getBusinessType));
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        for (String key : map.keySet()) {
            resultMap.put(key, map.get(key).size());
        }
        return Result.ok(resultMap);
    }
}

