/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.sample.api.dto.PurchaseSampleItemDTO;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.entity.SampleSupplierList;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.PurchaseSampleTrackingItemService;
import com.els.modules.sample.service.SampleSupplierListService;
import com.els.modules.sample.vo.PurchaseSampleHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sample/purchaseSampleHead"})
@Api(tags={"\u91c7\u8d2d\u6837\u54c1\u5934"})
public class PurchaseSampleHeadController
extends BaseController<PurchaseSampleHead, PurchaseSampleHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSampleHeadController.class);
    @Autowired
    private PurchaseSampleHeadService purchaseSampleHeadService;
    @Autowired
    private PurchaseSampleItemService purchaseSampleItemService;
    @Autowired
    private PurchaseSampleTrackingItemService purchaseSampleTrackingItemService;
    @Autowired
    private SampleSupplierListService sampleSupplierListService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseSampleHead purchaseSampleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseSampleHeadVO purchaseSampleHeadPage) {
        PurchaseSampleHead purchaseSampleHead = new PurchaseSampleHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleHeadPage), (Object)((Object)purchaseSampleHead));
        this.purchaseSampleHeadService.saveMain(purchaseSampleHead, purchaseSampleHeadPage.getPurchaseSampleItemList(), purchaseSampleHeadPage.getPurchaseSampleTrackingItemList(), purchaseSampleHeadPage.getSampleSupplierList(), purchaseSampleHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseSampleHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseSampleHeadVO purchaseSampleHeadPage) {
        PurchaseSampleHead purchaseSampleHead = new PurchaseSampleHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleHeadPage), (Object)((Object)purchaseSampleHead));
        this.purchaseSampleHeadService.updateMain(purchaseSampleHead, purchaseSampleHeadPage.getPurchaseSampleItemList(), purchaseSampleHeadPage.getPurchaseSampleTrackingItemList(), purchaseSampleHeadPage.getSampleSupplierList(), purchaseSampleHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseSampleHeadVO purchaseSampleHeadPage) {
        PurchaseSampleHead purchaseSampleHead = new PurchaseSampleHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleHeadPage), (Object)((Object)purchaseSampleHead));
        this.purchaseSampleHeadService.publish(purchaseSampleHeadPage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSampleHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u901a\u8fc7id\u5173\u95ed")
    @ApiOperation(value="\u901a\u8fc7id\u5173\u95ed", notes="\u901a\u8fc7id\u5173\u95ed")
    @GetMapping(value={"/colse"})
    public Result<?> colse(@RequestParam(name="id") String id) {
        this.purchaseSampleHeadService.colse(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u901a\u8fc7id\u5173\u95ed")
    @ApiOperation(value="\u901a\u8fc7id\u5173\u95ed", notes="\u901a\u8fc7id\u5173\u95ed")
    @GetMapping(value={"/cutOff"})
    public Result<?> cutOff(@RequestParam(name="id") String id) {
        this.purchaseSampleHeadService.cutOff(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u884c", value="\u901a\u8fc7\u884c\u5173\u95ed")
    @ApiOperation(value="\u901a\u8fc7\u884c\u5173\u95ed", notes="\u901a\u8fc7\u884c\u5173\u95ed")
    @PostMapping(value={"/colseByItems"})
    public Result<?> colseByItems(@RequestBody List<PurchaseSampleItem> items) {
        this.purchaseSampleHeadService.colseByItems(items);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u884c", value="\u901a\u8fc7\u884c\u7b7e\u6536")
    @ApiOperation(value="\u901a\u8fc7\u884c\u7b7e\u6536", notes="\u901a\u8fc7\u884c\u7b7e\u6536")
    @PostMapping(value={"/signSample"})
    public Result<?> signSample(@RequestBody List<PurchaseSampleItem> items) {
        this.purchaseSampleHeadService.signSample(items);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseSampleHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadService.getById((Serializable)((Object)id)));
        PurchaseSampleHeadVO purchaseSampleHeadVO = new PurchaseSampleHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleHead), (Object)((Object)purchaseSampleHeadVO));
        List<PurchaseSampleItem> purchaseSampleItemList = this.purchaseSampleItemService.selectByMainId(id);
        purchaseSampleHeadVO.setPurchaseSampleItemList(purchaseSampleItemList);
        List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList = this.purchaseSampleTrackingItemService.selectByMainId(id);
        purchaseSampleHeadVO.setPurchaseSampleTrackingItemList(purchaseSampleTrackingItemList);
        List<SampleSupplierList> sampleSupplierListList = this.sampleSupplierListService.selectByMainId(id);
        purchaseSampleHeadVO.setSampleSupplierList(sampleSupplierListList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseSampleHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseSampleHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u884c")
    @GetMapping(value={"/queryPurchaseSampleItemByMainId"})
    public Result<?> queryPurchaseSampleItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseSampleItem> purchaseSampleItemList = this.purchaseSampleItemService.selectByMainId(id);
        return Result.ok(purchaseSampleItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u8ddf\u8e2a\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u8ddf\u8e2a\u884c")
    @GetMapping(value={"/queryPurchaseSampleTrackingItemByMainId"})
    public Result<?> queryPurchaseSampleTrackingItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList = this.purchaseSampleTrackingItemService.selectByMainId(id);
        return Result.ok(purchaseSampleTrackingItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u5934id\u67e5\u8be2\u6837\u54c1\u4f9b\u5e94\u5546", notes="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u5934id\u67e5\u8be2\u6837\u54c1\u4f9b\u5e94\u5546")
    @GetMapping(value={"/querySampleSupplierListByMainId"})
    public Result<?> querySampleSupplierListListByMainId(@RequestParam(name="id") String id) {
        List<SampleSupplierList> sampleSupplierListList = this.sampleSupplierListService.selectByMainId(id);
        return Result.ok(sampleSupplierListList);
    }

    @ApiOperation(value="\u5206\u9875\u884c\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u884c\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemEeliveryList"})
    public Result<?> itemEeliveryList(PurchaseSampleItem purchaseSampleItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleItem), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"item_status", (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6837\u54c1\u8f6c\u9700\u6c42", notes="\u6837\u54c1\u8f6c\u9700\u6c42")
    @PostMapping(value={"/transformRequest"})
    public Result<?> transformRequest(@RequestBody List<PurchaseSampleItemDTO> itemList) {
        String bySample = this.purchaseSampleItemService.transformRequest(itemList);
        return Result.ok((String)("\u8f6c\u9700\u6c42\u6c60\u6210\u529f,\u5355\u53f7\u4e3a:" + bySample));
    }
}

