/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldTransferHead;
import com.els.modules.mould.entity.PurchaseMouldTransferItem;
import com.els.modules.mould.service.PurchaseMouldTransferHeadService;
import com.els.modules.mould.service.PurchaseMouldTransferItemService;
import com.els.modules.mould.vo.PurchaseMouldTransferHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mould/purchaseMouldTransferHead"})
@Api(tags={"\u91c7\u8d2d\u6a21\u5177\u8c03\u62e8"})
public class PurchaseMouldTransferHeadController
extends BaseController<PurchaseMouldTransferHead, PurchaseMouldTransferHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMouldTransferHeadController.class);
    @Autowired
    private PurchaseMouldTransferItemService purchaseMouldTransferItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseMouldTransferHead purchaseMouldTransferHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMouldTransferHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseMouldTransferHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6a21\u5177\u8c03\u62e8", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseMouldData mouldData) {
        PurchaseMouldTransferHead transferHead = new PurchaseMouldTransferHead();
        transferHead.setCompany(mouldData.getCompany());
        transferHead.setPurchaseGroup(mouldData.getPurchaseGroup());
        transferHead.setPurchaseOrg(mouldData.getPurchaseOrg());
        transferHead.setSendElsAccount(mouldData.getToElsAccount());
        transferHead.setSendSupplierCode(mouldData.getSupplierCode());
        transferHead.setSendSupplierName(mouldData.getSupplierName());
        ArrayList<PurchaseMouldTransferItem> itemList = new ArrayList<PurchaseMouldTransferItem>(1);
        PurchaseMouldTransferItem item = new PurchaseMouldTransferItem();
        BeanUtils.copyProperties((Object)((Object)mouldData), (Object)((Object)item));
        item.setMouldDataId(mouldData.getId());
        itemList.add(item);
        ((PurchaseMouldTransferHeadService)this.service).saveMain(transferHead, itemList);
        return Result.ok((Object)((Object)transferHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6a21\u5177\u8c03\u62e8", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseMouldTransferHeadVO headVO) {
        PurchaseMouldTransferHead transferHead = new PurchaseMouldTransferHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)transferHead));
        ((PurchaseMouldTransferHeadService)this.service).updateMain(transferHead, headVO.getPurchaseMouldTransferItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6a21\u5177\u8c03\u62e8", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseMouldTransferHeadVO headVO) {
        PurchaseMouldTransferHead transferHead = new PurchaseMouldTransferHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)transferHead));
        ((PurchaseMouldTransferHeadService)this.service).publish(transferHead, headVO.getPurchaseMouldTransferItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6a21\u5177\u8c03\u62e8", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseMouldTransferHeadService)this.service).delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMouldTransferHead dbHead = (PurchaseMouldTransferHead)((Object)((PurchaseMouldTransferHeadService)this.service).getById((Serializable)((Object)id)));
        PurchaseMouldTransferHeadVO headVO = new PurchaseMouldTransferHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseMouldTransferItem> itemList = this.purchaseMouldTransferItemService.selectByMainId(id);
        headVO.setPurchaseMouldTransferItemList(itemList);
        return Result.ok((Object)((Object)headVO));
    }
}

