/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SaleSpcn;
import com.els.modules.spcn.enumerate.PurchaseConfirmStatusEnum;
import com.els.modules.spcn.enumerate.SpcnStatusEnum;
import com.els.modules.spcn.mapper.PurchaseSpcnMapper;
import com.els.modules.spcn.mapper.SaleSpcnMapper;
import com.els.modules.spcn.service.PurchaseSpcnService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSpcnServiceImpl
extends BaseServiceImpl<PurchaseSpcnMapper, PurchaseSpcn>
implements PurchaseSpcnService {
    @Resource
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Resource
    private SaleSpcnMapper saleSpcnMapper;

    @Override
    public void savePurchaseSpcn(PurchaseSpcn purchaseSpcn) {
        ((PurchaseSpcnMapper)this.baseMapper).insert((Object)purchaseSpcn);
    }

    @Override
    public void updatePurchaseSpcn(PurchaseSpcn purchaseSpcn) {
        ((PurchaseSpcnMapper)this.baseMapper).updateById((Object)purchaseSpcn);
    }

    @Override
    public void delPurchaseSpcn(String id) {
        ((PurchaseSpcnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseSpcn(List<String> idList) {
        ((PurchaseSpcnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOperation(PurchaseSpcn spcn, List<PurchaseAttachmentDTO> attachments) {
        String urlParam;
        PurchaseSpcn purchaseSpcn = (PurchaseSpcn)((Object)this.getById((Serializable)((Object)spcn.getId())));
        if (purchaseSpcn == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u5237\u65b0\u9875\u9762"));
        }
        SaleSpcn saleSpcn = (SaleSpcn)((Object)this.saleSpcnMapper.selectById((Serializable)((Object)spcn.getRelationId())));
        saleSpcn.setPurchaseConfirmStatus(spcn.getPurchaseConfirmStatus());
        if (PurchaseConfirmStatusEnum.CONFIRMED.getValue().equals(spcn.getPurchaseConfirmStatus())) {
            spcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            saleSpcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
        } else {
            spcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            saleSpcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
        }
        this.updatePurchaseSpcn(spcn);
        this.saleSpcnMapper.updateById((Object)saleSpcn);
        if (attachments != null) {
            ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseAttachmentDTO PurchaseAttachment : attachments) {
                if (!spcn.getElsAccount().equals(PurchaseAttachment.getUploadElsAccount())) continue;
                SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)PurchaseAttachment, (Object)saleAttachment);
                saleAttachment.setId(null);
                saleAttachment.setElsAccount(saleSpcn.getElsAccount());
                saleAttachment.setHeadId(saleSpcn.getId());
                saleAttachments.add(saleAttachment);
            }
            if (!saleAttachments.isEmpty()) {
                this.ecnInvokeBaseRpcService.insertSaleBatchSomeColumn(saleAttachments);
            }
        }
        if (PurchaseConfirmStatusEnum.CONFIRMED.getValue().equals(spcn.getPurchaseConfirmStatus())) {
            urlParam = "id=" + purchaseSpcn.getRelationId();
            super.sendMsg(purchaseSpcn.getElsAccount(), purchaseSpcn.getToElsAccount(), (Object)purchaseSpcn, urlParam, "spcn", "confirm");
        } else {
            urlParam = "id=" + purchaseSpcn.getRelationId();
            super.sendMsg(purchaseSpcn.getElsAccount(), purchaseSpcn.getToElsAccount(), (Object)purchaseSpcn, urlParam, "spcn", "refund");
        }
    }
}

