/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.calendar.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.calendar.entity.PurchaseFactoryCalendarHead;
import com.els.modules.calendar.entity.PurchaseFactoryCalendarItem;
import com.els.modules.calendar.service.PurchaseFactoryCalendarHeadService;
import com.els.modules.calendar.service.PurchaseFactoryCalendarItemService;
import com.els.modules.calendar.vo.PurchaseFactoryCalendarHeadVO;
import com.els.modules.calendar.vo.PurchaseFactoryCalendarVO;
import com.els.modules.eightReport.rpc.service.InvokeMainDataRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendar/purchaseFactoryCalendar"})
@Api(tags={"\u5de5\u5382\u65e5\u5386"})
public class PurchaseFactoryCalendarController
extends BaseController<PurchaseFactoryCalendarHead, PurchaseFactoryCalendarHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseFactoryCalendarController.class);
    @Autowired
    private PurchaseFactoryCalendarHeadService purchaseFactoryCalendarHeadService;
    @Autowired
    private PurchaseFactoryCalendarItemService purchaseFactoryCalendarItemService;
    @Autowired
    private InvokeMainDataRpcService invokeMainDataRpcService;

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u5206\u9875\u5217\u8868\u67e5\u8be2", logType=2)
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseFactoryCalendarHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseFactoryCalendarHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseFactoryCalendarHeadVO purchaseFactoryCalendarHeadPage) {
        PurchaseFactoryCalendarHead purchaseFactoryCalendarHead = new PurchaseFactoryCalendarHead();
        BeanUtils.copyProperties((Object)((Object)purchaseFactoryCalendarHeadPage), (Object)((Object)purchaseFactoryCalendarHead));
        this.purchaseFactoryCalendarHeadService.saveMain(purchaseFactoryCalendarHead, purchaseFactoryCalendarHeadPage.getPurchaseFactoryCalendarItemList());
        return Result.ok((Object)((Object)purchaseFactoryCalendarHead));
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u83b7\u53d6\u5de5\u5382\u65e5\u5386")
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5382\u65e5\u5386", notes="\u83b7\u53d6\u5de5\u5382\u65e5\u5386")
    @GetMapping(value={"/getCalendar"})
    public Result<?> getCalendar(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="factory", required=false) String factory) {
        List<PurchaseFactoryCalendarHeadVO> list = this.purchaseFactoryCalendarHeadService.getCalendar(elsAccount, factory);
        return Result.ok(list);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u6dfb\u52a0\u65e5\u5386")
    @ApiOperation(value="\u6dfb\u52a0\u65e5\u5386", notes="\u6dfb\u52a0\u65e5\u5386")
    @PostMapping(value={"/addCalendar"})
    public Result<?> addCalendar(@RequestBody PurchaseFactoryCalendarVO purchaseFactoryCalendarVO) {
        String elsAccount = TenantContext.getTenant();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<PurchaseFactoryCalendarHead> headList = purchaseFactoryCalendarVO.getPurchaseFactoryCalendarHeadList();
        for (PurchaseFactoryCalendarHead head : headList) {
            ArrayList<PurchaseFactoryCalendarItem> itemList = new ArrayList<PurchaseFactoryCalendarItem>();
            purchaseFactoryCalendarVO.getDayOffList().forEach(dayOff -> {
                PurchaseFactoryCalendarItem item = new PurchaseFactoryCalendarItem();
                try {
                    item.setElsAccount(elsAccount);
                    item.setDayOff(sdf.parse((String)dayOff));
                }
                catch (Exception e) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_calendarAdd", (String)("\u6dfb\u52a0\u65e5\u5386\u5931\u8d25\uff1a" + e.getMessage())));
                }
                itemList.add(item);
            });
            head.setElsAccount(elsAccount);
            if (StringUtils.isBlank((CharSequence)head.getId())) {
                this.purchaseFactoryCalendarHeadService.saveMain(head, itemList);
                continue;
            }
            this.purchaseFactoryCalendarHeadService.updateMain(head, itemList);
        }
        return Result.ok((Object)((Object)purchaseFactoryCalendarVO));
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u5de5\u5382", logType=2)
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u5de5\u5382", notes="\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u5de5\u5382")
    @GetMapping(value={"/getFactory"})
    public Result<?> getFactory(@RequestParam(name="elsAccount") String elsAccount) {
        List<PurchaseOrganizationInfoDTO> factoryList = this.invokeMainDataRpcService.getOrgByOrgCode(elsAccount, "factory");
        return Result.ok(factoryList);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseFactoryCalendarHeadVO purchaseFactoryCalendarHeadPage) {
        PurchaseFactoryCalendarHead purchaseFactoryCalendarHead = new PurchaseFactoryCalendarHead();
        BeanUtils.copyProperties((Object)((Object)purchaseFactoryCalendarHeadPage), (Object)((Object)purchaseFactoryCalendarHead));
        this.purchaseFactoryCalendarHeadService.updateMain(purchaseFactoryCalendarHead, purchaseFactoryCalendarHeadPage.getPurchaseFactoryCalendarItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseFactoryCalendarHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseFactoryCalendarHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseFactoryCalendarHead purchaseFactoryCalendarHead = (PurchaseFactoryCalendarHead)((Object)this.purchaseFactoryCalendarHeadService.getById((Serializable)((Object)id)));
        PurchaseFactoryCalendarHeadVO purchaseFactoryCalendarHeadVO = new PurchaseFactoryCalendarHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseFactoryCalendarHead), (Object)((Object)purchaseFactoryCalendarHeadVO));
        List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList = this.purchaseFactoryCalendarItemService.selectByMainId(id);
        purchaseFactoryCalendarHeadVO.setPurchaseFactoryCalendarItemList(purchaseFactoryCalendarItemList);
        return Result.ok((Object)((Object)purchaseFactoryCalendarHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5de5\u5382\u65e5\u5386\u5934\u8868id\u67e5\u8be2\u5de5\u5382\u65e5\u5386\u884c\u8868", notes="\u901a\u8fc7\u5de5\u5382\u65e5\u5386\u5934\u8868id\u67e5\u8be2\u5de5\u5382\u65e5\u5386\u884c\u8868")
    @GetMapping(value={"/queryPurchaseFactoryCalendarItemByMainId"})
    public Result<?> queryPurchaseFactoryCalendarItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList = this.purchaseFactoryCalendarItemService.selectByMainId(id);
        return Result.ok(purchaseFactoryCalendarItemList);
    }
}

