/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.eightReport.enumerate.EightReportStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.PurchaseInspectionItem;
import com.els.modules.siteInspection.entity.SaleInspectionHead;
import com.els.modules.siteInspection.entity.SaleInspectionItem;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemDetailMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardScoreGradeMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionItemMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionItemMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionPlanMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionScoreGroupMapper;
import com.els.modules.siteInspection.rpc.SiteInspectBaseRpcService;
import com.els.modules.siteInspection.service.SaleInspectionHeadService;
import com.els.modules.siteInspection.service.impl.ElsInspectionPlanHeadServiceImpl;
import com.els.modules.siteInspection.utils.BigDecimalUtil;
import com.els.modules.siteInspection.vo.EightReportVo;
import com.els.modules.siteInspection.vo.SaleInspectionHeadVO;
import com.els.modules.siteInspection.vo.SaleInspectionScoreReqVo;
import com.els.modules.siteInspection.vo.SaleRectificationVO;
import com.els.modules.siteInspection.vo.ScoreGroupVo;
import com.els.modules.siteInspection.vo.ScoreItemVo;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleInspectionHeadServiceImpl
extends BaseServiceImpl<SaleInspectionHeadMapper, SaleInspectionHead>
implements SaleInspectionHeadService {
    @Resource
    private SaleInspectionHeadMapper headMapper;
    @Resource
    private SaleInspectionItemMapper itemMapper;
    @Resource
    private SaleInspectionScoreGroupMapper scoreGroupMapper;
    @Resource
    private SaleInspectionPlanMapper planMapper;
    @Resource
    private PurchaseInspectionHeadMapper pHeadMapper;
    @Resource
    private PurchaseInspectionItemMapper pItemMapper;
    @Resource
    private ElsInspectionStandardItemDetailMapper itemDetailMapper;
    @Resource
    private ElsInspectionStandardScoreGradeMapper gradeMapper;
    @Autowired
    private SiteInspectBaseRpcService baseRpcService;

    private int getDecimalPlace(String fullMark) {
        return fullMark.contains(".") ? fullMark.split("\\.")[1].length() : 2;
    }

    private void saveScoreItem(SaleInspectionScoreReqVo reqVo) {
        this.itemMapper.getScoreItem(reqVo.getId()).forEach(itemVo -> {
            reqVo.getInspectionItemList().forEach(reqItem -> {
                if (!itemVo.getId().equals(reqItem.getId())) {
                    return;
                }
                itemVo.setSelfAssessmentScore(reqItem.getSelfAssessmentScore()).setSelfAssessmentResult(reqItem.getSelfAssessmentResult());
            });
            this.itemMapper.updateById(itemVo);
        });
    }

    private void submitScoreItem(SaleInspectionScoreReqVo reqVo) {
        this.itemMapper.getScoreItem(reqVo.getId()).forEach(itemVo -> {
            reqVo.getInspectionItemList().forEach(reqItem -> {
                if (!itemVo.getId().equals(reqItem.getId())) {
                    return;
                }
                AssertI18nUtil.isTrue((boolean)BigDecimalUtil.bigThan(reqItem.getSelfAssessmentScore(), itemVo.getFullMark()), (Enum)I18nSiteInspectEnum.SCORE_BIG_FULL_MARK);
                itemVo.setSelfAssessmentScore(reqItem.getSelfAssessmentScore()).setSelfAssessmentResult(reqItem.getSelfAssessmentResult());
            });
            this.itemMapper.updateById(itemVo);
            if (StringUtils.isBlank((CharSequence)itemVo.getSourceId())) {
                return;
            }
            PurchaseInspectionItem purInspectionItem = new PurchaseInspectionItem();
            purInspectionItem.setSelfAssessmentResult(itemVo.getSelfAssessmentResult()).setSelfAssessmentScore(itemVo.getSelfAssessmentScore()).setId(itemVo.getSourceId());
            this.pItemMapper.updateById((Object)purInspectionItem);
        });
    }

    private BigDecimal getSumScore(String headId, String standardFullMarks) {
        List<ScoreItemVo> scoreItemVos = this.itemMapper.getAllScoreItem(headId);
        int decimalPlace = this.getDecimalPlace(scoreItemVos.get(0).getFullMark());
        Map<String, BigDecimal> mapGroup = scoreItemVos.parallelStream().collect(Collectors.groupingBy(ScoreItemVo::getInspectionItemClassify, Collectors.collectingAndThen(Collectors.toList(), m -> {
            BigDecimal sumResult = m.parallelStream().map(i -> new BigDecimal(i.getFullMark())).reduce(BigDecimal.ZERO, BigDecimal::add);
            return m.parallelStream().map(i -> BigDecimalUtil.multiplyWeight(i.getScore(), i.getWeight())).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal(standardFullMarks)).divide(sumResult, decimalPlace, 4);
        })));
        BigDecimal sumSocre = BigDecimalUtil.getZero();
        for (Map.Entry<String, BigDecimal> entry : mapGroup.entrySet()) {
            sumSocre = sumSocre.add(entry.getValue());
        }
        return sumSocre;
    }

    private void updateScoreFinish(ScoreGroupVo scoreGroupVo, String headId, String relationId, String sumSocre) {
        String status = scoreGroupVo == null ? "2" : ("2".equals(scoreGroupVo.getInspectionConclusion()) ? "5" : "6");
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        saleInspectionHead.setSelfAssessmentScore(sumSocre).setDocumentsStatus(status).setScoreGrade(scoreGroupVo != null ? scoreGroupVo.getScoreGrade() : null).setInspectionConclusion(scoreGroupVo != null ? scoreGroupVo.getInspectionConclusion() : null).setId(headId);
        this.headMapper.updateById((Object)saleInspectionHead);
        PurchaseInspectionHead purchaseInspectionHead = new PurchaseInspectionHead();
        purchaseInspectionHead.setSelfAssessmentScore(sumSocre).setDocumentsStatus(status).setScoreGrade(saleInspectionHead.getScoreGrade()).setInspectionConclusion(saleInspectionHead.getInspectionConclusion()).setId(relationId);
        this.pHeadMapper.updateById((Object)purchaseInspectionHead);
        if ("6".equals(purchaseInspectionHead.getDocumentsStatus())) {
            ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
            planHeadService.caseClosedWriteBackPlanItem(purchaseInspectionHead);
        }
    }

    private void sendFile(String saleHeadId, String purchaseHeadId, String elsAccount, String toElsAccount) {
        AttachmentSendDTO attachmentSendVO = new AttachmentSendDTO();
        attachmentSendVO.setHeadId(saleHeadId);
        attachmentSendVO.setElsAccount(elsAccount);
        HashMap toSend = Maps.newHashMap();
        toSend.put(purchaseHeadId, toElsAccount);
        attachmentSendVO.setToSend((Map)toSend);
        this.baseRpcService.sendSaleFile(attachmentSendVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItemScore(SaleInspectionScoreReqVo reqVo) {
        SaleInspectionHead head = (SaleInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((!"1".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SALE_CAN_NOT_SCORE);
        this.saveScoreItem(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitItemScore(SaleInspectionScoreReqVo reqVo) {
        SaleInspectionHead head = (SaleInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((!"1".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SALE_CAN_NOT_SCORE);
        this.submitScoreItem(reqVo);
        if (this.itemMapper.countNoScoreItem(reqVo.getId()) > 0) {
            return;
        }
        BigDecimal sumScore = this.getSumScore(head.getId(), head.getStandardFullMarks());
        ScoreGroupVo scoreGroupVo = "1".equals(head.getInspectionStep()) ? this.gradeMapper.getScoreGroupByScore(head.getInspectionStandardName(), head.getInspectionStandardVersion(), sumScore, head.getBusAccount()) : null;
        this.updateScoreFinish(scoreGroupVo, head.getId(), head.getRelationId(), sumScore.toString());
        this.sendFile(head.getId(), head.getRelationId(), TenantContext.getTenant(), head.getBusAccount());
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public SaleInspectionHeadVO getById(String id) {
        SaleInspectionHeadVO resVo = new SaleInspectionHeadVO();
        SaleInspectionHead head = (SaleInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)resVo));
        List<SaleInspectionItem> itemList = this.itemMapper.selectByMainId(id);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectWithoutElsAccountByItemId(item.getInspectionStandardItemId())));
        }
        resVo.setInspectionItemList(itemList);
        resVo.setScoreGroupList(this.scoreGroupMapper.selectByMainId(id));
        resVo.setInspectionPlanList(this.planMapper.selectByMainId(id));
        resVo.setAttachmentList(this.baseRpcService.saleSelectByMainId(id));
        return resVo;
    }

    private void setEightReport(List<SaleInspectionHead> heads) {
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        List<String> ltNums = heads.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getEightReportNumber()) && !EightReportStatusEnum.D9.getValue().equals(head.getEightReportStatus())).map(SaleInspectionHead::getEightReportNumber).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ltNums)) {
            return;
        }
        List<EightReportVo> eightReportVos = this.headMapper.selectWithoutElsAccountEightReport(heads.get(0).getBusAccount(), ltNums);
        if (CollectionUtils.isEmpty(eightReportVos)) {
            heads.forEach(saleHead -> {
                if (StringUtils.isBlank((CharSequence)saleHead.getEightReportNumber())) {
                    return;
                }
                saleHead.setEightReportNumber(null).setEightReportStatus(null).setEightReportEvaluate(null);
                this.headMapper.clearEightReport(saleHead.getId());
            });
            return;
        }
        Map<String, EightReportVo> mapEightReportVos = eightReportVos.stream().collect(Collectors.toMap(EightReportVo::getEightDisciplinesNumber, reportVo -> reportVo));
        for (SaleInspectionHead head2 : heads) {
            if (StringUtils.isBlank((CharSequence)head2.getEightReportNumber()) || EightReportStatusEnum.D9.getValue().equals(head2.getEightReportStatus())) continue;
            EightReportVo reportVo2 = mapEightReportVos.get(head2.getEightReportNumber());
            if (reportVo2 == null || CommonConstant.DEL_FLAG_0.intValue() != reportVo2.getDeleted()) {
                head2.setEightReportNumber(null).setEightReportStatus(null).setEightReportEvaluate(null);
                this.headMapper.clearEightReport(head2.getId());
                continue;
            }
            head2.setEightReportStatus(reportVo2.getEightDisciplinesStatus()).setEightReportEvaluate(reportVo2.getClosedCondition());
            if (EightReportStatusEnum.D9.getValue().equals(reportVo2.getEightDisciplinesStatus())) {
                head2.setDocumentsStatus("6");
            }
            this.headMapper.updateEightReport(head2.getId(), head2.getEightReportStatus(), head2.getEightReportEvaluate(), head2.getDocumentsStatus());
        }
    }

    private void setSaleRectification(List<SaleInspectionHead> heads) {
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        List<String> ltNums = heads.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getReportCode()) && !SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(head.getRectificationStatus())).map(SaleInspectionHead::getReportCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ltNums)) {
            return;
        }
        List<SaleRectificationVO> reportVos = ((SaleInspectionHeadMapper)this.baseMapper).selectWithoutElsAccountSaleRectification(heads.get(0).getBusAccount(), ltNums);
        if (CollectionUtils.isEmpty(reportVos)) {
            heads.forEach(saleHead -> {
                if (StringUtils.isBlank((CharSequence)saleHead.getReportCode())) {
                    return;
                }
                saleHead.setReportCode(null).setRectificationStatus(null).setRectificationConclusion(null);
                ((SaleInspectionHeadMapper)this.baseMapper).clearSaleRectification(saleHead.getId());
            });
            return;
        }
        Map<String, SaleRectificationVO> mapSaleReportVos = reportVos.stream().collect(Collectors.toMap(SaleRectificationVO::getReportCode, reportVo -> reportVo));
        for (SaleInspectionHead head2 : heads) {
            if (StringUtils.isBlank((CharSequence)head2.getReportCode()) || SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(head2.getRectificationStatus())) continue;
            SaleRectificationVO reportVo2 = mapSaleReportVos.get(head2.getReportCode());
            if (reportVo2 == null || CommonConstant.DEL_FLAG_0.intValue() != reportVo2.getDeleted() || SupplierRectificationStatusEnum.RETURNED.getValue().equals(reportVo2.getRectificationStatus())) {
                head2.setReportCode(null).setRectificationStatus(null).setRectificationConclusion(null);
                this.headMapper.clearSaleRectification(head2.getId());
                continue;
            }
            head2.setRectificationStatus(reportVo2.getRectificationStatus()).setRectificationConclusion(reportVo2.getRectificationConclusion());
            if (SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(reportVo2.getRectificationStatus())) {
                head2.setDocumentsStatus("6");
            }
            this.headMapper.updateSaleRectification(head2.getId(), head2.getRectificationStatus(), head2.getRectificationConclusion(), head2.getDocumentsStatus());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void setRectification(List<SaleInspectionHead> heads) {
        this.setEightReport(heads);
        this.setSaleRectification(heads);
    }
}

