/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.massProduction.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.massProduction.entity.PurchaseMassProdHead;
import com.els.modules.massProduction.entity.PurchaseMassProdPpapItem;
import com.els.modules.massProduction.entity.PurchaseMassProdSampleItem;
import com.els.modules.massProduction.entity.SaleMassProdHead;
import com.els.modules.massProduction.enums.MassProdEnum;
import com.els.modules.massProduction.service.PurchaseMassProdHeadService;
import com.els.modules.massProduction.service.PurchaseMassProdPpapItemService;
import com.els.modules.massProduction.service.PurchaseMassProdSampleItemService;
import com.els.modules.massProduction.service.SaleMassProdHeadService;
import com.els.modules.massProduction.vo.PurchaseMassProdHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMassProdAdapter")
public class PurchaseMassProdAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseMassProdHeadService massProdHeadService;
    @Autowired
    private SaleMassProdHeadService saleMassProdHeadService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMassProdSampleItemService purchaseMassProdSampleItemService;
    @Autowired
    private PurchaseMassProdPpapItemService purchaseMassProdPpapItemService;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId, String bpmnType) {
        PurchaseMassProdHead purchaseMassProdHead = (PurchaseMassProdHead)((Object)this.massProdHeadService.getById((Serializable)((Object)businessId)));
        if (StrUtil.isNotEmpty((CharSequence)bpmnType)) {
            purchaseMassProdHead.setWorkFlowType(bpmnType);
        }
        purchaseMassProdHead.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            SaleMassProdHead saleMassProdHead;
            purchaseMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
            if (StringUtils.isNotBlank((CharSequence)purchaseMassProdHead.getRelationId()) && (saleMassProdHead = (SaleMassProdHead)((Object)this.saleMassProdHeadService.getById((Serializable)((Object)purchaseMassProdHead.getRelationId())))) != null) {
                saleMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
                this.saleMassProdHeadService.updateById((Object)saleMassProdHead);
            }
        }
        this.massProdHeadService.updateById((Object)purchaseMassProdHead);
    }

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId(), outputParamVO.getBpmnType());
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId(), null);
        String operType = AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) ? "auditPass" : "submitAudit";
        this.sendMsg(inputParamVO, outputParamVO, operType);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId(), null);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId(), null);
    }

    public JSONObject getDataById(String id) {
        PurchaseMassProdHead head = (PurchaseMassProdHead)((Object)this.massProdHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseMassProdHeadVO headVO = new PurchaseMassProdHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseMassProdPpapItem> purchaseMassProdPpapItemList = this.purchaseMassProdPpapItemService.selectByMainId(id);
            headVO.setMassProdPpapItemList(purchaseMassProdPpapItemList);
            List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList = this.purchaseMassProdSampleItemService.selectByMainId(id);
            headVO.setPurchaseMassProdSampleItemList(purchaseMassProdSampleItemList);
            Result result = Result.ok((Object)((Object)headVO));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"massProdHead", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"massProdHead", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseMassProdHead purchaseMassProdHead = (PurchaseMassProdHead)((Object)this.massProdHeadService.getById((Serializable)((Object)headId)));
        PurchaseMassProdHeadVO purchaseMassProdHeadVO = new PurchaseMassProdHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMassProdHead), (Object)((Object)purchaseMassProdHeadVO));
        List<PurchaseMassProdPpapItem> purchaseMassProdPpapItemList = this.purchaseMassProdPpapItemService.selectByMainId(headId);
        purchaseMassProdHeadVO.setMassProdPpapItemList(purchaseMassProdPpapItemList);
        List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList = this.purchaseMassProdSampleItemService.selectByMainId(headId);
        purchaseMassProdHeadVO.setPurchaseMassProdSampleItemList(purchaseMassProdSampleItemList);
        Result result = Result.ok((Object)((Object)purchaseMassProdHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

