/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.entity.SaleTrialProductionHead;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.service.PurchaseTrialProductionHeadService;
import com.els.modules.trial.service.SaleTrialProductionHeadService;
import com.els.modules.trial.vo.PurchaseTrialProductionHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PurchaseTrialProductionAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseTrialProductionHeadService purchaseTrialProductionHeadService;
    @Autowired
    private SaleTrialProductionHeadService saleTrialProductionHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseTrialProductionHeadVO purchaseTrialProductionHeadVO = (PurchaseTrialProductionHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseTrialProductionHeadVO.class));
        if ("1".equals(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getResultAudit())) {
            purchaseTrialProductionHeadVO.setResultAudit("1");
        }
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHeadVO), (Object)((Object)purchaseTrialProductionHead));
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseTrialProductionHead.setFlowId(outputParamVO.getProcessRootId());
        purchaseTrialProductionHead.setTrialResultNumber(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getTrialResultNumber());
        purchaseTrialProductionHead.setQualified(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getQualified());
        purchaseTrialProductionHead.setTrialResult(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getTrialResult());
        purchaseTrialProductionHead.setTrialResultDesc(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getTrialResultDesc());
        purchaseTrialProductionHead.setSampleQuantity(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getSampleQuantity());
        purchaseTrialProductionHead.setQualifiedQuantity(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getQualifiedQuantity());
        purchaseTrialProductionHead.setDefectiveQuantity(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getDefectiveQuantity());
        purchaseTrialProductionHead.setQualifiedRate(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getQualifiedRate());
        purchaseTrialProductionHead.setWorkFlowType(outputParamVO.getBpmnType());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        Date now = new Date();
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTrialProductionHead.setId(inputParamVO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(outputParamVO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseTrialProductionHead.setTrialEndDate(now);
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.FINAL.getValue());
        }
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            UpdateWrapper saleHeadQueryWrapper = new UpdateWrapper();
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialStatus, (Object)PurchaseTrialProductionHeadEnum.FINAL.getValue());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getSampleQuantity, (Object)purchaseTrialProductionHead.getSampleQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedQuantity, (Object)purchaseTrialProductionHead.getQualifiedQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getDefectiveQuantity, (Object)purchaseTrialProductionHead.getDefectiveQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedRate, (Object)purchaseTrialProductionHead.getQualifiedRate());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualified, (Object)purchaseTrialProductionHead.getQualified());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResult, (Object)purchaseTrialProductionHead.getTrialResult());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getResultAudit, (Object)purchaseTrialProductionHead.getResultAudit());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultDesc, (Object)purchaseTrialProductionHead.getTrialResultDesc());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultNumber, (Object)purchaseTrialProductionHead.getTrialResultNumber());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialEndDate, (Object)now);
            saleHeadQueryWrapper.lambda().eq(SaleTrialProductionHead::getRelationId, (Object)purchaseTrialProductionHead.getId());
            this.saleTrialProductionHeadService.update((Wrapper)saleHeadQueryWrapper);
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTrialProductionHead.setId(inputParamVO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseTrialProductionHeadVO purchaseTrialProductionHeadVO = (PurchaseTrialProductionHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseTrialProductionHeadVO.class));
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTrialProductionHead.setId(inputParamVO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseTrialProductionHead.setFlowId("");
        purchaseTrialProductionHead.setSampleQuantity(purchaseTrialProductionHeadVO.getSampleQuantity());
        purchaseTrialProductionHead.setQualifiedQuantity(purchaseTrialProductionHeadVO.getQualifiedQuantity());
        purchaseTrialProductionHead.setDefectiveQuantity(purchaseTrialProductionHeadVO.getDefectiveQuantity());
        purchaseTrialProductionHead.setQualifiedRate(purchaseTrialProductionHeadVO.getQualifiedRate());
        purchaseTrialProductionHead.setTrialResultNumber(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getTrialResultNumber());
        purchaseTrialProductionHead.setQualified(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getQualified());
        purchaseTrialProductionHead.setTrialResult(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getTrialResult());
        purchaseTrialProductionHead.setTrialResultDesc(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getTrialResultDesc());
        purchaseTrialProductionHead.setSampleQuantity(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getSampleQuantity());
        purchaseTrialProductionHead.setQualifiedQuantity(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getQualifiedQuantity());
        purchaseTrialProductionHead.setDefectiveQuantity(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getDefectiveQuantity());
        purchaseTrialProductionHead.setQualifiedRate(purchaseTrialProductionHeadVO.getPurchaseTrialProductionRecord().getQualifiedRate());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
    }

    public JSONObject getDataById(String id) {
        PurchaseTrialProductionHead head = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"trialProduction", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"trialProduction", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)purchaseTrialProductionHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

