/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleCheckItemService;
import com.els.modules.sample.vo.PurchaseQualityCheckInfoVO;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadRecordVO;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sample/purchaseSampleCheckHead"})
@Api(tags={"\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934"})
@BusinessModule(module="sampleCheck")
public class PurchaseSampleCheckHeadController
extends BaseController<PurchaseSampleCheckHead, PurchaseSampleCheckHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSampleCheckHeadController.class);
    @Autowired
    private PurchaseSampleCheckHeadService purchaseSampleCheckHeadService;
    @Autowired
    private PurchaseSampleCheckItemService purchaseSampleCheckItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:list"})
    @PermissionDataView(businessType="sampleCheck")
    public Result<?> queryPageList(PurchaseSampleCheckHead purchaseSampleCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8d22\u52a1\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c", notes="\u8d22\u52a1\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c")
    @GetMapping(value={"/financeQuerySampleCheck"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:list"})
    public Result<?> financeQuerySampleCheck(PurchaseQualityCheckInfoVO purchaseQualityCheckInfoVO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaseQualityCheckInfoVO> pageList = this.purchaseSampleCheckItemService.financeQuerySampleCheck((Page<PurchaseQualityCheckInfoVO>)page, purchaseQualityCheckInfoVO);
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:add"})
    @PermissionDataOpt(businessType="sampleCheck", beanClass=PurchaseSampleCheckHeadService.class)
    public Result<?> add(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        Assert.hasText((String)purchaseSampleCheckHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)purchaseSampleCheckHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        this.verifyCheckItem(purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList());
        this.purchaseSampleCheckHeadService.saveMain(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), purchaseSampleCheckHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseSampleCheckHead));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:edit"})
    @PermissionDataOpt(businessType="sampleCheck", beanClass=PurchaseSampleCheckHeadService.class)
    public Result<?> edit(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        this.verifyCheckItem(purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList());
        this.purchaseSampleCheckHeadService.updateMain(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), purchaseSampleCheckHeadPage.getPurchaseAttachmentList(), 1);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:submit"})
    @PermissionDataOpt(businessType="sampleCheck", beanClass=PurchaseSampleCheckHeadService.class)
    public Result<?> submit(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        purchaseSampleCheckHeadPage.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_ING.getValue());
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        this.purchaseSampleCheckHeadService.updateMain(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), purchaseSampleCheckHeadPage.getPurchaseAttachmentList(), 2);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u7ed3\u679c\u5f55\u5165")
    @ApiOperation(value="\u7ed3\u679c\u5f55\u5165", notes="\u7ed3\u679c\u5f55\u5165")
    @PostMapping(value={"/resultRecord"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:result"})
    public Result<?> resultRecord(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setSampleQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getSampleQuantity());
        purchaseSampleCheckHead.setQualifiedQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedQuantity());
        purchaseSampleCheckHead.setDefectiveQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getDefectiveQuantity());
        purchaseSampleCheckHead.setQualifiedRate(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedRate());
        purchaseSampleCheckHead.setQualified(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualified());
        purchaseSampleCheckHead.setCheckResult(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getCheckResult());
        this.verifyCheckItem(purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList());
        this.purchaseSampleCheckHeadService.resultRecord(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), purchaseSampleCheckHeadPage.getPurchaseAttachmentList(), 1);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u7ed3\u679c\u5f55\u5165\u63d0\u4ea4")
    @ApiOperation(value="\u7ed3\u679c\u5f55\u5165\u63d0\u4ea4", notes="\u7ed3\u679c\u5f55\u5165\u63d0\u4ea4")
    @PostMapping(value={"/resultRecordSubmit"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:resultRecordSubmit"})
    public Result<?> resultRecordSubmit(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        if ("0".equals(purchaseSampleCheckHeadPage.getResultAudit())) {
            purchaseSampleCheckHeadPage.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        }
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setSampleQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getSampleQuantity());
        purchaseSampleCheckHead.setQualifiedQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedQuantity());
        purchaseSampleCheckHead.setDefectiveQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getDefectiveQuantity());
        purchaseSampleCheckHead.setQualifiedRate(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedRate());
        purchaseSampleCheckHead.setQualified(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualified());
        purchaseSampleCheckHead.setCheckResult(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getCheckResult());
        this.verifyCheckItem(purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList());
        this.purchaseSampleCheckHeadService.resultRecord(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), purchaseSampleCheckHeadPage.getPurchaseAttachmentList(), 2);
        return this.commonSuccessResult(3);
    }

    private void verifyCheckItem(List<PurchaseSampleCheckItem> purchaseSampleCheckItemList) {
        purchaseSampleCheckItemList.forEach(item -> {
            Assert.notNull((Object)item.getCheckQuantity(), (String)I18nUtil.translate((String)"i18n_alert_IiWRxOLV_2e7ddf3a", (String)"\u68c0\u6d4b\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getCheckQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cIiWRlTfUW_2fa60cfd", (String)"\u884c\u68c0\u6d4b\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
        });
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSampleCheckHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseSampleCheckHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)id)));
        PurchaseSampleCheckHeadVO purchaseSampleCheckHeadVO = new PurchaseSampleCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHead), (Object)((Object)purchaseSampleCheckHeadVO));
        List<PurchaseSampleCheckItem> purchaseSampleCheckItemList = this.purchaseSampleCheckItemService.selectByMainId(id);
        purchaseSampleCheckHeadVO.setPurchaseSampleCheckItemList(purchaseSampleCheckItemList);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseSampleCheckHeadVO.setPurchaseAttachmentList(attachmentList);
        PurchaseSampleCheckHeadRecordVO recordVO = new PurchaseSampleCheckHeadRecordVO();
        recordVO.setSampleQuantity(purchaseSampleCheckHead.getSampleQuantity());
        recordVO.setQualifiedQuantity(purchaseSampleCheckHead.getQualifiedQuantity());
        recordVO.setDefectiveQuantity(purchaseSampleCheckHead.getDefectiveQuantity());
        recordVO.setQualifiedRate(purchaseSampleCheckHead.getQualifiedRate());
        recordVO.setQualified(purchaseSampleCheckHead.getQualified());
        recordVO.setCheckResult(purchaseSampleCheckHead.getCheckResult());
        recordVO.setResultAudit(purchaseSampleCheckHead.getResultAudit());
        purchaseSampleCheckHeadVO.setPurchaseSampleRecord(recordVO);
        return Result.ok((Object)((Object)purchaseSampleCheckHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u884c")
    @GetMapping(value={"/queryPurchaseSampleCheckItemByMainId"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:query"})
    public Result<?> queryPurchaseSampleCheckItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseSampleCheckItem> purchaseSampleCheckItemList = this.purchaseSampleCheckItemService.selectByMainId(id);
        return Result.ok(purchaseSampleCheckItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="sampleCheck")
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:list"})
    public Result<?> queryTabsCount(PurchaseSampleCheckHead purchaseSampleCheckHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"check_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"check_status");
        List list = ((PurchaseSampleCheckHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseSampleCheckHead::getCheckStatus, PurchaseSampleCheckHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("sampleCheckStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "2", "3"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "checkStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy/{id}"})
    @RequiresPermissions(value={"sampleCheck#purchaseSampleCheckHead:copy"})
    public Result<?> copy(@PathVariable String id) {
        this.purchaseSampleCheckHeadService.copy(id);
        return Result.ok();
    }
}

