/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.excel;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.DictRpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.siteInspection.entity.ElsInspectionPlanHead;
import com.els.modules.siteInspection.entity.ElsInspectionPlanItem;
import com.els.modules.siteInspection.entity.ElsInspectionStandardHead;
import com.els.modules.siteInspection.service.ElsInspectionPlanHeadService;
import com.els.modules.siteInspection.service.ElsInspectionPlanItemService;
import com.els.modules.siteInspection.service.ElsInspectionStandardHeadService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="inspectionPlanItemImportImpl")
public class InspectionPlanItemImportImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(InspectionPlanItemImportImpl.class);
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Resource
    private DictRpcService dictRpcService;
    @Resource
    private ElsInspectionStandardHeadService inspectionStandardHeadService;
    @Resource
    private ElsInspectionPlanHeadService inspectionPlanHeadService;
    @Resource
    private ElsInspectionPlanItemService inspectionPlanItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private String headId;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        HashSet<String> toElsAccountSet = new HashSet<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String toElsAccount = (String)data.get("toElsAccount");
            if (StringUtils.isBlank((CharSequence)toElsAccount)) {
                String msg = I18nUtil.translate((String)"", (String)"BOM\u8868\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            toElsAccountSet.add(toElsAccount);
        }
        HashMap<String, SupplierMasterDataDTO> supplierDataMap = new HashMap<String, SupplierMasterDataDTO>();
        for (String toElsAccount : toElsAccountSet) {
            SupplierMasterDataDTO supplierMasterDataDTO = this.supplierMasterDataRpcService.getToELsAccount(toElsAccount);
            supplierDataMap.put(toElsAccount, supplierMasterDataDTO);
        }
        for (Map data : dataList) {
            String inspectionStandardNumber;
            String planMonth;
            String toElsAccount = (String)data.get("toElsAccount");
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierDataMap.get(toElsAccount);
            if (Objects.isNull(supplierMasterDataDTO)) {
                String msg = I18nUtil.translate((String)"i18n_field_RdXeyxMK_f0d0267f", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            data.put("supplierCode", supplierMasterDataDTO.getSupplierCode());
            data.put("supplierName", supplierMasterDataDTO.getSupplierName());
            if (StringUtils.isNotBlank((CharSequence)supplierMasterDataDTO.getSupplierStatus())) {
                data.put("supplierStatus", supplierMasterDataDTO.getSupplierStatus());
                String supplierStatusDictText = this.dictRpcService.queryDictTextByKey("srmSupplierStatus", supplierMasterDataDTO.getSupplierStatus(), "100000");
                data.put("supplierStatus_dictText", supplierStatusDictText);
            }
            if (StringUtils.isNotBlank((CharSequence)supplierMasterDataDTO.getPerformanceLevel())) {
                data.put("performanceLevel", supplierMasterDataDTO.getPerformanceLevel());
                String performanceLevelDictText = this.dictRpcService.queryDictTextByKey("performance_level", supplierMasterDataDTO.getPerformanceLevel(), "100000");
                data.put("performanceLevel_dictText", performanceLevelDictText);
            }
            if (StringUtils.isNotBlank((CharSequence)supplierMasterDataDTO.getSupplierClassify())) {
                data.put("supplierClassify", supplierMasterDataDTO.getSupplierClassify());
                String supplierClassifyDictText = this.dictRpcService.queryDictTextByKey("Supplier_class2", supplierMasterDataDTO.getSupplierClassify(), "100000");
                data.put("supplierClassify_dictText", supplierClassifyDictText);
            }
            if (StringUtils.isNotBlank((CharSequence)(planMonth = (String)data.get("planMonth")))) {
                String monthListDictText = this.dictRpcService.queryDictTextByKey("monthList", planMonth, "100000");
                data.put("planMonth_dictText", monthListDictText);
            }
            if (StringUtils.isNotBlank((CharSequence)(inspectionStandardNumber = (String)data.get("inspectionStandardNumber")))) {
                QueryWrapper inspectionStandardHeadQueryWrapper = new QueryWrapper();
                inspectionStandardHeadQueryWrapper.eq((Object)"inspection_standard_number", (Object)inspectionStandardNumber);
                ElsInspectionStandardHead inspectionStandardHead = (ElsInspectionStandardHead)((Object)this.inspectionStandardHeadService.getOne((Wrapper)inspectionStandardHeadQueryWrapper));
                if (Objects.isNull((Object)inspectionStandardHead)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_BmBrAyxMK_27698761", (String)"\u8003\u5bdf\u6807\u51c6\u7f16\u53f7\u4e0d\u5b58\u5728");
                    this.errorAdd(excelImportDTO, msg, data);
                } else {
                    data.put("inspectionStandardName", inspectionStandardHead.getInspectionStandardName());
                    data.put("inspectionStandardId", inspectionStandardHead.getId());
                    data.put("inspectionStandardClassify", inspectionStandardHead.getClassify());
                }
            }
            returnList.add(data);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return returnList;
    }

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            ElsInspectionPlanHead dbHead = (ElsInspectionPlanHead)((Object)this.inspectionPlanHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<ElsInspectionPlanItem> itemList = this.inspectionPlanItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<ElsInspectionPlanItem>(itemList);
    }
}

