/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.advice.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.advice.entity.ComplaintAdviceHead;
import com.els.modules.advice.entity.ComplaintAdviceRecord;
import com.els.modules.advice.enumerate.AdviceStatusEnum;
import com.els.modules.advice.service.ComplaintAdviceHeadService;
import com.els.modules.advice.service.ComplaintAdviceRecordService;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.service.WorkOrderApiService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="optAdvice")
public class AdviceOptServiceImpl
implements WorkOrderApiService {
    @Autowired
    private ComplaintAdviceHeadService complaintAdviceHeadService;
    @Autowired
    private ComplaintAdviceRecordService complaintAdviceRecordService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public String invoke(JSONObject param) {
        String id = param.getString("id");
        String currentStatus = param.getString("currentStatus");
        ComplaintAdviceHead updateHead = new ComplaintAdviceHead();
        if (AdviceStatusEnum.CLOSE.getValue().equals(currentStatus)) {
            updateHead.setCompleteTime(new Date());
        }
        updateHead.setId(id);
        updateHead.setAdviceStatus(currentStatus);
        this.complaintAdviceHeadService.updateById((Object)updateHead);
        ComplaintAdviceRecord adviceRecord = (ComplaintAdviceRecord)((Object)JSON.parseObject((String)param.getJSONObject("record").toString(), ComplaintAdviceRecord.class));
        adviceRecord.setContentType(ContentTypeEnum.OTHER.getValue());
        adviceRecord.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.complaintAdviceRecordService.save((Object)adviceRecord);
        JSONObject msgBody = SysUtil.objectToJSON((Object)((Object)adviceRecord));
        msgBody.put("id", (Object)adviceRecord.getHeadId());
        msgBody.put("type", (Object)"message");
        this.redisUtil.publish("advice-record-srm-topic", (Object)msgBody.toJSONString());
        return "SUCCESS";
    }
}

