/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.eightReport.entity.PurchaseEightDisciplinesZero;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.service.PurchaseInspectionHeadService;
import com.els.modules.siteInspection.vo.GetItemsReqVo;
import com.els.modules.siteInspection.vo.InspectionPlanReqSaveVo;
import com.els.modules.siteInspection.vo.InspectionPlanReqSubmitVo;
import com.els.modules.siteInspection.vo.PurInspectionScoreReqVo;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSaveVO;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSubmitVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/other/purchaseInspectionHead"})
@Api(tags={"\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934"})
public class PurchaseInspectionHeadController
extends BaseController<PurchaseInspectionHead, PurchaseInspectionHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseInspectionHeadController.class);
    @Autowired
    private PurchaseInspectionHeadService headService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="siteInspection")
    public Result<?> queryPageList(PurchaseInspectionHead purchaseInspectionHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="myToDo", defaultValue="0") Boolean myToDo, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInspectionHead), (Map)req.getParameterMap());
        if (myToDo.booleanValue()) {
            LoginUser loginUser = SysUtil.getLoginUser();
            queryWrapper.exists("select 1 from purchase_inspection_score_group where purchase_inspection_score_group.head_id = purchase_inspection_head.id and els_account = '" + loginUser.getElsAccount() + "' and els_sub_account = '" + loginUser.getSubAccount() + "' and is_deleted = '0'");
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.headService.page((IPage)page, (Wrapper)queryWrapper);
        this.headService.setRectification(pageList.getRecords());
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/availableList"})
    public Result<?> availableList(PurchaseInspectionHead purchaseInspectionHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInspectionHead), (Map)req.getParameterMap());
        queryWrapper.lambda().in(PurchaseInspectionHead::getDocumentsStatus, new Object[]{"5", "6"});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.headService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u65b0\u589e")
    @ApiOperation(value="\u65b0\u589e-\u4fdd\u5b58", notes="\u65b0\u589e-\u4fdd\u5b58")
    @PostMapping(value={"/createNewRecord"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:add"})
    public Result<?> createNewRecord(@RequestBody PurchaseInspectionHeadSaveVO saveVO) {
        this.headService.createNewRecord(saveVO);
        return Result.ok((Object)((Object)saveVO));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91-\u4fdd\u5b58", notes="\u7f16\u8f91-\u4fdd\u5b58")
    @PostMapping(value={"/updateRecord"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:edit"})
    public Result<?> updateRecord(@RequestBody PurchaseInspectionHeadSaveVO saveVO) {
        this.headService.updateRecord(saveVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u6682\u5b58\u8bc4\u5206")
    @ApiOperation(value="\u8bc4\u5206-\u4fdd\u5b58", notes="\u8bc4\u5206-\u4fdd\u5b58")
    @PostMapping(value={"/saveItemScore"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:saveItemScore"})
    public Result<?> saveItemScore(@RequestBody @Validated PurchaseInspectionHeadSaveVO reqVo) {
        this.headService.saveItemScore(reqVo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u76f4\u63a5\u63d0\u4ea4")
    @ApiOperation(value="\u65b0\u589e-\u63d0\u4ea4", notes="\u65b0\u589e-\u63d0\u4ea4")
    @PostMapping(value={"/submitRecordNoId"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:submitRecordNoId"})
    public Result<?> submitRecordNoId(@RequestBody @Validated PurchaseInspectionHeadSubmitVO submitVO) {
        this.headService.submitRecordNoId(submitVO);
        return Result.ok((Object)((Object)submitVO));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u7f16\u8f91\u540e\u63d0\u4ea4")
    @ApiOperation(value="\u7f16\u8f91-\u63d0\u4ea4", notes="\u7f16\u8f91-\u63d0\u4ea4")
    @PostMapping(value={"/submitRecordWithId"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:submitRecordWithId"})
    public Result<?> submitRecordWithId(@RequestBody @Validated PurchaseInspectionHeadSubmitVO submitVO) {
        this.headService.submitRecordWithId(submitVO);
        return Result.ok((Object)((Object)submitVO));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u63d0\u4ea4\u8bc4\u5206")
    @ApiOperation(value="\u8bc4\u5206-\u63d0\u4ea4", notes="\u8bc4\u5206-\u63d0\u4ea4")
    @PostMapping(value={"/submitItemScore"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:submitItemScore"})
    public Result<?> submitItemScore(@RequestBody @Validated PurInspectionScoreReqVo reqVo) {
        return Result.ok((Object)((Object)this.headService.submitItemScore(reqVo)));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.headService.getById(id)));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.headService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u4f5c\u5e9f")
    @PostMapping(value={"/cancellation/{id}"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:cancel"})
    public Result<?> cancellation(@PathVariable String id) {
        this.headService.cancellation(id);
        return Result.ok();
    }

    @PostMapping(value={"/getItems"})
    public Result<?> getItems(@RequestBody GetItemsReqVo reqVo) {
        return Result.ok(this.headService.getItems(reqVo));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u4fdd\u5b58-\u8ba1\u5212\u8ddf\u8e2a")
    @PostMapping(value={"/savePlanTailAfter"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:savePlan"})
    public Result<?> savePlanTailAfter(@RequestBody @Validated InspectionPlanReqSaveVo reqVo) {
        this.headService.savePlanTailAfter(reqVo);
        return Result.ok();
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u63d0\u4ea4-\u8ba1\u5212\u8ddf\u8e2a")
    @PostMapping(value={"/submitPlanTailAfter"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:submitPlan"})
    public Result<?> submitPlanTailAfter(@RequestBody @Validated InspectionPlanReqSubmitVo reqVo) {
        this.headService.submitPlanTailAfter(reqVo);
        return Result.ok();
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u53d1\u8d778D\u6574\u6539")
    @PostMapping(value={"/rectification/{id}"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:rectification8D"})
    public Result<?> rectification(@PathVariable String id) {
        PurchaseEightDisciplinesZero purchaseEightDisciplinesZero = this.headService.eightReportRectification(id);
        if (purchaseEightDisciplinesZero != null) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hAirLRWirtyLWWWWWWW_190a697", (String)"\u53d1\u8d77\u6574\u6539\u6210\u529f,\u6574\u6539\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{purchaseEightDisciplinesZero.getEightDisciplinesNumber()}));
        }
        return Result.error((String)"\u751f\u6210\u7684\u6574\u6539\u5355\u53f7\u6709\u9519\u8bef");
    }

    @AutoLog(busModule="\u91c7\u8d2d\u65b9\u8003\u5bdf\u5355\u8868\u5934", value="\u53d1\u8d77\u4f9b\u5e94\u5546\u6574\u6539")
    @PostMapping(value={"/supplierRectification/{id}"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:rectification"})
    public Result<?> supplierRectification(@PathVariable String id) {
        PurchaseSupplierRectificationReportHead head = this.headService.supplierRectification(id);
        if (head != null) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hAirLRWirtyLWWWWWWW_190a697", (String)"\u53d1\u8d77\u6574\u6539\u6210\u529f,\u6574\u6539\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{head.getReportCode()}));
        }
        return Result.error((String)"\u751f\u6210\u7684\u6574\u6539\u5355\u53f7\u6709\u9519\u8bef");
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u8bc4\u5206-\u8be6\u60c5")
    @GetMapping(value={"/getSelfScoreItemDetail"})
    @RequiresPermissions(value={"siteInspection#purchaseInspectionHead:getSelfScoreItemDetail"})
    public Result<?> getSelfScoreItemDetail(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.headService.getSelfScoreItemDetail(id)));
    }

    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseInspectionHead purchaseInspectionHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInspectionHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"documents_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"documents_status");
        List list = ((PurchaseInspectionHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseInspectionHead::getDocumentsStatus, PurchaseInspectionHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "documentsStatus", null, all));
        List srmStatusDictList = this.invokeBaseRpcService.queryDictItemsByCode("site_inspection_status", TenantContext.getTenant());
        for (DictDTO status : srmStatusDictList) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "documentsStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy/{id}"})
    public Result<?> copy(@PathVariable String id) {
        this.headService.copy(id);
        return Result.ok();
    }
}

