/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.service.PurchaseQualityCheckHeadService;
import com.els.modules.quality.service.PurchaseQualityCheckItemService;
import com.els.modules.quality.vo.PurchaseQualityCheckHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quality/purchaseQualityCheckHead"})
@Api(tags={"\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355"})
public class PurchaseQualityCheckHeadController
extends BaseController<PurchaseQualityCheckHead, PurchaseQualityCheckHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseQualityCheckHeadController.class);
    @Autowired
    private PurchaseQualityCheckHeadService purchaseQualityCheckHeadService;
    @Autowired
    private PurchaseQualityCheckItemService purchaseQualityCheckItemService;
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="qualityCheck")
    public Result<?> queryPageList(PurchaseQualityCheckHead purchaseQualityCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseQualityCheckHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseQualityCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8d22\u52a1\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c", notes="\u8d22\u52a1\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c")
    @GetMapping(value={"/financeQueryQualityCheck"})
    public Result<?> financeQueryQualityCheck(PurchaseQualityCheckHead purchaseQualityCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseQualityCheckHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(PurchaseQualityCheckHead::getToElsAccount, (Object)purchaseQualityCheckHead.getToElsAccount());
        queryWrapper.lambda().eq(PurchaseQualityCheckHead::getCompany, (Object)purchaseQualityCheckHead.getCompany());
        queryWrapper.lambda().ne(PurchaseQualityCheckHead::getCheckStatus, (Object)"0");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseQualityCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355-\u6dfb\u52a0", logType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:add"})
    public Result<?> add(@RequestBody PurchaseQualityCheckHeadVO purchaseQualityCheckHeadPage) {
        PurchaseQualityCheckHead purchaseQualityCheckHead = new PurchaseQualityCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseQualityCheckHeadPage), (Object)((Object)purchaseQualityCheckHead));
        this.purchaseQualityCheckHeadService.saveMain(purchaseQualityCheckHead, purchaseQualityCheckHeadPage.getPurchaseQualityCheckItemList());
        return Result.ok((Object)((Object)purchaseQualityCheckHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:edit"})
    public Result<?> edit(@RequestBody PurchaseQualityCheckHeadVO purchaseQualityCheckHeadPage) {
        PurchaseQualityCheckHead purchaseQualityCheckHead = new PurchaseQualityCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseQualityCheckHeadPage), (Object)((Object)purchaseQualityCheckHead));
        this.purchaseQualityCheckHeadService.updateMain(purchaseQualityCheckHead, purchaseQualityCheckHeadPage.getPurchaseQualityCheckItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355-\u63d0\u4ea4", logType=2)
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:submit"})
    public Result<?> submit(@RequestBody PurchaseQualityCheckHeadVO purchaseQualityCheckHeadPage) {
        PurchaseQualityCheckHead purchaseQualityCheckHead = new PurchaseQualityCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseQualityCheckHeadPage), (Object)((Object)purchaseQualityCheckHead));
        this.purchaseQualityCheckHeadService.submit(purchaseQualityCheckHead, purchaseQualityCheckHeadPage.getPurchaseQualityCheckItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:publish"})
    public Result<?> publish(@RequestBody PurchaseQualityCheckHeadVO purchaseQualityCheckHeadPage) {
        PurchaseQualityCheckHead purchaseQualityCheckHead = new PurchaseQualityCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseQualityCheckHeadPage), (Object)((Object)purchaseQualityCheckHead));
        this.purchaseQualityCheckHeadService.publish(purchaseQualityCheckHead, purchaseQualityCheckHeadPage.getPurchaseQualityCheckItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseQualityCheckHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseQualityCheckHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:query"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseQualityCheckHead purchaseQualityCheckHead = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadService.getById((Serializable)((Object)id)));
        PurchaseQualityCheckHeadVO purchaseQualityCheckHeadVO = new PurchaseQualityCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseQualityCheckHead), (Object)((Object)purchaseQualityCheckHeadVO));
        List<PurchaseQualityCheckItem> purchaseQualityCheckItemList = this.purchaseQualityCheckItemService.selectByMainId(id);
        purchaseQualityCheckHeadVO.setPurchaseQualityCheckItemList(purchaseQualityCheckItemList);
        List purchaseQualityCheckAttachmentList = this.baseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseQualityCheckHeadVO.setPurchaseAttachmentList(purchaseQualityCheckAttachmentList);
        return Result.ok((Object)((Object)purchaseQualityCheckHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355id\u67e5\u8be2\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u5355id\u67e5\u8be2\u91c7\u8d2d\u6765\u6599\u68c0\u6d4b\u884c")
    @GetMapping(value={"/queryPurchaseQualityCheckItemByMainId"})
    public Result<?> queryPurchaseQualityCheckItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseQualityCheckItem> purchaseQualityCheckItemList = this.purchaseQualityCheckItemService.selectByMainId(id);
        return Result.ok(purchaseQualityCheckItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseQualityCheckHead purchaseQualityCheckHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseQualityCheckHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"check_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"check_status");
        List list = ((PurchaseQualityCheckHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseQualityCheckHead::getCheckStatus, PurchaseQualityCheckHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmCheckStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "checkStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseQualityCheckHeadService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseQualityCheckHeadService.pushDataToErp(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy/{id}"})
    @RequiresPermissions(value={"qualityCheck#purchaseQualityCheckHead:copy"})
    public Result<?> copy(@PathVariable String id) {
        this.purchaseQualityCheckHeadService.copy(id);
        return Result.ok();
    }
}

