/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.board.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.board.entity.PurchaseBoardSetHead;
import com.els.modules.board.entity.PurchaseBoardSetItem;
import com.els.modules.board.mapper.PurchaseBoardSetHeadMapper;
import com.els.modules.board.service.PurchaseBoardSetHeadService;
import com.els.modules.board.service.PurchaseBoardSetItemService;
import com.els.modules.board.vo.PurchaseBoardSetHeadVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseBoardSetHeadServiceImpl
extends BaseServiceImpl<PurchaseBoardSetHeadMapper, PurchaseBoardSetHead>
implements PurchaseBoardSetHeadService {
    @Resource
    private PurchaseBoardSetItemService purchaseBoardSetItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBoardSetHeadVO headVO) {
        headVO.setElsAccount(TenantContext.getTenant());
        headVO.setSubAccount(SysUtil.getCurrentBy());
        headVO.setEnable("1");
        ((PurchaseBoardSetHeadMapper)this.baseMapper).insert((Object)headVO);
        this.insertData(headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBoardSetHeadVO headVO) {
        int count = ((PurchaseBoardSetHeadMapper)this.baseMapper).updateById((Object)headVO);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseBoardSetItemService.deleteByMainId(headVO.getId());
        this.insertData(headVO);
    }

    private void insertData(PurchaseBoardSetHeadVO headVO) {
        List<PurchaseBoardSetItem> boardSetItemList = headVO.getLayouts();
        if (!CollectionUtils.isEmpty(boardSetItemList)) {
            for (PurchaseBoardSetItem entity : boardSetItemList) {
                entity.setElsAccount(headVO.getElsAccount());
                entity.setHeadId(headVO.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)headVO);
            }
            this.purchaseBoardSetItemService.saveBatch(boardSetItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseBoardSetItemService.deleteByMainId(id);
        ((PurchaseBoardSetHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBoardSetItemService.deleteByMainId(serializable.toString());
            ((PurchaseBoardSetHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateStatus(String id, boolean enableFlag) {
        if (enableFlag) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseBoardSetHead::getEnable, (Object)"1")).eq(BaseEntity::getId, (Object)id)).update();
        } else {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseBoardSetHead::getEnable, (Object)"0")).eq(BaseEntity::getId, (Object)id)).update();
        }
    }

    @Override
    public PurchaseBoardSetHeadVO queryDetailByCondition(PurchaseBoardSetHeadVO headVO) {
        List boardSetHeadList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseBoardSetHead::getBusinessType, (Object)headVO.getBusinessType())).eq(PurchaseBoardSetHead::getEnable, (Object)"1")).list();
        if (CollectionUtil.isEmpty((Collection)boardSetHeadList)) {
            boardSetHeadList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)SysUtil.getPurchaseAccount())).eq(PurchaseBoardSetHead::getBusinessType, (Object)headVO.getBusinessType())).eq(PurchaseBoardSetHead::getEnable, (Object)"1")).list();
        }
        if (CollectionUtil.isEmpty((Collection)boardSetHeadList)) {
            boardSetHeadList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)"100000")).eq(PurchaseBoardSetHead::getBusinessType, (Object)headVO.getBusinessType())).eq(PurchaseBoardSetHead::getEnable, (Object)"1")).list();
        }
        if (CollectionUtil.isNotEmpty((Collection)boardSetHeadList)) {
            PurchaseBoardSetHead boardSetHead = (PurchaseBoardSetHead)((Object)boardSetHeadList.get(0));
            List<PurchaseBoardSetItem> boardSetItemList = this.purchaseBoardSetItemService.selectByMainId(boardSetHead.getId());
            PurchaseBoardSetHeadVO boardSetHeadVO = (PurchaseBoardSetHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)boardSetHead), PurchaseBoardSetHeadVO.class, (String[])new String[0]));
            boardSetHeadVO.setLayouts(boardSetItemList);
            return boardSetHeadVO;
        }
        this.log.error(I18nUtil.translate((String)"", (String)"\u6839\u636e\u4e1a\u52a1\u7c7b\u578b[${0}]\uff0c\u672a\u67e5\u8be2\u5230\u542f\u7528\u4e2d\u7684\u770b\u677f\u914d\u7f6e", (String[])new String[]{headVO.getBusinessType()}));
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6839\u636e\u4e1a\u52a1\u7c7b\u578b[${0}]\uff0c\u672a\u67e5\u8be2\u5230\u542f\u7528\u4e2d\u7684\u770b\u677f\u914d\u7f6e", (String[])new String[]{headVO.getBusinessType()}));
    }
}

