/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.ipaas.entity.PayEnum;
import com.els.modules.ipaas.entity.PaymentCallBackEntity;
import com.els.modules.member.entity.MemberOrder;
import com.els.modules.member.enumerate.OrderStatusEnum;
import com.els.modules.member.service.MemberOrderService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcnIPaaSCallbackServiceImpl")
public class McnIPaaSCallbackServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(McnIPaaSCallbackServiceImpl.class);
    @Autowired
    private MemberOrderService memberOrderService;

    private boolean checkOrderSuccess(PaymentCallBackEntity callBackEntity) {
        PayEnum payEnum = Arrays.stream(PayEnum.values()).filter(x -> x.getValue().equals(callBackEntity.getPayType())).findFirst().get();
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)payEnum), (String)I18nUtil.translate((String)"i18n_alert_WWWRBMTKmWSMxuRBAc_d975e0b7", (String)"SRM\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u652f\u4ed8\u7c7b\u578b"), (Object[])new Object[0]);
        boolean flag = false;
        switch (payEnum) {
            case ALIPAY: {
                if (!callBackEntity.isSignVerify() || !"TRADE_SUCCESS".equals(callBackEntity.getRespCode())) break;
                flag = true;
                break;
            }
            case WXPAY: {
                if (!callBackEntity.isSignVerify() || !"SUCCESS".equals(callBackEntity.getRespCode())) break;
                flag = true;
                break;
            }
            case FUIOUPAY: {
                if (!callBackEntity.isSignVerify() || !"0000".equals(callBackEntity.getRespCode()) || !"11".equals(callBackEntity.getOrderSt())) break;
                flag = true;
            }
        }
        Assert.isTrue((boolean)flag, (String)(I18nUtil.translate((String)"i18n_alert_WWWRBMTWBjRBddLKmWItWW_acb12ab", (String)"SRM\u652f\u4ed8\u56de\u8c03\uff0c\u5bcc\u53cb\u652f\u4ed8\u54cd\u5e94\u4e3a\u5931\u8d25,\u8ba2\u5355ID\u3010") + callBackEntity.getOrderId() + "\u3011"), (Object[])new Object[0]);
        return flag;
    }

    public JSONObject invoke(JSONObject param) {
        log.info("\u63a5\u6536\u5230ipass\u652f\u4ed8\u56de\u8c03:{}", (Object)param.toJSONString());
        PaymentCallBackEntity callBackEntity = (PaymentCallBackEntity)JSONObject.toJavaObject((JSON)param, PaymentCallBackEntity.class);
        if (this.checkOrderSuccess(callBackEntity)) {
            MemberOrder memberOrder = (MemberOrder)((Object)this.memberOrderService.getById((Serializable)((Object)callBackEntity.getOrderId())));
            memberOrder.setOrderStatus(OrderStatusEnum.COMPLETED.getCode());
            memberOrder.setPayTime(new Date());
            this.memberOrderService.updateById((Object)memberOrder);
        }
        return null;
    }
}

