/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.util.RedisUtil;
import com.els.modules.common.spider.spiderApi.HttpClientResult;
import com.els.modules.common.spider.spiderApi.HttpClientUtils;
import com.els.modules.common.spider.spiderApi.JsonUtils;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.goods.entity.GoodsDetail;
import com.els.modules.goods.entity.GoodsOverview;
import com.els.modules.goods.entity.GoodsOverviewTrend;
import com.els.modules.goods.service.GoodsService;
import com.els.modules.goods.vo.GoodsItems;
import com.els.modules.goods.vo.GoodsResultVO;
import com.els.modules.topman.utils.spider.entity.GoodsListPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GoodsServiceImpl
implements GoodsService {
    @Value(value="${spider-api.topManUrl}")
    private String url;
    @Value(value="${spider-api.method.dou-yin.getGoodsList}")
    private String PromotionMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsItems}")
    private String itemdsMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsDetails}")
    private String detailMethod;
    @Value(value="${spider-api.method.dou-yin.getGoodsOverviewTrend}")
    private String goodsOverviewTrendMethod;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public GoodsResultVO searchItems() throws Exception {
        String method = this.url + this.itemdsMethod;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        HashMap resutlMap = new HashMap();
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doGet(method, headers, new HashMap<String, String>());
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
        }
        if (jsonResult == null || "".equals(jsonResult)) {
            return null;
        }
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        GoodsResultVO vo = this.json2GoodsResultVO((JsonObject)jsonObject.get("data"));
        return vo;
    }

    private List<GoodsItems> json2goodsItem(JsonArray jsonArray) {
        ArrayList<GoodsItems> goodsItems = new ArrayList<GoodsItems>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject json = (JsonObject)jsonArray.get(i);
            GoodsItems item = new GoodsItems();
            HashMap map = new HashMap();
            Set entrySet = json.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String text = "";
                if (!(value instanceof JsonArray)) {
                    text = (value + "").replace("\"", "");
                }
                switch (key) {
                    case "KeyInt": {
                        item.setKeyInt(text);
                        break;
                    }
                    case "Number": {
                        item.setNumber(text);
                        break;
                    }
                    case "Text": {
                        item.setText(text);
                        break;
                    }
                    case "Value": {
                        item.setValue(text);
                        break;
                    }
                    case "Value2": {
                        item.setValue2(text);
                        break;
                    }
                    case "SearchTwoLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "SearchThreeLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "SearchFourLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                }
            }
            goodsItems.add(item);
        }
        return goodsItems;
    }

    private GoodsResultVO json2GoodsResultVO(JsonObject jsonObject) {
        GoodsResultVO result = new GoodsResultVO();
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            JsonArray ja = new JsonArray();
            if (!(value instanceof JsonArray)) break;
            ja = (JsonArray)value;
            switch (key) {
                case "Ages": {
                    result.setAges(this.json2goodsItem(ja));
                    break;
                }
                case "Categorys": {
                    result.setCategorys(this.json2goodsItem(ja));
                    break;
                }
                case "Commissions": {
                    result.setCommissions(this.json2goodsItem(ja));
                    break;
                }
                case "Coupons": {
                    result.setCoupons(this.json2goodsItem(ja));
                    break;
                }
                case "FirstTimes": {
                    result.setFirstTimes(this.json2goodsItem(ja));
                    break;
                }
                case "Genders": {
                    result.setGenders(this.json2goodsItem(ja));
                    break;
                }
                case "MainSalesModel": {
                    result.setMainSalesModel(this.json2goodsItem(ja));
                    break;
                }
                case "PraiseRates": {
                    result.setPraiseRates(this.json2goodsItem(ja));
                    break;
                }
                case "ProportionGoods": {
                    result.setProportionGoods(this.json2goodsItem(ja));
                    break;
                }
                case "RecommendTags": {
                    result.setRecommendTags(this.json2goodsItem(ja));
                    break;
                }
                case "SendFroms": {
                    result.setSendFroms(this.json2goodsItem(ja));
                    break;
                }
                case "ServiceTypes": {
                    result.setServiceTypes(this.json2goodsItem(ja));
                    break;
                }
                case "ShopScores": {
                    result.setShopScores(this.json2goodsItem(ja));
                    break;
                }
                case "Sorts": {
                    result.setSorts(this.json2goodsItem(ja));
                    break;
                }
                case "SourceList": {
                    result.setSourceList(this.json2goodsItem(ja));
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public IPage<com.els.modules.goods.entity.GoodsItems> searchPromotion(Map query) throws Exception {
        Page page = new Page(Long.parseLong(query.get("pageIndex") + ""), Long.parseLong(query.get("pageSize") + ""));
        String method = this.url + this.PromotionMethod;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doPost(method, headers, query, true);
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
        }
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList goodsList = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonResult);
        GoodsListPage goods = (GoodsListPage)((Object)mapper.convertValue((Object)jsonNode.get("data"), GoodsListPage.class));
        page.setTotal(goods.getTotal().longValue());
        page.setRecords(goods.getItems());
        return page;
    }

    @Override
    public Map<String, Object> searchGoodsInfo(Map goods) {
        return null;
    }

    @Override
    public GoodsDetail searchGoodsDetails(Map goods) throws Exception {
        GoodsDetail detail = new GoodsDetail();
        String method = this.url + this.detailMethod;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doPost(method, headers, goods, true);
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
        }
        if (jsonResult == null || "".equals(jsonResult)) {
            return detail;
        }
        detail = this.buildDetail(jsonResult);
        return detail;
    }

    private GoodsDetail buildDetail(String jsonResult) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        GoodsDetail result = new GoodsDetail();
        result.setGid(data.get("Gid") + "");
        result.setTitle(data.get("Title") + "");
        result.setCateStr(data.get("CateStr") + "");
        result.setCosRatio(data.get("CosRatio") + "");
        result.setShopName(data.get("ShopName") + "");
        result.setShopId(data.get("ShopId") + "");
        result.setPrice(data.get("PriceRange") + "");
        result.setLiveCountDay(data.get("LiveCount_30Day") + "");
        result.setImageUrl(data.get("ImageUrl") + "");
        result.setVisitorCount(data.get("VisitorCount") + "");
        result.setTotalPV(data.get("TotalPV_30Day") + "");
        return result;
    }

    @Override
    public Map<String, Object> loadAwemeAnalysisChartData(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> loadLiveAnalysisChartData(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> goodDataOverviewTrendDayTop(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> bloggerAnalysisSearchItemV2(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> loadBloggerAnalysis(Map blog) {
        return null;
    }

    @Override
    public Map<String, Object> loadAwemeAnalysis(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> loadLiveAnalysisData(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> loadBloggerAnalysisTypes(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> getSegmentsDataV2(Map goods) {
        return null;
    }

    @Override
    public Map<String, Object> getPortrayalDataV2(Map goods) {
        return null;
    }

    @Override
    public GoodsOverview getGoodsOverviewTrend(Map goods) throws Exception {
        GoodsOverview overiew = new GoodsOverview();
        String method = this.url + this.goodsOverviewTrendMethod;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doPost(method, headers, goods, true);
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
        }
        if (jsonResult == null || "".equals(jsonResult)) {
            return overiew;
        }
        overiew = this.buildTrend(jsonResult);
        return overiew;
    }

    private GoodsOverview buildTrend(String jsonResult) {
        GoodsOverview overiew = new GoodsOverview();
        ArrayList<GoodsOverviewTrend> trends = new ArrayList<GoodsOverviewTrend>();
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        List list = (List)data.get("List");
        for (Map obj : list) {
            GoodsOverviewTrend trend = new GoodsOverviewTrend();
            trend.setDateyyyyMMdd(obj.get("DateyyyyMMdd") + "");
            trend.setPvStr(obj.get("PvStr") + "");
            trend.setAwemeCount(obj.get("AwemeCount") + "");
            trend.setBloggerCount(obj.get("BloggerCount") + "");
            trend.setLiveCount(obj.get("LiveCount") + "");
            trend.setTotalSaleCountStr(obj.get("TotalSaleCountStr") + "");
            trend.setTotalSalesStr(obj.get("TotalSalesStr") + "");
            trends.add(trend);
        }
        overiew.setTrends(trends);
        Map totalData = (Map)data.get("TotalData");
        overiew.setBloggerCount(totalData.get("BloggerCountStr") + "");
        overiew.setPvStr(totalData.get("PvStr") + "");
        overiew.setSalesCountStr(totalData.get("SalesCountStr") + "");
        overiew.setTotalSalesStr(totalData.get("TotalSalesStr") + "");
        return overiew;
    }
}

