/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.modules.goods.dto.GoodsTopmanHandleDTO;
import com.els.modules.goods.service.GoodsTopmanHandleService;
import com.els.modules.goods.vo.TopmanItemVO;
import com.els.modules.industryInfo.api.optiondic.DouYinTopManOptionSource;
import com.els.modules.topman.dto.DouYinTopManCollectDTO;
import com.els.modules.topman.entity.TopManMsgRecord;
import com.els.modules.topman.service.DouYinTopManService;
import com.els.modules.topman.service.TopManMsgRecordService;
import com.els.modules.topman.vo.DouYinTopManVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsTopmanHandleServiceImpl
implements GoodsTopmanHandleService {
    @Autowired
    private DouYinTopManService topManInformationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;

    @Override
    public void favorite(GoodsTopmanHandleDTO dto) {
        DouYinTopManCollectDTO collectDTO = this.douYinTopManCollectConverter(dto);
        this.topManInformationService.collectNew(collectDTO);
    }

    @Override
    public String addData(GoodsTopmanHandleDTO dto) {
        DouYinTopManCollectDTO collectDTO = this.douYinTopManCollectConverter(dto);
        return this.topManInformationService.addToMySqlNew(collectDTO);
    }

    @Override
    public void autoMsg(GoodsTopmanHandleDTO dto) {
        TopManMsgRecord topManMsgRecord = this.topManMsgRecordConverter(dto);
        this.topManMsgRecordService.add(topManMsgRecord);
    }

    private TopManMsgRecord topManMsgRecordConverter(GoodsTopmanHandleDTO dto) {
        TopmanItemVO itemVO = dto.getEntity();
        if (itemVO == null) {
            throw new ELSBootException("\u53c2\u6570\u9519\u8bef");
        }
        TopManMsgRecord record = new TopManMsgRecord();
        record.setPlatform("1");
        record.setTopmanId(itemVO.getTiktokNo());
        record.setTopmanName(itemVO.getName());
        record.setTopmanLevelId(itemVO.getTopmanLevel());
        record.setTopmanLevel((String)DouYinTopManOptionSource.level.get(Integer.valueOf(itemVO.getTopmanLevel())));
        record.setAvatar(itemVO.getAvatar());
        record.setTopmanGenderId(itemVO.getTopmanSex());
        record.setFansNum(itemVO.getFansNum().toPlainString());
        record.setTopmanRegion(itemVO.getRegion());
        return record;
    }

    private DouYinTopManCollectDTO douYinTopManCollectConverter(GoodsTopmanHandleDTO dto) {
        TopmanItemVO itemVO = dto.getEntity();
        if (itemVO == null) {
            throw new ELSBootException("\u53c2\u6570\u9519\u8bef");
        }
        DouYinTopManCollectDTO collectDTO = new DouYinTopManCollectDTO();
        collectDTO.setPlatform(dto.getPlatform());
        collectDTO.setTaskType(dto.getTaskType());
        collectDTO.setCollect(dto.getCollect());
        DouYinTopManVO topManVO = new DouYinTopManVO();
        topManVO.setPlatform("1");
        if (StringUtils.isNotBlank((CharSequence)itemVO.getTiktokNo())) {
            topManVO.setTopManId(itemVO.getTiktokNo());
            collectDTO.setTiktokNo(itemVO.getTiktokNo());
        }
        topManVO.setAvatar(itemVO.getAvatar());
        topManVO.setTopmanName(itemVO.getName());
        topManVO.setTopmanGenderId(itemVO.getTopmanSex());
        topManVO.setTopmanRegion(itemVO.getRegion());
        topManVO.setTopmanLevelId(itemVO.getTopmanLevel());
        topManVO.setFansNum(itemVO.getFansNum());
        topManVO.setContentType(itemVO.getContentType());
        topManVO.setCategory(itemVO.getGoodsCategory());
        collectDTO.setEntity(topManVO);
        return collectDTO;
    }
}

