/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.store.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.func.VoidFunc1;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.common.spider.dto.ShopApiDTO;
import com.els.modules.common.spider.dto.ShopGoodsApiDTO;
import com.els.modules.common.spider.dto.ShopTopManApiDTO;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.spider.vo.ShopApiPage;
import com.els.modules.common.spider.vo.ShopApiVO;
import com.els.modules.common.spider.vo.ShopDetailVO;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.store.dto.ShopCollectDTO;
import com.els.modules.store.dto.ShopDTO;
import com.els.modules.store.dto.ShopDetailDTO;
import com.els.modules.store.entity.Shop;
import com.els.modules.store.entity.ShopCollect;
import com.els.modules.store.enumerate.ShopOptionsType;
import com.els.modules.store.enumerate.ShopOptionsTypeGroup;
import com.els.modules.store.mapper.ShopMapper;
import com.els.modules.store.service.ShopCollectService;
import com.els.modules.store.service.ShopService;
import com.els.modules.store.vo.ShopVO;
import com.els.modules.topman.entity.RedBookTopManEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopServiceImpl
extends BaseServiceImpl<ShopMapper, Shop>
implements ShopService {
    @Autowired
    private ShopCollectService shopCollectService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<ShopOptionsTypeGroup, ShopOptionsType> init = OptionFactory.init(ShopOptionsTypeGroup.class, ShopOptionsType.class);
        init.setCollection("tb_shop_category");
        switch (type) {
            case "all": {
                init.when(ShopOptionsType.category, (doc, param) -> this.optionsConverter(doc));
                init.when(ShopOptionsType.filter, (doc, param) -> this.optionsConverter(doc));
                break;
            }
            case "collect": {
                init.when(ShopOptionsType.category, (doc, param) -> this.optionsConverter(doc));
                init.when(ShopOptionsType.filter, (doc, param) -> this.optionsConverter(doc));
                break;
            }
            default: {
                throw new ELSBootException("\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b");
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> optionsConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getChildren((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getChildren(Document document) {
        List children = document.getList((Object)"children", Map.class);
        ArrayList<Object> tagCopyList = new ArrayList<Object>(children.size());
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children1)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList(children1.size());
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    @Override
    public IPage<ShopVO> queryPageList(SimplePostRequestParam<ShopDTO> param) {
        IPage<ShopVO> page = new IPage<ShopVO>((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        ShopDTO dto = (ShopDTO)param.getFilterInfo();
        String taskType = dto.getTaskType();
        if (ShopOptionsTypeGroup.all.getName().equals(taskType)) {
            Map<?, ?> map = this.handleBody(param);
            SpiderMethodType methodType = SpiderMethodType.SHOPS_LIST;
            ShopApiPage data = this.spiderApiUtil.postForEntity(methodType, map, ShopApiPage.class);
            page.setTotal((long)data.getTotal().intValue());
            page.setRecords(this.handleResult(data, dto.getPlatform()));
        } else {
            QueryWrapper<Shop> queryWrapper = this.getQueryWrapper(param);
            page = ((ShopMapper)this.baseMapper).queryPageList(page, queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private Map<?, ?> handleBody(SimplePostRequestParam<ShopDTO> param) {
        ShopDTO.ScreenItem screenItem;
        ShopApiDTO spiderApiDTO = new ShopApiDTO(param);
        String keyWord = param.getKeyWord();
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            spiderApiDTO.setKeyword(keyWord);
        }
        if ((screenItem = ((ShopDTO)param.getFilterInfo()).getScreenItem()) != null) {
            List<ShopDTO.ScreenItemField> category = screenItem.getCategory();
            if (CollectionUtil.isNotEmpty(category)) {
                ShopDTO.ScreenItemField screenItemField = category.get(0);
                spiderApiDTO.setCate0(screenItemField.getStarTagId());
                Object value = screenItemField.getValue();
                if (value != null) {
                    String string = JSON.toJSONString((Object)screenItemField.getValue());
                    List maps = JSON.parseArray((String)string, Map.class);
                    spiderApiDTO.setCate1((String)((Map)maps.get(0)).get("value"));
                }
            }
            List<ShopDTO.ScreenItemField> filter = screenItem.getFilter();
            this.initScreenItemField(filter, spiderApiDTO);
        }
        String json = JSON.toJSONString((Object)spiderApiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private void initScreenItemField(List<ShopDTO.ScreenItemField> screenItemFields, ShopApiDTO spiderApiDTO) {
        if (CollectionUtil.isEmpty(screenItemFields)) {
            return;
        }
        block20: for (ShopDTO.ScreenItemField screenItemField : screenItemFields) {
            String value = (String)screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u5546\u5bb6\u4f53\u9a8c\u5206": {
                    spiderApiDTO.setShopScore(value);
                    continue block20;
                }
                case "\u5546\u54c1\u603b\u6570": {
                    spiderApiDTO.setPromotionRange(value);
                    continue block20;
                }
                case "\u5173\u8054\u89c6\u9891\u6570": {
                    spiderApiDTO.setAwemeRange(value);
                    continue block20;
                }
                case "\u5173\u8054\u76f4\u64ad\u6570": {
                    spiderApiDTO.setLiveRange(value);
                    continue block20;
                }
                case "\u9500\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setSaleCount_yday_gt), (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setSaleCount_yday_lt));
                    continue block20;
                }
                case "\u9500\u552e\u989d": {
                    this.handleMinMax(value, (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setSales_yday_gt), (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setSales_yday_lt));
                    continue block20;
                }
                case "\u6709\u76f4\u64ad\u5e26\u8d27": {
                    spiderApiDTO.setMainSalesModel(2);
                    spiderApiDTO.setMainSalesRatio(0.5);
                    continue block20;
                }
                case "\u6709\u89c6\u9891\u5e26\u8d27": {
                    spiderApiDTO.setMainSalesModel(1);
                    spiderApiDTO.setMainSalesRatio(0.5);
                    continue block20;
                }
            }
            throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b");
        }
    }

    private void handleMinMax(String value, VoidFunc1<Integer> minField, VoidFunc1<Integer> maxField) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)Integer.valueOf(split[0]));
                }
                if ((max = split[1]) != null && !"".equals(max)) {
                    maxField.call((Object)Integer.valueOf(split[1]));
                }
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)Integer.valueOf(split[0]));
                    break;
                }
                minField.call((Object)Integer.valueOf(split[0]));
                break;
            }
            default: {
                throw new ELSBootException("\u6570\u636e\u914d\u7f6e\u6709\u8bef");
            }
        }
    }

    private List<ShopVO> handleResult(ShopApiPage data, Integer platform) {
        List<ShopApiVO> shopDatas = data.getShopDatas();
        if (CollectionUtil.isEmpty(shopDatas)) {
            return new ArrayList<ShopVO>(0);
        }
        List<String> shopIds = shopDatas.stream().map(ShopApiVO::getShopId).distinct().collect(Collectors.toList());
        List<ShopVO> collects = ((ShopMapper)this.baseMapper).checkCollect(shopIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap(collects.size());
        if (CollectionUtil.isNotEmpty(collects)) {
            map = collects.stream().collect(Collectors.toMap(ShopVO::getShopId, h -> h, (k1, k2) -> k1));
        }
        ArrayList<ShopVO> list = new ArrayList<ShopVO>(shopDatas.size());
        for (ShopApiVO vo : shopDatas) {
            ShopVO shop = new ShopVO();
            BeanUtils.copyProperties((Object)vo, (Object)shop);
            shop.setPlatform(1);
            shop.setSalesNum(vo.getTotalOrderAccount30Day());
            shop.setSalesAmount(vo.getTotalPrices30Day());
            shop.setGoodsNum(vo.getProductCount());
            shop.setVideosNum(vo.getAwemes30Day());
            shop.setLivesNum(vo.getLives30Day());
            List<String> cateNames = vo.getCateNames();
            shop.setShopCategory(CollectionUtil.isNotEmpty(cateNames) ? StringUtils.join(cateNames, (String)",") : "");
            shop.setIsCollection(map.get(vo.getShopId()) != null ? ((ShopVO)map.get(vo.getShopId())).getIsCollection() : 0);
            list.add(shop);
        }
        return list;
    }

    private QueryWrapper<Shop> getQueryWrapper(SimplePostRequestParam<ShopDTO> param) {
        String[] columns;
        String column;
        String keyWord;
        List<ShopDTO.ScreenItemField> filters;
        ShopDTO dto = (ShopDTO)param.getFilterInfo();
        ShopDTO.ScreenItem screenItem = dto.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        List<ShopDTO.ScreenItemField> categorys = screenItem.getCategory();
        if (CollectionUtil.isNotEmpty(categorys)) {
            String value = (String)categorys.get(0).getValue();
            this.handlelikeString(value, (QueryWrapper<Shop>)query, Shop::getShopCategory);
        }
        if (CollectionUtil.isNotEmpty(filters = screenItem.getFilter())) {
            block18: for (ShopDTO.ScreenItemField screenItemField : filters) {
                String value = (String)screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u5546\u54c1\u603b\u6570": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getGoodsNum);
                        continue block18;
                    }
                    case "\u5173\u8054\u89c6\u9891\u6570": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getVideosNum);
                        continue block18;
                    }
                    case "\u5173\u8054\u76f4\u64ad\u6570": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getLivesNum);
                        continue block18;
                    }
                    case "\u9500\u91cf": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getSalesNum);
                        continue block18;
                    }
                    case "\u9500\u552e\u989d": {
                        this.handleEqString(value, (QueryWrapper<Shop>)query, Shop::getSalesAmount);
                        continue block18;
                    }
                    case "\u76f4\u64ad\u5e26\u8d27": {
                        query.lambda().isNotNull(Shop::getLivesNum);
                        continue block18;
                    }
                    case "\u89c6\u9891\u5e26\u8d27": {
                        query.lambda().isNotNull(Shop::getVideosNum);
                        continue block18;
                    }
                }
                throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b");
            }
        }
        if ((keyWord = param.getKeyWord()) != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(Shop::getShopName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(Shop::getShopId, (Object)keyWord);
                });
            });
        }
        if ((column = param.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = param.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new RedBookTopManEntity()));
        }
        return query;
    }

    private void handlelikeString(String value, QueryWrapper<Shop> query, SFunction<Shop, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().like(field, (Object)value);
    }

    private void handleEqString(String value, QueryWrapper<Shop> query, SFunction<Shop, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void collect(ShopCollectDTO dto) {
        if (dto.getCollect() == 1) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
    }

    private void collectHandle(ShopCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        ShopVO entity = dto.getEntity();
        if (dto.getCollect() == 1) {
            ShopCollect collect = new ShopCollect();
            collect.setShopId(entity.getShopId());
            collect.setPlatform(1);
            collect.setElsAccount(elsAccount);
            collect.setSubAccount(subAccount);
            this.shopCollectService.save((Object)collect);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(ShopCollect::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(ShopCollect::getPlatform, (Object)"1");
            queryWrapper.lambda().eq(ShopCollect::getShopId, (Object)entity.getShopId());
            this.shopCollectService.remove((Wrapper)queryWrapper);
        }
    }

    public void addMarkToSpider(ShopCollectDTO dto) {
        this.saveRedBookSpiderTopMan(dto.getEntity());
    }

    private void saveRedBookSpiderTopMan(ShopVO vo) {
        Shop entity = new Shop();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(Shop::getShopId, (Object)entity.getShopId());
        Shop info = (Shop)((Object)((ShopMapper)this.baseMapper).selectOne((Wrapper)query));
        if (info == null) {
            entity.setPlatform(1);
            entity.setId("");
        } else {
            entity.setId(info.getId());
        }
        this.saveOrUpdate((Object)entity);
    }

    @Override
    public ShopDetailVO queryDetailHead(ShopDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.SHOPS_DETAIL_INFO;
        ShopDetailVO result = null;
        String redisKey = "ShopDetailHead_" + dto.getShopId();
        if (dto.getClearCache() == 1) {
            result = (ShopDetailVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("shopid", dto.getShopId());
        apiParam.put("DetailUrl", dto.getDetailUrl());
        if (result == null) {
            result = new ShopDetailVO();
            ShopDetailVO.DetailHead detailHead = this.spiderApiUtil.postForEntity(methodType, apiParam, ShopDetailVO.DetailHead.class);
            if (detailHead != null) {
                HashMap<String, String> apiParam2 = new HashMap<String, String>(3);
                apiParam2.put("shopid", dto.getShopId());
                apiParam2.put("minDateCode", dto.getMinDateCode());
                apiParam2.put("maxDateCode", dto.getMaxDateCode());
                ShopDetailVO.PromotionalData data = this.spiderApiUtil.postForEntity(SpiderMethodType.SHOPS_HOT_ANALYSISP_DYNAMIC_STAT, apiParam2, ShopDetailVO.PromotionalData.class);
                detailHead.setBloggerCount(data != null ? data.getBloggerCount() : 0);
                result.setDetailHead(detailHead);
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else {
            boolean check = this.spiderApiUtil.checkCache(methodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    dto.setClearCache(1);
                    this.queryDetailHead(dto);
                });
            }
        }
        List<String> ids = Collections.singletonList(dto.getShopId());
        List<ShopVO> checkCollects = ((ShopMapper)this.baseMapper).checkCollect(ids, SysUtil.getLoginUser(), dto.getPlatform());
        if (CollectionUtil.isNotEmpty(checkCollects)) {
            result.setIsCollection(checkCollects.get(0).getIsCollection());
        }
        return result;
    }

    @Override
    public ShopDetailVO queryDetailTopManCategory(ShopDetailDTO dto) {
        SpiderMethodType spiderMethodType = SpiderMethodType.SHOPS_BLOGGER_ANALYSIS_SEARCH_ITEMS;
        ShopDetailVO result = null;
        String redisKey = "ShopDetailTopManCategory_" + dto.getShopId() + "_" + dto.getMinDateCode() + "_" + dto.getMaxDateCode();
        if (dto.getClearCache() == 1) {
            result = (ShopDetailVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("shopid", dto.getShopId());
        apiParam.put("minDateCode", dto.getMinDateCode());
        apiParam.put("maxDateCode", dto.getMaxDateCode());
        if (result == null) {
            result = new ShopDetailVO();
            ShopDetailVO.TopManCategory topManCategory = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, ShopDetailVO.TopManCategory.class);
            if (topManCategory != null) {
                result.setTopManCategory(topManCategory);
            }
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache(1);
                this.queryDetailTopManCategory(dto);
            });
        }
        return result;
    }

    @Override
    public ShopDetailVO queryDetailTopManList(ShopDetailDTO dto) {
        ShopDetailVO result = new ShopDetailVO();
        Map<?, ?> map = this.handleTopManBody(dto);
        ShopDetailVO.TopManList topManList = this.spiderApiUtil.postForEntity(SpiderMethodType.SHOPS_BLOGGER_ANALYSIS_DATA, map, ShopDetailVO.TopManList.class);
        if (topManList != null) {
            result.setTopManList(topManList);
        }
        return result;
    }

    private Map<?, ?> handleTopManBody(ShopDetailDTO dto) {
        ShopTopManApiDTO apiDTO = new ShopTopManApiDTO(dto.getPage(), dto.getPageSize());
        apiDTO.setShopid(dto.getShopId());
        apiDTO.setSort(dto.getSort());
        apiDTO.setMinDateCode(dto.getMinDateCode());
        apiDTO.setMaxDateCode(dto.getMaxDateCode());
        apiDTO.setKeyword(dto.getKeyword());
        apiDTO.setBlogTagId(dto.getBlogTagValue());
        apiDTO.setDyCate0(dto.getCatgeorysId());
        apiDTO.setBloggerType(dto.getBloggerLevelsValue());
        apiDTO.setBloggerFansGt(dto.getFansCountsFrom());
        apiDTO.setBloggerFansLt(dto.getFansCountsTo());
        String json = JSON.toJSONString((Object)apiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    @Override
    public ShopDetailVO queryDetailGoodsCategory(ShopDetailDTO dto) {
        SpiderMethodType spiderMethodType = SpiderMethodType.SHOPS_PROMOTION_ANALYSIS_SEARCH_ITEMS;
        ShopDetailVO result = null;
        String redisKey = "ShopDetailGoodsCategory_" + dto.getShopId() + "_" + dto.getMinDateCode() + "_" + dto.getMaxDateCode();
        if (dto.getClearCache() == 1) {
            result = (ShopDetailVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("shopid", dto.getShopId());
        apiParam.put("minDateCode", dto.getMinDateCode());
        apiParam.put("maxDateCode", dto.getMaxDateCode());
        if (result == null) {
            result = new ShopDetailVO();
            ShopDetailVO.GoodsCategory goodsCategory = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, ShopDetailVO.GoodsCategory.class);
            if (goodsCategory != null) {
                result.setGoodsCategory(goodsCategory);
            }
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache(1);
                this.queryDetailGoodsCategory(dto);
            });
        }
        return result;
    }

    @Override
    public ShopDetailVO queryDetailGoodsList(ShopDetailDTO dto) {
        ShopDetailVO result = new ShopDetailVO();
        Map<?, ?> map = this.handleGoodsBody(dto);
        ShopDetailVO.GoodsList goodsList = this.spiderApiUtil.postForEntity(SpiderMethodType.SHOPS_PROMOTION_ANALYSIS_DATA, map, ShopDetailVO.GoodsList.class);
        if (goodsList != null) {
            result.setGoodsList(goodsList);
        }
        return result;
    }

    private Map<?, ?> handleGoodsBody(ShopDetailDTO dto) {
        ShopGoodsApiDTO apiDTO = new ShopGoodsApiDTO(dto.getPage(), dto.getPageSize());
        apiDTO.setShopid(dto.getShopId());
        apiDTO.setSort(dto.getSort());
        apiDTO.setMinDateCode(dto.getMinDateCode());
        apiDTO.setMaxDateCode(dto.getMaxDateCode());
        apiDTO.setKeyword(dto.getKeyword());
        apiDTO.setCateId(dto.getCatgeorysId());
        apiDTO.setBrandId(dto.getBrandsValue());
        apiDTO.setSalesType(dto.getSalesTypeValue());
        apiDTO.setPriceGt(dto.getPriceFilterFrom());
        apiDTO.setPriceLt(dto.getPriceFilterTo());
        apiDTO.setCosRatioGt(dto.getCosRatioFilterFrom());
        apiDTO.setCosRatioLt(dto.getCosRatioFilterTo());
        String json = JSON.toJSONString((Object)apiDTO);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    @Override
    public void addCategory() {
        String id = "5YaF5a655YiG57G7Mw==";
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        ShopDetailVO.ShopsCategory shopsCategory = this.spiderApiUtil.getForEntity(SpiderMethodType.SHOPS_ITEMS, new HashMap<String, Object>(), ShopDetailVO.ShopsCategory.class);
        List<ShopDetailVO.Categorys> categorys = shopsCategory.getCategorys();
        if (CollectionUtil.isEmpty(categorys)) {
            return;
        }
        List<Category> categoryList = this.childrenConverter(categorys);
        Update update = new Update().set("directory_json", categoryList);
        this.mongoTemplate.upsert(query, (UpdateDefinition)update, Category.class, "tb_shop_category_copy1");
    }

    private List<Category> childrenConverter(List<ShopDetailVO.Categorys> categorys) {
        return categorys.stream().map(h -> {
            Category category = new Category();
            category.setComponentType("RMultipleChoice");
            category.setId(h.getValue());
            category.setValue(h.getValue());
            category.setLabel(h.getText());
            category.setChildren(this.getParam((ShopDetailVO.Categorys)h));
            return category;
        }).collect(Collectors.toList());
    }

    private List<Category> getParam(ShopDetailVO.Categorys categorys) {
        ArrayList<Category> cateList = new ArrayList<Category>();
        List<ShopDetailVO.TwoItem> children = categorys.getSearchTwoLevelItemList();
        if (CollectionUtil.isNotEmpty(children)) {
            children.forEach(a -> {
                Category category = new Category();
                category.setId(a.getValue());
                category.setValue(a.getValue());
                category.setLabel(a.getText());
                List<ShopDetailVO.ThreeItem> children1 = a.getSearchThreeLevelItemList();
                if (CollectionUtil.isEmpty(children1)) {
                    category.setChildren(null);
                } else {
                    ArrayList<Category> sonCateList = new ArrayList<Category>();
                    children1.forEach(b -> {
                        Category category1 = new Category();
                        category1.setId(a.getValue());
                        category1.setValue(a.getValue());
                        category1.setLabel(a.getText());
                        category1.setChildren(null);
                        sonCateList.add(category1);
                    });
                    category.setChildren(sonCateList);
                }
                cateList.add(category);
            });
        }
        return cateList;
    }

    private class Category {
        private String componentType;
        private String id;
        private String value;
        private String label;
        private List<Category> children;

        public String getComponentType() {
            return this.componentType;
        }

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        public List<Category> getChildren() {
            return this.children;
        }

        public void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setChildren(List<Category> children) {
            this.children = children;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Category)) {
                return false;
            }
            Category other = (Category)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$componentType = this.getComponentType();
            String other$componentType = other.getComponentType();
            if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            List<Category> this$children = this.getChildren();
            List<Category> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Category;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $componentType = this.getComponentType();
            result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            List<Category> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String toString() {
            return "ShopServiceImpl.Category(componentType=" + this.getComponentType() + ", id=" + this.getId() + ", value=" + this.getValue() + ", label=" + this.getLabel() + ", children=" + this.getChildren() + ")";
        }
    }
}

