/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.message.api.dto.ElsMsgConfigHeadDTO;
import com.els.modules.message.api.service.MsgConfigRpcService;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.modules.supplier.api.service.SupplierContactsInfoRpcService;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SupplierContactsInfoBeanServiceImpl
implements SupplierContactsInfoRpcService {
    @Resource
    private SupplierContactsInfoService supplierContactsInfoService;
    @Resource
    private MsgConfigRpcService msgConfigRpcService;
    @Resource
    private AccountRpcService accountRpcService;

    public List<SupplierContactsInfoDTO> getDataOnlyAccount(String elsAccount) {
        List contactsInfos = this.supplierContactsInfoService.getDataOnlyAccount(elsAccount);
        if (contactsInfos != null) {
            return SysUtil.copyProperties((List)contactsInfos, SupplierContactsInfoDTO.class);
        }
        return null;
    }

    public void deleteByElsAccount(String elsAccount) {
        this.supplierContactsInfoService.deleteByElsAccount(elsAccount);
    }

    public void insertBatchSomeColumn(List<SupplierContactsInfoDTO> addressInfoDTOs) {
        ArrayList contactsInfos = SysUtil.copyProperties(addressInfoDTOs, SupplierContactsInfo.class);
        this.supplierContactsInfoService.saveBatch((Collection)contactsInfos);
    }

    public Map<String, Object> getMsgContacts(List<String> toElsAccounts, String businessType, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List configHeadDTOs = this.msgConfigRpcService.getByOperation(TenantContext.getTenant(), businessType, operation);
        for (String elsAccount : toElsAccounts) {
            ArrayList<ElsSubAccountDTO> accountDTOs = new ArrayList<ElsSubAccountDTO>();
            if (configHeadDTOs != null && configHeadDTOs.size() > 0 && StringUtils.isNotBlank((CharSequence)((ElsMsgConfigHeadDTO)configHeadDTOs.get(0)).getJobFunction())) {
                String jobFunction = ((ElsMsgConfigHeadDTO)configHeadDTOs.get(0)).getJobFunction();
                List contactsInfos = this.supplierContactsInfoService.getByAccount(elsAccount, null);
                if (contactsInfos != null && contactsInfos.size() > 0) {
                    for (SupplierContactsInfo contactsInfo : contactsInfos) {
                        if (!jobFunction.equals(contactsInfo.getFunctionName())) continue;
                        ElsSubAccountDTO accountDTO = this.accountRpcService.getAccount(elsAccount, contactsInfo.getSubAccount());
                        accountDTOs.add(accountDTO);
                    }
                } else {
                    ElsSubAccountDTO accountDTO = this.accountRpcService.getAccount(elsAccount, "1001");
                    accountDTOs.add(accountDTO);
                }
            } else {
                ElsSubAccountDTO accountDTO = this.accountRpcService.getAccount(elsAccount, "1001");
                accountDTOs.add(accountDTO);
            }
            map.put(elsAccount, accountDTOs);
        }
        return map;
    }
}

