/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.global.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import com.els.modules.performance.entity.PurchasePerformanceReportHead;
import com.els.modules.performance.entity.SalePerformanceReportHead;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.performance.service.SalePerformanceReportHeadService;
import com.els.modules.supplier.entity.PurchaseStandardHead;
import com.els.modules.supplier.entity.SaleStandardHead;
import com.els.modules.supplier.service.PurchaseStandardHeadService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="supplierImUserRecordRpcService")
public class SupplierBeanImUserRecordRpcService
implements ImUserRecordRpcService {
    @Resource
    private SaleStandardHeadService saleStandardHeadService;
    @Resource
    private PurchaseStandardHeadService purchaseStandardHeadService;
    @Resource
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Resource
    private SalePerformanceReportHeadService salePerformanceReportHeadService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        if (ImRecordTypeEnum.SUPPLIER_ACCESS_SALE_HEAD.getValue().equals(imRecordDto.getType())) {
            SaleStandardHead dbHead = (SaleStandardHead)this.saleStandardHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_zdImtWWWWxMK_a4152cc", (String)"\u5206\u9879\u68c0\u67e5\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = StrUtil.isNotEmpty((CharSequence)toElsAccount) && toElsAccount.split("_").length == 2 ? toElsAccount.split("_")[1] : "1001";
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        } else if (ImRecordTypeEnum.PURCHASE_STANDARD_HEAD.getValue().equals(imRecordDto.getType())) {
            PurchaseStandardHead dbHead = (PurchaseStandardHead)this.purchaseStandardHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_zdImtWWWWxMK_a4152cc", (String)"\u5206\u9879\u68c0\u67e5\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = StrUtil.isNotEmpty((CharSequence)toElsAccount) && toElsAccount.split("_").length == 2 ? toElsAccount.split("_")[1] : "1001";
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        } else if (ImRecordTypeEnum.PURCHASE_PERFORMANCE_REPORT.getValue().equals(imRecordDto.getType())) {
            PurchasePerformanceReportHead dbHead = (PurchasePerformanceReportHead)this.purchasePerformanceReportHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = StrUtil.isNotEmpty((CharSequence)toElsAccount) && toElsAccount.split("_").length == 2 ? toElsAccount.split("_")[1] : "1001";
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        } else if (ImRecordTypeEnum.SALE_PERFORMANCE_REPORT.getValue().equals(imRecordDto.getType())) {
            SalePerformanceReportHead dbHead = (SalePerformanceReportHead)this.salePerformanceReportHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = StrUtil.isNotEmpty((CharSequence)toElsAccount) && toElsAccount.split("_").length == 2 ? toElsAccount.split("_")[1] : "1001";
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

