/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.api.dto.EnterpriseRiskDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataAndEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.modules.supplier.entity.SupplierAccessHead;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.RiskService;
import com.els.modules.supplier.service.SupplierAccessHeadService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.EnterpriseRiskVO;
import com.els.modules.supplier.vo.RiskVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterDataBeanServiceImpl
implements SupplierMasterDataRpcService {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataBeanServiceImpl.class);
    private static ExecutorService THREAD_POOL = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private SupplierAccessHeadService supplierAccessHeadService;
    @Resource
    private RiskService riskService;

    public List<SupplierMasterDataDTO> listByToElsAccount(String toElsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        List datas = this.supplierMasterDataService.list((Wrapper)wrapper);
        if (!datas.isEmpty()) {
            return SysUtil.copyProperties((List)datas, SupplierMasterDataDTO.class);
        }
        return null;
    }

    public List<SupplierMasterDataDTO> findSupplierList(String elsAccount, String supplierName) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        if (StrUtil.isNotBlank((CharSequence)supplierName)) {
            wrapper.like((Object)"supplier_name", (Object)supplierName);
        }
        List datas = this.supplierMasterDataService.list((Wrapper)wrapper);
        return SysUtil.copyProperties((List)datas, SupplierMasterDataDTO.class);
    }

    public void updateById(SupplierMasterDataDTO dataDTO) {
        SupplierMasterData data = (SupplierMasterData)SysUtil.copyProperties((Object)dataDTO, SupplierMasterData.class);
        this.supplierMasterDataService.updateById((Object)data);
    }

    public SupplierMasterDataDTO getByAccount(String elsAccount, String toELsAccount) {
        SupplierMasterData masterData = this.supplierMasterDataService.getByAccount(elsAccount, toELsAccount);
        if (masterData != null) {
            return (SupplierMasterDataDTO)SysUtil.copyProperties((Object)masterData, SupplierMasterDataDTO.class);
        }
        return null;
    }

    public SupplierMasterDataDTO addUnfamiliarSupplier(String elsAccount) {
        SupplierMasterData masterData = this.supplierMasterDataService.addUnfamiliarSupplier(elsAccount);
        if (masterData != null) {
            return (SupplierMasterDataDTO)SysUtil.copyProperties((Object)masterData, SupplierMasterDataDTO.class);
        }
        return null;
    }

    public List<SupplierMasterDataDTO> selectSupplerList(String elsAccount, List<String> toElsAccounts) {
        List supplierMasterDataList = this.supplierMasterDataService.selectSupplerList(elsAccount, toElsAccounts);
        ArrayList<SupplierMasterDataDTO> supplierMasterDataDTOList = new ArrayList<SupplierMasterDataDTO>();
        if (CollectionUtil.isNotEmpty((Collection)supplierMasterDataList)) {
            for (SupplierMasterData supplierMasterData : supplierMasterDataList) {
                SupplierMasterDataDTO supplierMasterDataDTO = new SupplierMasterDataDTO();
                BeanUtils.copyProperties((Object)supplierMasterData, (Object)supplierMasterDataDTO);
                supplierMasterDataDTOList.add(supplierMasterDataDTO);
            }
        }
        return supplierMasterDataDTOList;
    }

    public int insert(SupplierMasterDataDTO dataDTO) {
        SupplierMasterData masterData = (SupplierMasterData)SysUtil.copyProperties((Object)dataDTO, SupplierMasterData.class);
        this.supplierMasterDataService.save((Object)masterData);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> list(String toElsAccount, String frozenFunction) {
        ArrayList<String> elsAccounts = new ArrayList<String>();
        String elsAccount = TenantContext.getTenant();
        if (elsAccount.equals(toElsAccount) || "100000".equals(elsAccount)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
            if (StringUtils.isNotBlank((CharSequence)frozenFunction)) {
                queryWrapper.notLike((Object)"frozen_function", (Object)frozenFunction);
            }
            ((QueryWrapper)queryWrapper.groupBy((Object)"els_account")).select(new String[]{"els_account"});
            List datas = this.supplierMasterDataService.list((Wrapper)queryWrapper);
            if (datas == null || datas.size() <= 0) return null;
            elsAccounts = new ArrayList();
            for (SupplierMasterData data : datas) {
                elsAccounts.add(data.getElsAccount());
            }
            return elsAccounts;
        } else {
            elsAccounts.add(elsAccount);
        }
        return elsAccounts;
    }

    public Map<List<String>, Map<String, String>> queryAccessSupplier(String frozenFunctionValue, String cateCodeValue, String purchaseOrgValue, String supplierStatus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"to_els_account,supplier_code"});
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (StringUtils.isNotBlank((CharSequence)frozenFunctionValue)) {
            queryWrapper.notLike((Object)"frozen_function", (Object)frozenFunctionValue);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cateCodeValue})) {
            wrapper.eq((Object)"cate_code", (Object)cateCodeValue);
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseOrgValue)) {
            wrapper.eq((Object)"purchase_org", (Object)purchaseOrgValue);
        }
        if (StringUtils.isNotBlank((CharSequence)supplierStatus)) {
            String[] status = supplierStatus.split(",");
            ArrayList<String> statusList = new ArrayList<String>();
            for (String string : status) {
                statusList.add(string);
            }
            queryWrapper.in((Object)"supplier_status", statusList);
        }
        if (StringUtils.isNotBlank((CharSequence)cateCodeValue) || StringUtils.isNotBlank((CharSequence)purchaseOrgValue)) {
            wrapper.in((Object)"audit_status", new Object[]{AuditStatusEnum.AUDIT_NEW.getValue(), AuditStatusEnum.AUDIT_DOING.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()});
            List accessHeads = this.supplierAccessHeadService.list((Wrapper)wrapper);
            if (accessHeads != null && accessHeads.size() > 0) {
                ArrayList<String> accounts = new ArrayList<String>();
                for (SupplierAccessHead supplierAccessHead : accessHeads) {
                    if (!StringUtils.isNotBlank((CharSequence)supplierAccessHead.getToElsAccount())) continue;
                    accounts.add(supplierAccessHead.getToElsAccount());
                }
                if (accounts.size() > 0) {
                    queryWrapper.notIn((Object)"to_els_account", accounts);
                }
            }
        }
        Page page = new Page(1L, 99999L);
        IPage pageList = this.supplierMasterDataService.page((IPage)page, (Wrapper)queryWrapper);
        ArrayList<String> accounts = null;
        HashMap<String, String> supplier = null;
        if (pageList.getRecords() != null && pageList.getRecords().size() > 0) {
            accounts = new ArrayList<String>();
            supplier = new HashMap<String, String>();
            for (SupplierMasterData masterData : pageList.getRecords()) {
                accounts.add(masterData.getToElsAccount());
                supplier.put(masterData.getToElsAccount(), masterData.getSupplierCode());
            }
        }
        HashMap<List<String>, Map<String, String>> map = new HashMap<List<String>, Map<String, String>>();
        map.put(accounts, supplier);
        return map;
    }

    public List<SupplierMasterDataDTO> getSupplierMasterDataBySupplierCode(List<String> supplierCode) {
        if (CollUtil.isEmpty(supplierCode)) {
            return Lists.newArrayList();
        }
        List list = this.supplierMasterDataService.getSupplierMasterDataBySupplierCode(supplierCode);
        return Convert.toList(SupplierMasterDataDTO.class, (Object)list);
    }

    public List<String> getSupplierMasterDataBigB(String elsAccount) {
        return this.supplierMasterDataService.getSupplierMasterDataBigB(elsAccount);
    }

    public List<SupplierMasterDataAndEnterpriseInfoDTO> selectPurchaseByToElsAccount(String elsAccount) {
        return this.supplierMasterDataService.selectPurchaseByToElsAccount(elsAccount);
    }

    public List<EnterpriseRiskDTO> queryRiskRelationFind(Set<String> elsAccounts, String riskType) {
        ArrayList<EnterpriseRiskDTO> enterpriseRiskDTOS = new ArrayList<EnterpriseRiskDTO>();
        ArrayList<Future<EnterpriseRiskDTO>> futureList = new ArrayList<Future<EnterpriseRiskDTO>>();
        for (String string : elsAccounts) {
            final RiskVO riskVO = new RiskVO();
            riskVO.setRiskType(riskType);
            riskVO.setElsAccount(string);
            final String tenant = TenantContext.getTenant();
            Future<EnterpriseRiskDTO> riskDTOFuture = THREAD_POOL.submit(new Callable<EnterpriseRiskDTO>(){

                @Override
                public EnterpriseRiskDTO call() throws Exception {
                    EnterpriseRiskDTO enterpriseRiskDTO = null;
                    try {
                        TenantContext.setTenant((String)tenant);
                        EnterpriseRiskVO enterpriseRiskVO = SupplierMasterDataBeanServiceImpl.this.riskService.queryRiskByElsAccount(riskVO);
                        enterpriseRiskDTO = (EnterpriseRiskDTO)JSON.parseObject((String)JSON.toJSONString((Object)enterpriseRiskVO), EnterpriseRiskDTO.class);
                    }
                    catch (ELSBootException e) {
                        log.error(e.getMessage());
                    }
                    finally {
                        TenantContext.clear();
                    }
                    return enterpriseRiskDTO;
                }
            });
            futureList.add(riskDTOFuture);
        }
        for (Future future : futureList) {
            try {
                EnterpriseRiskDTO enterpriseRiskDTO = (EnterpriseRiskDTO)future.get(3L, TimeUnit.SECONDS);
                if (enterpriseRiskDTO == null) continue;
                enterpriseRiskDTOS.add(enterpriseRiskDTO);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return enterpriseRiskDTOS;
    }

    public List<SupplierMasterDataDTO> listByElsAndToElsAccount(List<String> elsToElsAccountList) {
        List list = this.supplierMasterDataService.listByElsAndToElsAccount(elsToElsAccountList);
        return Convert.toList(SupplierMasterDataDTO.class, (Object)list);
    }

    public List<String> getSupplierElsAccount(String name) {
        return this.supplierMasterDataService.selectWithoutElsAccountToGetELsAccount(name, TenantContext.getTenant());
    }

    public List<String> getSupplierToElsAccount(String name) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{SupplierMasterData::getToElsAccount});
        wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List list = this.supplierMasterDataService.list((Wrapper)wrapper);
        return list.stream().distinct().map(SupplierMasterData::getToElsAccount).collect(Collectors.toList());
    }

    public Map<String, String> createAccount(String enterpriseName, String organType) {
        Map accountMap = this.supplierMasterDataService.createAccount(enterpriseName, organType);
        return accountMap;
    }
}

