/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.config.mybatis.TenantContext;
import com.els.modules.performance.service.PurchasePerformanceReportHeadService;
import com.els.modules.supplier.api.service.SupplierTodoListRpcService;
import com.els.modules.supplier.enumerate.ItemizedCheckStatusEnum;
import com.els.modules.supplier.service.PurchaseStandardHeadService;
import com.els.modules.supplier.service.SaleStandardHeadService;
import com.els.modules.supplier.service.SupplierAccessMgmtQuareviewHeadService;
import com.els.modules.supplier.service.SupplierInfoChangeHeadService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SupplierTodoListSingleServiceImpl
implements SupplierTodoListRpcService {
    @Resource
    private PurchaseStandardHeadService purchaseStandardHeadService;
    @Resource
    private SupplierInfoChangeHeadService supplierInfoChangeHeadService;
    @Resource
    private SupplierAccessMgmtQuareviewHeadService supplierAccessMgmtQuareviewHeadService;
    @Resource
    private PurchasePerformanceReportHeadService purchasePerformanceReportHeadService;
    @Resource
    private SaleStandardHeadService supplierStandardHeadService;

    public Integer countPurchaseStandardHeadList(String elsAccount, String subAccount, List<String> statusList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"standard_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        String standardStatus = statusList.get(0);
        if (ItemizedCheckStatusEnum.ANSWER_IN.getValue().equals(standardStatus)) {
            queryWrapper.gt((Object)("INSTR(respondents_list, 'purchase_" + subAccount + "_')"), (Object)0);
        } else if (ItemizedCheckStatusEnum.BE_EVALUATING.getValue().equals(standardStatus)) {
            queryWrapper.gt((Object)("INSTR(scorer_list, '" + subAccount + "_')"), (Object)0);
        }
        int count = this.purchaseStandardHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSupplierInfoChangeHeadList(String elsAccount, List<String> statusList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.supplierInfoChangeHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSupplierAccessMgmtQuareviewHeadList(String elsAccount, List<String> statusList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"quareview_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.supplierAccessMgmtQuareviewHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countPurchasePerformanceReportHeadList(String elsAccount, String subAccount, List<String> statusList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"report_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        queryWrapper.exists("select 1 from purchase_performance_report_item where purchase_performance_report_item.head_id = purchase_performance_report_head.id and els_account = '" + elsAccount + "' and sub_account like '" + subAccount + "_%' and is_deleted = '0'");
        int count = this.purchasePerformanceReportHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleSupplierAccessMgmtQuareviewHeadList(String elsAccount, List<String> statusList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"quareview_status", statusList);
        queryWrapper.eq((Object)"to_els_account", (Object)TenantContext.getTenant());
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        int count = this.supplierAccessMgmtQuareviewHeadService.count((Wrapper)queryWrapper);
        return count;
    }

    public Integer countSaleStandardHeadList(String elsAccount, String subAccount, List<String> statusList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", new Object[]{elsAccount});
        queryWrapper.in((Object)"standard_status", statusList);
        queryWrapper.in((Object)"is_deleted", new Object[]{0});
        queryWrapper.gt((Object)("INSTR(respondents_list, 'sale_" + subAccount + "_')"), (Object)0);
        int count = this.supplierStandardHeadService.count((Wrapper)queryWrapper);
        return count;
    }
}

