/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.rpc.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.ElsTenantRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SupplierInvokeAccountBeanServiceImpl
implements SupplierInvokeAccountRpcService {
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private ElsTenantRpcService elsTenantRpcService;

    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        return this.accountRpcService.getThirdAccount(accountId, thirdType);
    }

    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        return this.accountRpcService.getPersonalSetting(elsAccount, subAccount);
    }

    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        return this.accountRpcService.getAccount(elsAccount, subAccount);
    }

    public List<ElsSubAccountDTO> getAccountList(String elsAccount, List<String> subAccounts) {
        return this.accountRpcService.getAccountList(elsAccount, subAccounts);
    }

    public List<ElsSubAccountDTO> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        return this.accountRpcService.getAccountListByElsSubAccountWithoutUser(elsSubAccountList);
    }

    public ElsSubAccountDTO getAccountById(String id) {
        return this.accountRpcService.getAccountById(id);
    }

    public LoginUserDTO getLoginUser(String account) {
        return this.accountRpcService.getLoginUser(account);
    }

    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        return this.accountRpcService.getUserRolesSet(elsAccount, subAccount);
    }

    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        return this.accountRpcService.getUserPermissionsSet(elsAccount, subAccount);
    }

    public Set<String> getAllOptPermission() {
        return this.accountRpcService.getAllOptPermission();
    }

    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        return this.accountRpcService.getPermissionDataList(elsAccount, subAccount, businessType);
    }

    public List<ElsSubAccountDTO> getAllByAccount(String account) {
        return this.accountRpcService.getAllByAccount(account);
    }

    public void saveTenant(ElsTenantDTO elsTenantDTO) {
        this.elsTenantRpcService.saveTenant(elsTenantDTO);
    }

    public ElsSubAccountDTO addUserWithRole(ElsSubAccountDTO user, String roles) {
        return this.accountRpcService.addUserWithRole(user, roles);
    }

    public ElsSubAccountDTO save(ElsSubAccountDTO accountDTO) {
        return this.accountRpcService.save(accountDTO);
    }

    public RoleDTO saveRole(RoleDTO roleDTO) {
        return this.accountRpcService.saveRole(roleDTO);
    }

    public List<PermissionDTO> selectDefault() {
        return this.accountRpcService.selectDefault();
    }

    public List<PermissionDTO> selectDefaultWithPurchase(String account) {
        return this.accountRpcService.selectDefaultWithPurchase(account);
    }

    public List<CompanyPermissionDTO> insertCompanyMenuBatch(List<CompanyPermissionDTO> companyPermissionDTOs) {
        return this.accountRpcService.insertCompanyMenuBatch(companyPermissionDTOs);
    }

    public RolePermissionDTO saveRolePermission(RolePermissionDTO permissionDTO) {
        return this.accountRpcService.saveRolePermission(permissionDTO);
    }

    public List<PersonalSettingDTO> savePersonalSetting(List<PersonalSettingDTO> personalSettings) {
        return this.accountRpcService.savePersonalSetting(personalSettings);
    }

    public List<ElsSubAccountDTO> queryByElsAccountList(List<String> accountList) {
        if (CollUtil.isEmpty(accountList)) {
            return Lists.newArrayList();
        }
        return this.accountRpcService.queryByElsAccountList(accountList);
    }

    public List<RoleDTO> getAllRole() {
        return this.accountRpcService.getAllRole();
    }

    public void batchSaveRolePermission(List<RolePermissionDTO> companyPermissionList) {
        this.accountRpcService.batchSaveRolePermission(companyPermissionList);
    }

    public ElsSubAccountDTO initSupplierAccountInfo(String elsAccount, ElsSubAccountDTO account, String companyName, String sourceType) {
        return this.accountRpcService.initSupplierAccountInfo(elsAccount, account, companyName, sourceType);
    }

    public List<RoleDTO> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        if (CollUtil.isEmpty(accountList)) {
            return Lists.newArrayList();
        }
        return this.accountRpcService.selectWithoutElsAccountOfAllRole(accountList);
    }

    public List<String> listCompanyPermission(String toElsAccount) {
        return this.accountRpcService.listCompanyPermission(toElsAccount);
    }

    public RoleDTO getElsAccountAdminRole(String elsAccount) {
        return this.accountRpcService.getElsAccountAdminRole(elsAccount);
    }
}

