/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.AlertRpcService;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.PurchaseCertificatedInfo;
import com.els.modules.supplier.service.PurchaseCertificatedInfoService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="supplierCertificatedAlertServiceImpl")
public class SupplierCertificatedAlertSignleServiceImpl
implements AlertRpcService {
    private static final Logger log = LoggerFactory.getLogger(SupplierCertificatedAlertSignleServiceImpl.class);
    @Resource
    private PurchaseCertificatedInfoService purchaseCertificatedInfoService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<?> getAlertList(JSONObject config) {
        int alertDays = config.getInteger("alertDays");
        Date currentDate = new Date();
        DateTime checkDate = DateUtil.offsetDay((Date)currentDate, (int)alertDays);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)config.getString("elsAccount"))) {
            queryWrapper.eq((Object)"els_account", (Object)config.getString("elsAccount"));
        }
        queryWrapper.eq((Object)"is_fail", (Object)"0");
        queryWrapper.lt((Object)"expiry_date", (Object)checkDate);
        List contractHeads = this.purchaseCertificatedInfoService.list((Wrapper)queryWrapper);
        JSONArray jsonArray = new JSONArray();
        if (CollUtil.isNotEmpty((Collection)contractHeads) && contractHeads.size() > 0) {
            String json = SupplierCertificatedAlertSignleServiceImpl.getJson(contractHeads, "yyyy-MM-dd HH:mm:ss");
            jsonArray = JSONArray.parseArray((String)json);
        }
        if (CollUtil.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                obj.put("busAccount", (Object)obj.getString("elsAccount"));
            }
        }
        return jsonArray;
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        ArrayList<ElsSubAccountDTO> list = new ArrayList<ElsSubAccountDTO>();
        String json = JSON.toJSONString((Object)obj);
        log.info("getPrincipalList:" + json);
        PurchaseCertificatedInfo certificatedInfo = (PurchaseCertificatedInfo)JSON.parseObject((String)json, PurchaseCertificatedInfo.class);
        return list;
    }

    private static String getJson(Object object, String format) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        objectMapper.setDateFormat((DateFormat)sdf);
        try {
            String jsonValue = objectMapper.writeValueAsString(object);
            return jsonValue;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

