/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.AlertRpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="supplierMasterDataTermDateAlertServiceImpl")
public class SupplierMasterDataTermDateAlertSignleServiceImpl
implements AlertRpcService {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataTermDateAlertSignleServiceImpl.class);
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<?> getAlertList(JSONObject config) {
        int alertDays = config.getInteger("alertDays");
        Date currentDate = new Date();
        DateTime checkDate = DateUtil.offsetDay((Date)currentDate, (int)alertDays);
        String elsAccount = StringUtils.isNotBlank((CharSequence)config.getString("elsAccount")) ? config.getString("elsAccount") : SysUtil.getPurchaseAccount();
        TenantContext.setTenant((String)elsAccount);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(StringUtils.isNotBlank((CharSequence)elsAccount), (Object)"els_account", (Object)elsAccount);
        wrapper.ne((Object)"supplier_status", (Object)SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue());
        wrapper.eq((Object)"account_group", (Object)"C005");
        wrapper.lt((Object)"supplier_term_date", (Object)DateUtils.formatDate((Date)checkDate, (String)"yyyy-MM-dd HH:mm:ss"));
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        List list = this.supplierMasterDataService.list((Wrapper)wrapper);
        JSONArray jsonArray = new JSONArray();
        if (CollUtil.isNotEmpty((Collection)list) && list.size() > 0) {
            String json = SupplierMasterDataTermDateAlertSignleServiceImpl.getJson(list, "yyyy-MM-dd hh:mm:ss");
            jsonArray = JSONArray.parseArray((String)json);
        }
        return jsonArray;
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        ElsSubAccountDTO account;
        String principal;
        ArrayList<ElsSubAccountDTO> list = new ArrayList<ElsSubAccountDTO>();
        String json = JSON.toJSONString((Object)obj);
        log.info("getPrincipalList:" + json);
        JSON.parseObject((String)json, SupplierMasterData.class);
        SupplierMasterData supplierMasterData = (SupplierMasterData)JSON.parseObject((String)json, SupplierMasterData.class);
        if (config.containsKey((Object)"purchaseNoticeObj") && "2".equals(config.getString("purchaseNoticeObj")) && StringUtils.isNotBlank((CharSequence)(principal = supplierMasterData.getPrincipal())) && (account = this.invokeAccountRpcService.getAccount(supplierMasterData.getElsAccount(), principal.split("_")[0])) != null) {
            list.add(account);
        }
        return list;
    }

    private static String getJson(Object object, String format) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        objectMapper.setDateFormat((DateFormat)sdf);
        try {
            String jsonValue = objectMapper.writeValueAsString(object);
            return jsonValue;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

