/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.rpc.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRecordDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRelationDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.mapper.SupplierBankInfoMapper;
import com.els.modules.supplier.mapper.SupplierOrgInfoMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SupplierInvokeEnterpriseBeanServiceImpl
implements SupplierInvokeEnterpriseRpcService {
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private SupplierBankInfoMapper supplierBankInfoMapper;
    @Resource
    private SupplierOrgInfoMapper supplierOrgInfoMapper;

    public ElsEnterpriseInfoDTO getByElsAccount(String elsAccount) {
        return this.elsEnterpriseInfoRpcService.getByElsAccount(elsAccount);
    }

    public ElsEnterpriseInfoRelationDTO getByElsAccountAndToelsAccount(String elsAccount, String toElsAccount) {
        return this.elsEnterpriseInfoRpcService.getByElsAccountAndToelsAccount(elsAccount, toElsAccount);
    }

    public ElsEnterpriseInfoRecordDTO getEnterpriseInfoRecordById(String id) {
        return this.elsEnterpriseInfoRpcService.getEnterpriseInfoRecordById(id);
    }

    public int getMaxVersion(String elsAccount, String toElsAccount) {
        return this.elsEnterpriseInfoRpcService.getMaxVersion(elsAccount, toElsAccount);
    }

    public void insert(ElsEnterpriseInfoRecordDTO enterpriseInfoRecordDTO) {
        this.elsEnterpriseInfoRpcService.insert(enterpriseInfoRecordDTO);
    }

    public void updateById(ElsEnterpriseInfoDTO enterpriseInfoDTO) {
        this.elsEnterpriseInfoRpcService.updateById(enterpriseInfoDTO);
    }

    public void updateElsEnterpriseInfoRelation(ElsEnterpriseInfoRelationDTO elsEnterpriseInfoRelationDTO) {
        this.elsEnterpriseInfoRpcService.updateElsEnterpriseInfoRelation(elsEnterpriseInfoRelationDTO);
    }

    public void insert(ElsEnterpriseInfoDTO enterpriseInfoDTO) {
        this.elsEnterpriseInfoRpcService.insert(enterpriseInfoDTO);
    }

    public List<ElsEnterpriseInfoDTO> selectList(String companyName, String isPerson) {
        return this.elsEnterpriseInfoRpcService.selectList(companyName, isPerson);
    }

    public ElsEnterpriseInfoDTO getById(String id) {
        return this.elsEnterpriseInfoRpcService.getById(id);
    }

    public List<ElsEnterpriseInfoDTO> queryByElsAccountList(List<String> accountList) {
        if (CollUtil.isEmpty(accountList)) {
            return Lists.newArrayList();
        }
        return this.elsEnterpriseInfoRpcService.queryByElsAccountList(accountList);
    }

    public List<ElsEnterpriseInfoDTO> selectWithoutElsAccountByElsAccountList(List<String> elsAccountList) {
        if (CollUtil.isEmpty(elsAccountList)) {
            return Lists.newArrayList();
        }
        return this.elsEnterpriseInfoRpcService.selectWithoutElsAccountByElsAccountList(elsAccountList);
    }

    public List<ElsEnterpriseInfoRecordDTO> getEnterpriseInfoRecordByIdList(List<String> enterpriseInfoRecordIdList) {
        if (CollUtil.isEmpty(enterpriseInfoRecordIdList)) {
            return Lists.newArrayList();
        }
        return this.elsEnterpriseInfoRpcService.getEnterpriseInfoRecordByIdList(enterpriseInfoRecordIdList);
    }

    public List<ElsEnterpriseInfoDTO> getListAll() {
        return this.elsEnterpriseInfoRpcService.getListAll();
    }

    public List<ElsEnterpriseInfoRelationDTO> getListRelationAll() {
        return this.elsEnterpriseInfoRpcService.getListRelationAll();
    }

    public void saveBatchRelation(List<ElsEnterpriseInfoRelationDTO> dtoList) {
        this.elsEnterpriseInfoRpcService.saveBatchRelation(dtoList);
    }

    public List<SupplierBankInfo> getBankByElsAccount(String elsAccount) {
        List supplierBankInfoList = this.supplierBankInfoMapper.getBankByAccount(elsAccount);
        return supplierBankInfoList;
    }

    public List<SupplierOrgInfo> getSupplierOrgInfoByElsAccount(String elsAccount) {
        return this.supplierOrgInfoMapper.getSupplierOrgInfoByElsAccount(elsAccount);
    }
}

