/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.sql.api.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.ImgCreatorUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.account.api.service.ElsTenantRpcService;
import com.els.modules.account.api.service.PermissionRpcService;
import com.els.modules.account.api.service.UserRoleRpcService;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRelationDTO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierFrozenStatusEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.modules.third.sql.util.OracleSqlUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetSupplierFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetSupplierFromCQGTOracleDbImpl.class);
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    @Lazy
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Resource
    private SupplierInvokeBaseRpcService supplierinvokeBaseRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private ElsTenantRpcService elsTenantRpcService;
    @Resource
    private UserRoleRpcService userRoleRpcService;
    @Resource
    private PermissionRpcService permissionRpcService;
    @Resource
    private RedisUtil redisUtil;
    public static final String ACCOUNT_PERMISSION = "sys:createAccount:permission:";

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_PO_VENDORS";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetSupplierFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray itemList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        Assert.notEmpty((Collection)itemList, (String)"\u6682\u65e0\u4f9b\u5e94\u5546\u6570\u636e\u9700\u8981\u540c\u6b65");
        List templateList = this.templateRpcService.getDefaultTemplateByType("supplierMasterData");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERWRdXdWFWESWCLWIrW_969a25c1", (String)"\u8bf7\u5148\u914d\u7f6e\u3010\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u3011\u4e1a\u52a1\u3010\u9ed8\u8ba4\u3011\u6a21\u677f\u3002"));
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        String tenant = TenantContext.getTenant();
        ElsEnterpriseInfoDTO purchaseEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(tenant);
        Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
        LoginUser loginUser = SysUtil.getLoginUser();
        Map dbMasterDataMap = this.supplierMasterDataService.list((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).stream().collect(Collectors.toMap(SupplierMasterData::getSupplierCode, Function.identity()));
        for (Object object : itemList) {
            JSONObject item = (JSONObject)object;
            String sourceId = item.getString("VENDOR_ID");
            String supplierName = item.getString("VENDOR_NAME");
            String supplierNumber = item.getString("VENDOR_NUMBER");
            String updateTime = item.getString("UPDATE_TIME");
            String status = item.getString("STATUS");
            if ("\u505c\u7528".equals(status) || dbMasterDataMap.containsKey(supplierNumber)) continue;
            SupplierMasterData supplierMasterData = (SupplierMasterData)JSON.parseObject((String)JSON.toJSONString((Object)headDefaultValue), SupplierMasterData.class);
            supplierMasterData.setElsAccount(TenantContext.getTenant());
            supplierMasterData.setBusAccount(TenantContext.getTenant());
            supplierMasterData.setPurchaseName(purchaseEnterpriseInfo != null ? purchaseEnterpriseInfo.getName() : null);
            supplierMasterData.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
            supplierMasterData.setSourceType(SourceTypeEnum.EXTERNAL_SYATEM.getValue());
            supplierMasterData.setTemplateName(template.getTemplateName());
            supplierMasterData.setTemplateNumber(template.getTemplateNumber());
            supplierMasterData.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
            supplierMasterData.setTemplateAccount(template.getElsAccount());
            supplierMasterData.setPersonPassword("123456");
            supplierMasterData.setPersonSubAccount("1001");
            supplierMasterData.setSourceId(sourceId);
            supplierMasterData.setSupplierName(supplierName);
            supplierMasterData.setSupplierCode(supplierNumber);
            supplierMasterData.setNeedCoordination("1");
            supplierMasterData.setIsPerson("0");
            supplierMasterData.setBankAccount("PayAccountId");
            supplierMasterData.setCreateBy(loginUser.getSubAccount());
            supplierMasterData.setCreateById(loginUser.getId());
            supplierMasterData.setCreateTime(new Date());
            supplierMasterData.setUpdateBy(loginUser.getSubAccount());
            supplierMasterData.setUpdateById(loginUser.getId());
            supplierMasterData.setUpdateTime(OracleSqlUtil.getUpdateTime((String)updateTime));
            this.doNext(supplierMasterData, tenant);
        }
        return interfaceResult;
    }

    private void doNext(SupplierMasterData supplierMasterData, String tenant) {
        RegisterVO registerVO = new RegisterVO();
        registerVO.setCompanyName(supplierMasterData.getSupplierName());
        JSONObject result = this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSData(registerVO.getCompanyName(), registerVO.getSourceType(), tenant), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
        log.info("GetSupplierFromCQGTOracleDbImpl_ipaas_result:" + result.toJSONString());
        if (result.getBoolean("success").booleanValue()) {
            ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = (ElsEnterpriseInfoDTO)JSON.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
            ElsEnterpriseInfoDTO enterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            if (enterpriseInfo == null) {
                ElsEnterpriseInfoDTO2.setDeleted(Integer.valueOf(0));
                ElsEnterpriseInfoDTO2.setDataVersion(CommonConstant.STATUS_NO);
                this.supplierinvokeEnterpriseRpcService.insert(ElsEnterpriseInfoDTO2);
            }
            registerVO.setContactsName(StringUtils.isNotBlank((CharSequence)supplierMasterData.getPersonName()) ? supplierMasterData.getPersonName() : supplierMasterData.getSupplierName());
            registerVO.setSubAccount(supplierMasterData.getPersonSubAccount());
            registerVO.setSourceType(SourceTypeEnum.EXTERNAL_SYATEM.getValue());
            registerVO.setPassword(StringUtils.isNotBlank((CharSequence)supplierMasterData.getPersonPassword()) ? supplierMasterData.getPersonPassword() : "123456");
            supplierMasterData.setToElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            supplierMasterData.setSourceType(registerVO.getSourceType());
            supplierMasterData.setStatus(SupplierFrozenStatusEnum.NORMAL.getValue());
            supplierMasterData.setNeedAudit("0");
            supplierMasterData.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            this.supplierMasterDataService.save((Object)supplierMasterData);
            this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSRelationData(supplierMasterData.getElsAccount(), ElsEnterpriseInfoDTO2.getElsAccount()), "valueAddedApplication", null);
            this.saveSubAccountInfoRpcNew(registerVO, ElsEnterpriseInfoDTO2.getElsAccount());
            if (null == this.supplierinvokeEnterpriseRpcService.getByElsAccountAndToelsAccount(supplierMasterData.getElsAccount(), supplierMasterData.getToElsAccount())) {
                ElsEnterpriseInfoRelationDTO enterpriseInfoRelationDTO = new ElsEnterpriseInfoRelationDTO();
                BeanUtils.copyProperties((Object)ElsEnterpriseInfoDTO2, (Object)enterpriseInfoRelationDTO);
                enterpriseInfoRelationDTO.setId(null);
                enterpriseInfoRelationDTO.setElsAccount(supplierMasterData.getElsAccount());
                enterpriseInfoRelationDTO.setToElsAccount(supplierMasterData.getToElsAccount());
                enterpriseInfoRelationDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                this.supplierinvokeEnterpriseRpcService.saveBatchRelation(Collections.singletonList(enterpriseInfoRelationDTO));
            }
        }
    }

    private JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount) {
        String defaultValue;
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        body.put("channel", (Object)sourceType);
        String auth = SourceTypeEnum.BUSINESS_PROMOTION.getValue().equals(sourceType) || SourceTypeEnum.OPEN_REGISTER.getValue().equals(sourceType) ? "1" : "0";
        body.put("auth", (Object)auth);
        ElsCompanySetDTO companySetDTO = this.invokeBaseRpcService.getElsCompanySetByElsAccountAndItemCode(elsAccount, "failIsCreateAccount");
        if (companySetDTO != null && StringUtils.isNotBlank((CharSequence)(defaultValue = companySetDTO.getDefaultValue()))) {
            body.put("failIsCreateAccount", (Object)defaultValue);
        }
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }

    private JSONObject getIpaaSRelationData(String purchaserElsAccount, String providerElsAccount) {
        JSONObject data = new JSONObject();
        data.put("purchaserElsAccount", (Object)purchaserElsAccount);
        data.put("providerElsAccount", (Object)providerElsAccount);
        return data;
    }

    private void saveSubAccountInfoRpcNew(RegisterVO registerVO, String elsAccount) {
        ElsSubAccountDTO account = new ElsSubAccountDTO();
        account.setElsAccount(elsAccount);
        account.setSubAccount(StringUtils.isNotBlank((CharSequence)registerVO.getSubAccount()) ? registerVO.getSubAccount() : "1001");
        account.setRealname(registerVO.getContactsName());
        account.setPhone(registerVO.getPhoneNumber());
        account.setStatus(Integer.valueOf(1));
        account.setEmail(registerVO.getEmail());
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String password = registerVO.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        account.setDeleted(Integer.valueOf(0));
        byte[] bytes = ImgCreatorUtil.generateImg((String)account.getRealname());
        if (null != bytes) {
            String fileName = System.currentTimeMillis() + ".jpg";
            Object filePath = this.getFilePath() + File.separator + System.currentTimeMillis() + fileName;
            filePath = ((String)filePath).contains("\\") ? ((String)filePath).replace("\\", "/") : filePath;
            String avatar = this.supplierinvokeBaseRpcService.uploadFile(bytes, (String)filePath, fileName);
            if (StrUtil.isEmpty((CharSequence)avatar)) {
                account.setAvatar("/im/layim-v3.9.6/dist/css/modules/layim/skin/default.png");
            } else {
                account.setAvatar(this.supplierinvokeBaseRpcService.getRealPath(avatar, null));
            }
        }
        RoleDTO role = this.createOrGetRole(elsAccount);
        boolean exist = this.userRoleRpcService.createUserIfNotExist(account);
        if (!exist) {
            this.userRoleRpcService.saveUserRole(account.getId(), role.getId());
        }
        this.savePersonalSetting(elsAccount, account.getSubAccount());
        this.supplierInvokeAccountRpcService.savePasswordSecurity(elsAccount);
        this.saveTenant(elsAccount, registerVO.getCompanyName(), registerVO.getSourceType());
        this.handleCompanyPermissionData(elsAccount, role.getId());
    }

    private void handleCompanyPermissionData(String elsAccount, String roleId) {
        this.permissionRpcService.deleteCompanyMeunByAccount(null, elsAccount);
        List list = new ArrayList();
        String redisKey = ACCOUNT_PERMISSION + elsAccount;
        if (this.redisUtil.get(redisKey) == null && CharSequenceUtil.isNotBlank((CharSequence)elsAccount)) {
            HashSet<String> accountSet = new HashSet<String>();
            accountSet.add(elsAccount);
            list = this.permissionRpcService.selectWithoutElsAccountToLoadExistSalePermission(accountSet);
            if (CollUtil.isNotEmpty(list)) {
                Set permissionIdList = list.stream().map(PermissionDTO::getId).collect(Collectors.toSet());
                list.addAll(this.permissionRpcService.selectWithoutElsAccountToLoadSaleButtonPermission(permissionIdList));
            }
            this.redisUtil.set(redisKey, (Object)JSON.toJSONString(list), 1800L);
        } else {
            list = JSONArray.parseArray((String)this.redisUtil.get(redisKey).toString(), PermissionDTO.class);
        }
        ArrayList<CompanyPermissionDTO> companyPermissions = new ArrayList<CompanyPermissionDTO>();
        for (PermissionDTO permission : list) {
            CompanyPermissionDTO companyPermission = new CompanyPermissionDTO();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setName(permission.getName());
            companyPermission.setSortNo(permission.getSortNo());
            companyPermission.setIcon(permission.getIcon());
            companyPermission.setIconColor(permission.getIconColor());
            companyPermission.setRuleFlag(permission.getRuleFlag());
            companyPermission.setStatus(permission.getStatus());
            companyPermission.setUpdateTime(new Date());
            companyPermissions.add(companyPermission);
        }
        if (CollUtil.isNotEmpty(companyPermissions)) {
            this.permissionRpcService.insertCompanyMeunBatch(companyPermissions);
            ArrayList<RolePermissionDTO> RolePermissionList = new ArrayList<RolePermissionDTO>();
            for (CompanyPermissionDTO companyPermission : companyPermissions) {
                RolePermissionDTO rolePermission = new RolePermissionDTO();
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(roleId);
                rolePermission.setPermissionId(companyPermission.getPermissionId());
                RolePermissionList.add(rolePermission);
            }
            this.permissionRpcService.batchSaveRolePermission(RolePermissionList);
        }
    }

    private void savePersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSettingDTO> personalSettings = new ArrayList<PersonalSettingDTO>();
        for (String str : list) {
            PersonalSettingDTO personalSetting = new PersonalSettingDTO();
            personalSetting.setId(IdWorker.getIdStr());
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime((Date)DateUtil.date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime((Date)DateUtil.date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(Integer.valueOf(0));
            personalSettings.add(personalSetting);
        }
        this.supplierInvokeAccountRpcService.savePersonalSetting(personalSettings);
    }

    private String getFilePath() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowDay = dtf.format(time);
        return File.separator + "files" + File.separator + TenantContext.getTenant() + File.separator + nowDay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleDTO createOrGetRole(String elsAccount) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)elsAccount);
            RoleDTO role = this.userRoleRpcService.getRoleByElsAccountAndSysCode(elsAccount, "companyAdmin");
            if (role == null) {
                role = new RoleDTO();
                role.setElsAccount(elsAccount);
                role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                role.setRoleCode("companyAdmin");
                this.userRoleRpcService.insertRole(role);
            }
            RoleDTO roleDTO = role;
            return roleDTO;
        }
        finally {
            TenantContext.clear();
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            }
        }
    }

    private void saveTenant(String elsAccount, String companyName, String sourceType) {
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsTenantDTO account = this.elsTenantRpcService.getElsTenantByAccount(elsAccount);
        if (null != account && elsAccount.equals(account.getElsAccount())) {
            return;
        }
        ElsTenantDTO elsTenant = new ElsTenantDTO();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(companyName);
        elsTenant.setSourceType(sourceType);
        elsTenant.setUpdateBy(loginUser.getId());
        elsTenant.setCreateBy(loginUser.getId());
        elsTenant.setExpiryDate((Date)DateUtil.parseDate((CharSequence)"2029-12-31"));
        this.supplierInvokeAccountRpcService.saveTenant(elsTenant);
    }
}

