/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.sql.api.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.supplier.service.SupplierMasterDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierFromCQGTJobServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(SupplierFromCQGTJobServiceImpl.class);
    @Autowired
    private SupplierMasterDataService supplierMasterDataService;
    @Autowired
    private RedisUtil redisUtil;

    public void execute(String parameter) {
        String LOCK_PREFIX = "SupplierMaster_schedule_supplierMasterFromCQGTJob";
        String requestId = "SupplierMasterFromCQGTJob";
        long EXPIRE_TIME = 50000L;
        if (!this.redisUtil.tryGetDistributedLock(LOCK_PREFIX, requestId, EXPIRE_TIME)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5b9a\u65f6\u4efb\u52a1 SupplierFromCQGTJobServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        try {
            this.supplierMasterDataService.getDataByErp();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_PREFIX, requestId);
        }
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5b9a\u65f6\u4efb\u52a1 SupplierFromCQGTJobServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

