/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.u8.api.extend;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.context.TokenContext;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.ImgCreatorUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRelationDTO;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.entity.SupplierOrgInfo;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierFrozenStatusEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.service.SupplierBankInfoService;
import com.els.modules.supplier.service.SupplierContactsInfoService;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.service.SupplierOrgInfoService;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.rpc.service.ManualTransactionManagementService;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GetSupplierFromJingHuaU8DbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetSupplierFromJingHuaU8DbImpl.class);
    @Resource
    private SupplierMasterDataService supplierMasterDataService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Resource
    private ManualTransactionManagementService manualTransactionManagementService;
    @Resource
    private SupplierInvokeBaseRpcService supplierinvokeBaseRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SupplierInvokeAccountRpcService supplierInvokeAccountRpcService;
    @Resource
    private SupplierContactsInfoService supplierContactsInfoService;
    @Resource
    private SupplierBankInfoService supplierBankInfoService;
    @Resource
    private SupplierOrgInfoService supplierOrgInfoService;

    public JSONObject before(JSONObject obj, Object custom) {
        Object sql = "select * from AJNdCompanyQQT_Q3SendInfo";
        List supplierCodeList = this.supplierMasterDataService.list((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).stream().map(supplier -> "'" + supplier.getSupplierCode() + "'").filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierCodeList)) {
            sql = (String)sql + " where companyid not in (" + String.join((CharSequence)",", supplierCodeList) + ")";
        }
        obj.put("body", sql);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("PublishOrderFromJingHuaU8DbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray u8ItemList = this.handlerResultListInfo(interfaceResult);
        Assert.notEmpty((Collection)u8ItemList, (String)"\u6682\u65e0\u4f9b\u5e94\u5546\u6570\u636e\u9700\u8981\u540c\u6b65");
        List templateList = this.templateRpcService.getDefaultTemplateByType("supplierMasterData");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERWRdXdWFWESWCLWIrW_969a25c1", (String)"\u8bf7\u5148\u914d\u7f6e\u3010\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u3011\u4e1a\u52a1\u3010\u9ed8\u8ba4\u3011\u6a21\u677f\u3002"));
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        String tenant = TenantContext.getTenant();
        ElsEnterpriseInfoDTO purchaseEnterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(tenant);
        Map headDefaultValue = this.templateRpcService.getDefaultValueMap(template.getElsAccount(), template.getTemplateNumber(), String.valueOf(template.getTemplateVersion()));
        LoginUser loginUser = SysUtil.getLoginUser();
        ArrayList<SupplierMasterData> insertList = new ArrayList<SupplierMasterData>();
        for (Object object : u8ItemList) {
            SupplierMasterData supplierMasterData = (SupplierMasterData)JSON.parseObject((String)JSON.toJSONString((Object)headDefaultValue), SupplierMasterData.class);
            JSONObject item2 = (JSONObject)object;
            supplierMasterData.setElsAccount(TenantContext.getTenant());
            supplierMasterData.setBusAccount(TenantContext.getTenant());
            supplierMasterData.setPurchaseName(purchaseEnterpriseInfo != null ? purchaseEnterpriseInfo.getName() : null);
            supplierMasterData.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
            supplierMasterData.setSourceType(SourceTypeEnum.EXTERNAL_SYATEM.getValue());
            supplierMasterData.setTemplateName(template.getTemplateName());
            supplierMasterData.setTemplateNumber(template.getTemplateNumber());
            supplierMasterData.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
            supplierMasterData.setTemplateAccount(template.getElsAccount());
            supplierMasterData.setPersonPassword("123456");
            supplierMasterData.setPersonEmail(item2.getString("AssPhone"));
            supplierMasterData.setPersonName(StringUtils.isBlank((CharSequence)item2.getString("AssName")) ? item2.getString("CompanyName") : item2.getString("AssName"));
            supplierMasterData.setPersonSubAccount("1001");
            supplierMasterData.setSupplierName(item2.getString("CompanyName"));
            supplierMasterData.setSupplierCode(item2.getString("companyid"));
            supplierMasterData.setCurrency(item2.getString("MoneyCode"));
            supplierMasterData.setLocalCurrency(item2.getString("MoneyCode"));
            supplierMasterData.setTaxCode(item2.getString("InvoiceTypeId"));
            supplierMasterData.setNeedCoordination("1");
            supplierMasterData.setIsPerson("0");
            supplierMasterData.setBankAccount("PayAccountId");
            supplierMasterData.setCreateBy(loginUser.getSubAccount());
            supplierMasterData.setCreateById(loginUser.getId());
            supplierMasterData.setCreateTime(new Date());
            supplierMasterData.setUpdateBy(loginUser.getSubAccount());
            supplierMasterData.setUpdateById(loginUser.getId());
            supplierMasterData.setUpdateTime(new Date());
            insertList.add(supplierMasterData);
        }
        this.supplierMasterDataService.saveBatch(insertList, 2000);
        String token = this.getToken();
        Map<String, JSONObject> u8DbMap = u8ItemList.stream().collect(Collectors.toMap(item -> ((JSONObject)item).getString("companyid"), item -> (JSONObject)item));
        for (SupplierMasterData data : insertList) {
            Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
            executor.execute(() -> {
                try {
                    TenantContext.setTenant((String)tenant);
                    LoginUserContext.setUser((LoginUser)loginUser);
                    TokenContext.setToken((String)token);
                    try {
                        this.manualTransactionManagementService.begin();
                    }
                    catch (Exception e) {
                        log.error("GetSupplierFromJingHuaU8DbImpl\u5f00\u542f\u4e8b\u52a1\u5931\u8d25", (Throwable)e);
                    }
                    this.doNext(data, tenant, (JSONObject)u8DbMap.get(data.getSupplierCode()));
                    try {
                        this.manualTransactionManagementService.commit();
                    }
                    catch (Exception e) {
                        log.error("GetSupplierFromJingHuaU8DbImpl\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error("\u5f02\u6b65\u6267\u884c\u4f9b\u5e94\u5546\u5931\u8d25:", (Throwable)e);
                    try {
                        this.manualTransactionManagementService.rollback();
                    }
                    catch (Exception e1) {
                        log.error("GetSupplierFromJingHuaU8DbImpl\u56de\u6eda\u4e8b\u52a1\u5931\u8d25", (Throwable)e1);
                    }
                }
                finally {
                    TenantContext.clear();
                    LoginUserContext.clear();
                    TokenContext.clear();
                }
            });
        }
        return interfaceResult;
    }

    private JSONArray handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        Assert.isTrue((result.getIntValue("status") == 200 ? 1 : 0) != 0, (String)result.getString("message"));
        return result.getJSONArray("result");
    }

    private String getToken() {
        String token = SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = SpringContextUtils.getHttpServletRequest().getHeader("token");
        }
        return token;
    }

    private void doNext(SupplierMasterData supplierMasterData, String tenant, JSONObject u8Item) {
        RegisterVO registerVO = new RegisterVO();
        registerVO.setCompanyName(supplierMasterData.getSupplierName());
        registerVO.setPhoneNumber(supplierMasterData.getPersonPhone());
        registerVO.setIsPerson(supplierMasterData.getIsPerson());
        JSONObject result = this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSData(registerVO.getCompanyName(), registerVO.getSourceType(), tenant, registerVO.getPhoneNumber(), registerVO.getIsPerson()), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
        log.info("GetSupplierFromJingHuaU8DbImpl_ipaas_result:" + result.toJSONString());
        if (result.getBoolean("success").booleanValue()) {
            ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = (ElsEnterpriseInfoDTO)JSON.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
            ElsEnterpriseInfoDTO enterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            if (enterpriseInfo == null) {
                ElsEnterpriseInfoDTO2.setDeleted(Integer.valueOf(0));
                ElsEnterpriseInfoDTO2.setAlias(StringUtils.isBlank((CharSequence)ElsEnterpriseInfoDTO2.getAlias()) ? u8Item.getString("ShortName") : ElsEnterpriseInfoDTO2.getAlias());
                ElsEnterpriseInfoDTO2.setLegalPersonName(StringUtils.isBlank((CharSequence)ElsEnterpriseInfoDTO2.getLegalPersonName()) ? u8Item.getString("BossName") : ElsEnterpriseInfoDTO2.getLegalPersonName());
                ElsEnterpriseInfoDTO2.setCreditCode(StringUtils.isBlank((CharSequence)ElsEnterpriseInfoDTO2.getCreditCode()) ? u8Item.getString("UniFormId") : ElsEnterpriseInfoDTO2.getCreditCode());
                ElsEnterpriseInfoDTO2.setIsPerson(supplierMasterData.getIsPerson());
                ElsEnterpriseInfoDTO2.setPhone(StringUtils.isBlank((CharSequence)ElsEnterpriseInfoDTO2.getPhone()) ? supplierMasterData.getPersonPhone() : ElsEnterpriseInfoDTO2.getPhone());
                ElsEnterpriseInfoDTO2.setDataVersion(CommonConstant.STATUS_NO);
                this.supplierinvokeEnterpriseRpcService.insert(ElsEnterpriseInfoDTO2);
            }
            registerVO.setContactsName(StringUtils.isNotBlank((CharSequence)supplierMasterData.getPersonName()) ? supplierMasterData.getPersonName() : supplierMasterData.getSupplierName());
            registerVO.setSubAccount(supplierMasterData.getPersonSubAccount());
            registerVO.setEmail(supplierMasterData.getPersonEmail());
            registerVO.setSourceType(SourceTypeEnum.EXTERNAL_SYATEM.getValue());
            registerVO.setPassword(StringUtils.isNotBlank((CharSequence)supplierMasterData.getPersonPassword()) ? supplierMasterData.getPersonPassword() : "123456");
            supplierMasterData.setToElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            supplierMasterData.setSourceType(registerVO.getSourceType());
            supplierMasterData.setStatus(SupplierFrozenStatusEnum.NORMAL.getValue());
            supplierMasterData.setNeedAudit("0");
            supplierMasterData.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            this.supplierMasterDataService.updateById((Object)supplierMasterData);
            this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSRelationData(supplierMasterData.getElsAccount(), ElsEnterpriseInfoDTO2.getElsAccount()), "valueAddedApplication", null);
            this.saveSubAccountInfoRpcNew(registerVO, ElsEnterpriseInfoDTO2.getElsAccount());
            this.saveSupplierContactsInfo(registerVO, supplierMasterData, u8Item);
            this.saveSupplierBankInfo(supplierMasterData, u8Item);
            this.saveSupplierOrgInfo(supplierMasterData, u8Item);
            ElsEnterpriseInfoRelationDTO enterpriseInfoRelationDTO = new ElsEnterpriseInfoRelationDTO();
            BeanUtils.copyProperties((Object)ElsEnterpriseInfoDTO2, (Object)enterpriseInfoRelationDTO);
            enterpriseInfoRelationDTO.setId(null);
            enterpriseInfoRelationDTO.setElsAccount(supplierMasterData.getElsAccount());
            enterpriseInfoRelationDTO.setToElsAccount(supplierMasterData.getToElsAccount());
            enterpriseInfoRelationDTO.setDeleted(CommonConstant.DEL_FLAG_0);
            this.supplierinvokeEnterpriseRpcService.saveBatchRelation(Collections.singletonList(enterpriseInfoRelationDTO));
        }
    }

    private JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount, String phone, String isPerson) {
        String defaultValue;
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        body.put("channel", (Object)sourceType);
        String auth = SourceTypeEnum.BUSINESS_PROMOTION.getValue().equals(sourceType) || SourceTypeEnum.OPEN_REGISTER.getValue().equals(sourceType) ? "1" : "0";
        body.put("auth", (Object)auth);
        body.put("phone", (Object)phone);
        body.put("is_person", (Object)isPerson);
        body.put("failIsCreateAccount", (Object)"1");
        ElsCompanySetDTO companySetDTO = this.invokeBaseRpcService.getElsCompanySetByElsAccountAndItemCode(elsAccount, "failIsCreateAccount");
        if (companySetDTO != null && StringUtils.isNotBlank((CharSequence)(defaultValue = companySetDTO.getDefaultValue()))) {
            body.put("failIsCreateAccount", (Object)defaultValue);
        }
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }

    private JSONObject getIpaaSRelationData(String purchaserElsAccount, String providerElsAccount) {
        JSONObject data = new JSONObject();
        data.put("purchaserElsAccount", (Object)purchaserElsAccount);
        data.put("providerElsAccount", (Object)providerElsAccount);
        return data;
    }

    private void saveSubAccountInfoRpcNew(RegisterVO registerVO, String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        List subAccountList = this.supplierInvokeAccountRpcService.getAllByAccount(elsAccount);
        if (subAccountList.isEmpty()) {
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setElsAccount(elsAccount);
            account.setSubAccount(StringUtils.isNotBlank((CharSequence)registerVO.getSubAccount()) ? registerVO.getSubAccount() : "1001");
            account.setRealname(registerVO.getContactsName());
            account.setPhone(registerVO.getPhoneNumber());
            account.setStatus(Integer.valueOf(1));
            account.setEmail(registerVO.getEmail());
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            String password = registerVO.getPassword();
            String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)password, (String)salt);
            account.setPassword(passwordEncode);
            account.setDeleted(Integer.valueOf(0));
            Object bytes = ImgCreatorUtil.generateImg((String)account.getRealname());
            if (null != bytes) {
                String fileName = System.currentTimeMillis() + ".jpg";
                Object filePath = this.getFilePath() + File.separator + System.currentTimeMillis() + fileName;
                filePath = ((String)filePath).contains("\\") ? ((String)filePath).replace("\\", "/") : filePath;
                String avatar = this.supplierinvokeBaseRpcService.uploadFile((byte[])bytes, (String)filePath, fileName);
                if (StrUtil.isEmpty((CharSequence)avatar)) {
                    account.setAvatar("/im/layim-v3.9.6/dist/css/modules/layim/skin/default.png");
                } else {
                    account.setAvatar(this.supplierinvokeBaseRpcService.getRealPath(avatar, null));
                }
            }
            RoleDTO role = new RoleDTO();
            role.setElsAccount(elsAccount);
            role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
            role.setRoleCode("companyAdmin");
            role = this.supplierInvokeAccountRpcService.saveRole(role);
            account = this.supplierInvokeAccountRpcService.addUserWithRole(account, role.getId());
            this.savePersonalSetting(elsAccount, account.getSubAccount());
            this.supplierInvokeAccountRpcService.savePasswordSecurity(elsAccount);
            ElsTenantDTO elsTenant = new ElsTenantDTO();
            elsTenant.setAccountStatus("1");
            elsTenant.setElsAccount(elsAccount);
            elsTenant.setCompanyName(registerVO.getCompanyName());
            elsTenant.setSourceType(registerVO.getSourceType());
            elsTenant.setUpdateBy(role.getUpdateBy());
            elsTenant.setCreateBy(role.getCreateBy());
            elsTenant.setExpiryDate((Date)DateUtil.parseDate((CharSequence)"2029-12-31"));
            this.supplierInvokeAccountRpcService.saveTenant(elsTenant);
        }
        List permissionList = this.supplierInvokeAccountRpcService.selectDefaultWithPurchase(TenantContext.getTenant());
        List ids = this.supplierInvokeAccountRpcService.listCompanyPermission(elsAccount);
        List needAddPermissionList = permissionList.stream().filter(u -> !ids.contains(u.getId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(needAddPermissionList)) {
            List<CompanyPermissionDTO> companyPermissions = new ArrayList();
            for (PermissionDTO permission : needAddPermissionList) {
                CompanyPermissionDTO companyPermissionDTO = new CompanyPermissionDTO();
                companyPermissionDTO.setId(IdWorker.getIdStr());
                companyPermissionDTO.setElsAccount(elsAccount);
                companyPermissionDTO.setPermissionId(permission.getId());
                companyPermissionDTO.setName(permission.getName());
                companyPermissionDTO.setSortNo(permission.getSortNo());
                companyPermissionDTO.setIcon(permission.getIcon());
                companyPermissionDTO.setIconColor(permission.getIconColor());
                companyPermissionDTO.setRuleFlag(permission.getRuleFlag());
                companyPermissionDTO.setStatus(permission.getStatus());
                companyPermissionDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                companyPermissionDTO.setUpdateTime(new Date());
                companyPermissions.add(companyPermissionDTO);
            }
            if (CollectionUtil.isNotEmpty(companyPermissions)) {
                companyPermissions = this.supplierInvokeAccountRpcService.insertCompanyMenuBatch(companyPermissions);
                RoleDTO role = this.supplierInvokeAccountRpcService.getElsAccountAdminRole(elsAccount);
                if (role == null) {
                    role = new RoleDTO();
                    role.setElsAccount(elsAccount);
                    role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                    role.setRoleCode("companyAdmin");
                    role = this.supplierInvokeAccountRpcService.saveRole(role);
                }
                ArrayList companyPermissionList = Lists.newArrayList();
                for (CompanyPermissionDTO companyPermission : companyPermissions) {
                    RolePermissionDTO rolePermission = new RolePermissionDTO();
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(role.getId());
                    rolePermission.setPermissionId(companyPermission.getPermissionId());
                    companyPermissionList.add(rolePermission);
                }
                if (CollUtil.isNotEmpty((Collection)companyPermissionList)) {
                    this.supplierInvokeAccountRpcService.batchSaveRolePermission((List)companyPermissionList);
                }
            }
        }
    }

    private void savePersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSettingDTO> personalSettings = new ArrayList<PersonalSettingDTO>();
        for (String str : list) {
            PersonalSettingDTO personalSetting = new PersonalSettingDTO();
            personalSetting.setId(IdWorker.getIdStr());
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime((Date)DateUtil.date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime((Date)DateUtil.date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(Integer.valueOf(0));
            personalSettings.add(personalSetting);
        }
        this.supplierInvokeAccountRpcService.savePersonalSetting(personalSettings);
    }

    private void saveSupplierContactsInfo(RegisterVO registerVO, SupplierMasterData data, JSONObject u8Item) {
        List subAccounts = this.supplierInvokeAccountRpcService.getAllByAccount(data.getToElsAccount());
        if (subAccounts.isEmpty()) {
            SupplierContactsInfo supplierContactsInfo = new SupplierContactsInfo();
            supplierContactsInfo.setName(registerVO.getContactsName());
            supplierContactsInfo.setEmail(registerVO.getEmail());
            supplierContactsInfo.setTelphone(u8Item.getString("Phone1"));
            supplierContactsInfo.setFbk1(u8Item.getString("Fax1"));
            supplierContactsInfo.setFbk2(registerVO.getPhoneNumber());
            SysUtil.setSysParam((BaseEntity)supplierContactsInfo, (BaseEntity)data);
            supplierContactsInfo.setHeadId(data.getId());
            supplierContactsInfo.setToElsAccount(data.getElsAccount());
            supplierContactsInfo.setElsAccount(data.getToElsAccount());
            supplierContactsInfo.setSubAccount(StringUtils.isNotBlank((CharSequence)registerVO.getSubAccount()) ? registerVO.getSubAccount() : "1001");
            this.supplierContactsInfoService.save((Object)supplierContactsInfo);
        } else {
            ArrayList<SupplierContactsInfo> supplierContactsInfoList = new ArrayList<SupplierContactsInfo>();
            for (ElsSubAccountDTO subAccountDTO : subAccounts) {
                SupplierContactsInfo supplierContactsInfo = new SupplierContactsInfo();
                supplierContactsInfo.setName(subAccountDTO.getRealname());
                supplierContactsInfo.setTelphone(subAccountDTO.getPhone());
                supplierContactsInfo.setEmail(subAccountDTO.getEmail());
                SysUtil.setSysParam((BaseEntity)supplierContactsInfo, (BaseEntity)data);
                supplierContactsInfo.setToElsAccount(data.getElsAccount());
                supplierContactsInfo.setElsAccount(data.getToElsAccount());
                supplierContactsInfo.setSubAccount(subAccountDTO.getSubAccount());
                supplierContactsInfo.setHeadId(data.getId());
                supplierContactsInfoList.add(supplierContactsInfo);
            }
            if (!supplierContactsInfoList.isEmpty()) {
                this.supplierContactsInfoService.saveBatch(supplierContactsInfoList, 2000);
            }
        }
    }

    private void saveSupplierBankInfo(SupplierMasterData data, JSONObject u8Item) {
        SupplierBankInfo bankInfo = new SupplierBankInfo();
        bankInfo.setBankAccount(u8Item.getString("PayAccountId"));
        SysUtil.setSysParam((BaseEntity)bankInfo, (BaseEntity)data);
        bankInfo.setHeadId(data.getId());
        bankInfo.setToElsAccount(data.getElsAccount());
        bankInfo.setElsAccount(data.getToElsAccount());
        this.supplierBankInfoService.save((Object)bankInfo);
    }

    private void saveSupplierOrgInfo(SupplierMasterData data, JSONObject u8Item) {
        SupplierOrgInfo orgInfo = new SupplierOrgInfo();
        orgInfo.setPayConditionCode(u8Item.getString("PayWayCode"));
        orgInfo.setCurrency(u8Item.getString("MoneyCode"));
        orgInfo.setTaxCode(u8Item.getString("InvoiceTypeId"));
        SysUtil.setSysParam((BaseEntity)orgInfo, (BaseEntity)data);
        orgInfo.setHeadId(data.getId());
        orgInfo.setToElsAccount(data.getElsAccount());
        orgInfo.setElsAccount(data.getToElsAccount());
        this.supplierOrgInfoService.save((Object)orgInfo);
    }

    private String getFilePath() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowDay = dtf.format(time);
        return File.separator + "files" + File.separator + TenantContext.getTenant() + File.separator + nowDay;
    }
}

