/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceUtil;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushSupplierDataToManXiaoBaoErpServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushSupplierDataToManXiaoBaoErpServiceImpl.class);
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private SupplierMasterDataService supplierMasterDataService;

    public JSONObject before(JSONObject param, Object o) {
        boolean isPush;
        SupplierMasterDataVO supplierMasterDataVO = (SupplierMasterDataVO)((JSONObject)o).get((Object)"supplierMasterDataVO");
        boolean bl = isPush = "1".equals(supplierMasterDataVO.getReturnState()) || "3".equals(supplierMasterDataVO.getReturnState());
        if (isPush) {
            param.put("interface_code", (Object)"JK20230914000004");
        }
        JSONObject cbdocvo = new JSONObject();
        JSONObject parentvo = new JSONObject();
        parentvo.put("creator", (Object)supplierMasterDataVO.getCreateBy());
        parentvo.put("custcode", (Object)supplierMasterDataVO.getToElsAccount());
        parentvo.put("custname", (Object)supplierMasterDataVO.getSupplierName());
        String custprop = StrUtil.nullToDefault((CharSequence)supplierMasterDataVO.getFbk3(), (String)"0");
        parentvo.put("custprop", (Object)custprop);
        parentvo.put("custshortname", (Object)supplierMasterDataVO.getAlias());
        parentvo.put("pk_areacl", (Object)"01");
        parentvo.put("pk_cubasdoc", (Object)supplierMasterDataVO.getSupplierCode());
        List supplierContactsInfoList = supplierMasterDataVO.getSupplierContactsInfoList();
        if (CollectionUtil.isNotEmpty((Collection)supplierContactsInfoList)) {
            SupplierContactsInfo supplierContactsInfo = (SupplierContactsInfo)supplierContactsInfoList.get(0);
            parentvo.put("mobilephone1", (Object)supplierContactsInfo.getTelphone());
            parentvo.put("linkman1", (Object)supplierContactsInfo.getName());
            parentvo.put("email", (Object)supplierContactsInfo.getEmail());
        }
        cbdocvo.put("parentvo", (Object)parentvo);
        JSONArray banks = new JSONArray();
        if (CollectionUtil.isNotEmpty((Collection)supplierMasterDataVO.getSupplierBankInfoList())) {
            for (Object supplierBankInfo : supplierMasterDataVO.getSupplierBankInfoList()) {
                JSONObject bank = new JSONObject();
                bank.put("account", (Object)supplierBankInfo.getBankAccount());
                bank.put("banktypename", (Object)supplierBankInfo.getCooperationBankType());
                bank.put("defflag", (Object)supplierBankInfo.getDefaultAccount());
                banks.add((Object)bank);
            }
        }
        cbdocvo.put("banks", (Object)banks);
        JSONArray addrs = new JSONArray();
        if (CollectionUtil.isNotEmpty((Collection)supplierMasterDataVO.getSupplierAddressInfoList())) {
            for (SupplierAddressInfo supplierAddressInfo : supplierMasterDataVO.getSupplierAddressInfoList()) {
                JSONObject addr = new JSONObject();
                addr.put("addrname", (Object)supplierAddressInfo.getAddress());
                addr.put("defaddrflag", (Object)"1");
                addr.put("pk_areacl", (Object)supplierAddressInfo.getCountry());
                addrs.add((Object)addr);
            }
        }
        cbdocvo.put("addrs", (Object)addrs);
        JSONObject body = new JSONObject();
        body.put("cbdocvo", (Object)cbdocvo);
        param.put("body", (Object)body);
        param.put("header_param", (Object)this.getHeader("code"));
        return param;
    }

    public JSONObject after(JSONObject result, JSONObject param, Object o) {
        try {
            if (result == null || result.getIntValue("code") != 200) {
                log.error("\u8c03\u7528\u63a8\u9001u8c\u63a5\u53e3\u5931\u8d25");
                return result;
            }
            JSONObject companyInfo = result.getJSONObject("result");
            if (companyInfo == null || !"success".equals(companyInfo.get((Object)"status"))) {
                String errorMsg = companyInfo == null ? "" : companyInfo.getString("errormsg");
                log.error("\u63a8\u9001u8c\u5931\u8d25,\u8fd4\u56de\u9519\u8bef={}", (Object)errorMsg);
                return result;
            }
            JSONArray data = companyInfo.getJSONArray("data");
            if (CollectionUtil.isEmpty((Collection)data)) {
                log.error("\u63a8\u9001u8c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                return result;
            }
            JSONObject info = (JSONObject)data.get(0);
            String cubasdoc = info.getJSONObject("parentvo").getString("pk_cubasdoc");
            SupplierMasterDataVO supplierMasterDataVO = (SupplierMasterDataVO)((JSONObject)o).get((Object)"supplierMasterDataVO");
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.supplierMasterDataService.lambdaUpdate().set(SupplierMasterData::getSupplierCode, (Object)cubasdoc)).set(SupplierMasterData::getReturnState, (Object)1)).eq(BaseEntity::getId, (Object)supplierMasterDataVO.getId())).update();
            this.bindCompany(supplierMasterDataVO, cubasdoc);
        }
        catch (Exception ex) {
            log.error("bindCompany error=", (Throwable)ex);
        }
        return result;
    }

    private void bindCompany(SupplierMasterDataVO supplierMasterDataVO, String cubasdoc) {
        try {
            if ("1".equals(supplierMasterDataVO.getFbk1())) {
                return;
            }
            String companyNumber = this.getCompanyNumber(supplierMasterDataVO);
            if (StrUtil.isEmpty((CharSequence)companyNumber)) {
                return;
            }
            this.doBindCompany(supplierMasterDataVO, cubasdoc, companyNumber);
        }
        catch (Exception ex) {
            log.error("bindCompany error=", (Throwable)ex);
        }
    }

    private JSONObject getHeader(String tranType) {
        JSONObject header = new JSONObject();
        header.put("usercode", (Object)"yxdev");
        header.put("password", (Object)"e10adc3949ba59abbe56e057f20f883e");
        if (tranType != null) {
            header.put("trantype", (Object)tranType);
        }
        header.put("system", (Object)"yxdev");
        return header;
    }

    private String getCompanyNumber(SupplierMasterDataVO supplierMasterDataVO) {
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        body.put("unitname", (Object)"\u4e0a\u6d77\u6ee1\u5c0f\u9971\u98df\u54c1\u79d1\u6280\u6709\u9650\u516c\u53f8");
        param.put("bus_account", (Object)supplierMasterDataVO.getBusAccount());
        param.put("srm_interface_code", (Object)"getU8cCompany");
        param.put("header_param", (Object)this.getHeader(null));
        param.put("body", (Object)body);
        JSONObject result = this.interfaceUtil.callInterface(supplierMasterDataVO.getElsAccount(), null, param, null);
        if (result == null || result.getIntValue("code") != 200) {
            log.error("\u7ed1\u5b9a\u516c\u53f8\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        JSONObject companyInfo = result.getJSONObject("result");
        if (companyInfo == null || !"success".equals(companyInfo.get((Object)"status"))) {
            log.error("\u7ed1\u5b9a\u516c\u53f8\u83b7\u53d6\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        JSONArray datas = companyInfo.getJSONObject("data").getJSONArray("datas");
        if (CollectionUtil.isEmpty((Collection)datas)) {
            return null;
        }
        JSONObject data = (JSONObject)datas.get(0);
        return data.getString("pk_corp");
    }

    private void doBindCompany(SupplierMasterDataVO supplierMasterDataVO, String cubasdoc, String companyNumber) {
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        JSONObject custbasvo = new JSONObject();
        custbasvo.put("custprop", (Object)"1");
        custbasvo.put("pk_corp", (Object)companyNumber);
        custbasvo.put("pk_cubasdoc", (Object)cubasdoc);
        body.put("custbasvo", (Object)custbasvo);
        param.put("bus_account", (Object)supplierMasterDataVO.getBusAccount());
        param.put("srm_interface_code", (Object)"bindU8cCompany");
        param.put("body", (Object)body);
        param.put("header_param", (Object)this.getHeader("pk"));
        JSONObject result = this.interfaceUtil.callInterface(supplierMasterDataVO.getElsAccount(), null, param, null);
        if (result == null || result.getIntValue("code") != 200) {
            log.error("\u7ed1\u5b9a\u516c\u53f8\u8c03\u7528\u5931\u8d25");
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.supplierMasterDataService.lambdaUpdate().set(SupplierMasterData::getFbk1, (Object)"1")).set(SupplierMasterData::getFbk2, (Object)supplierMasterDataVO.getToElsAccount())).eq(BaseEntity::getId, (Object)supplierMasterDataVO.getId())).update();
    }

    private void queryManageId(SupplierMasterDataVO supplierMasterDataVO) {
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        body.put("unitcode", (Object)"0103");
        body.put("custcode", (Object)supplierMasterDataVO.getToElsAccount());
        param.put("bus_account", (Object)supplierMasterDataVO.getBusAccount());
        param.put("srm_interface_code", (Object)"getU8cManageDoc");
        param.put("body", (Object)body);
        param.put("header_param", (Object)this.getHeader(null));
        JSONObject jsonObject = this.interfaceUtil.callInterface(supplierMasterDataVO.getElsAccount(), null, param, null);
        if (!CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) {
            log.error("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25: " + jsonObject.getString("message"));
            return;
        }
        JSONObject result = jsonObject.getJSONObject("result");
        String returnStatus = result.getString("status");
        if (!"success".equals(returnStatus)) {
            String errorMsg = result.getString("errormsg");
            log.error("SRM\u83b7\u53d6\u5ba2\u5546\u7ba1\u7406\u6863\u6848\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + errorMsg);
            return;
        }
        JSONArray datas = result.getJSONObject("data").getJSONArray("datas");
        if (CollectionUtil.isEmpty((Collection)datas)) {
            return;
        }
        JSONObject data = (JSONObject)datas.get(0);
        JSONArray childrenvo = data.getJSONArray("childrenvo");
        for (Object o : childrenvo) {
            JSONObject child = (JSONObject)o;
            if (!"3".equals(child.getString("custflag"))) continue;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.supplierMasterDataService.lambdaUpdate().set(SupplierMasterData::getFbk2, (Object)child.getString("pk_cumandoc"))).eq(BaseEntity::getId, (Object)supplierMasterDataVO.getId())).update();
        }
    }
}

