/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.u8.api.extend;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.CompanyInterfaceConfigItemDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PushSupplierMasterDataToLuoShiU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushSupplierMasterDataToLuoShiU8ServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private SupplierMasterDataService supplierMasterDataService;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject bodyJson = new JSONObject();
        JSONObject cbdocvo = new JSONObject();
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO headVO = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        if (StringUtils.isNotBlank((CharSequence)headVO.getSupplierCode())) {
            String elsAccount = TenantContext.getTenant();
            List configItemList = this.invokeBaseRpcService.getConfig(elsAccount, "updateSupplierMainData");
            for (CompanyInterfaceConfigItemDTO item : configItemList) {
                JSONObject param = new JSONObject();
                param.put("bus_account", (Object)elsAccount);
                param.put("srm_interface_code", (Object)item.getSrmInterfaceCode());
                JSONObject paramCustom = new JSONObject();
                paramCustom.put("srm_org_code", (Object)item.getCompanyCode());
                paramCustom.put("supplierMasterDataVO", (Object)headVO);
                paramCustom.put("state", (Object)0);
                this.interfaceUtil.callInterface(elsAccount, item.getCompanyCode(), param, (Object)paramCustom);
            }
            return null;
        }
        JSONObject parentvo = this.paramParentvo(headVO);
        JSONArray banks = this.paramBanks(headVO);
        JSONArray addrs = this.paramAddrs(headVO);
        cbdocvo.put("addrs", (Object)addrs);
        cbdocvo.put("parentvo", (Object)parentvo);
        cbdocvo.put("banks", (Object)banks);
        bodyJson.put("cbdocvo", (Object)cbdocvo);
        obj.put("body", (Object)bodyJson);
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u65b0\u589e\u63a8\u9001U8C\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)obj.toJSONString());
        return obj;
    }

    private JSONArray paramAddrs(SupplierMasterDataVO headVO) {
        JSONArray addrsArray = new JSONArray();
        List supplierAddressInfoList = headVO.getSupplierAddressInfoList();
        for (SupplierAddressInfo item : supplierAddressInfoList) {
            JSONObject addrs = new JSONObject();
            addrs.put("addrname", (Object)item.getAddress());
            addrs.put("defaddrflag", (Object)true);
            addrs.put("pk_areacl", (Object)headVO.getFbk1().split(" ")[0]);
            addrsArray.add((Object)addrs);
        }
        return addrsArray;
    }

    private JSONArray paramBanks(SupplierMasterDataVO headVO) {
        JSONArray banksArray = new JSONArray();
        List supplierBankInfoList = headVO.getSupplierBankInfoList();
        for (SupplierBankInfo item : supplierBankInfoList) {
            JSONObject banks = new JSONObject();
            banks.put("account", (Object)item.getBankAccount());
            banks.put("banktypename", (Object)item.getCooperationBankType());
            banks.put("defflag", (Object)"1");
            banks.put("pk_currtype", (Object)headVO.getCurrency());
            banks.put("accname", (Object)item.getBankCode());
            banksArray.add((Object)banks);
        }
        return banksArray;
    }

    private JSONObject paramParentvo(SupplierMasterDataVO headVO) {
        JSONObject parentvo = new JSONObject();
        this.checkSupplierMasterDataVO(headVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)headVO.getElsAccount());
        queryWrapper.inSql((Object)"supplier_code", "select max(supplier_code) from supplier_master_data where els_account=" + headVO.getElsAccount());
        SupplierMasterData one = (SupplierMasterData)this.supplierMasterDataService.getOne((Wrapper)queryWrapper);
        BigDecimal supplierCode = new BigDecimal(one.getSupplierCode()).add(new BigDecimal(1));
        parentvo.put("custcode", (Object)supplierCode.toString());
        parentvo.put("custname", (Object)headVO.getSupplierName());
        parentvo.put("custprop", (Object)"0");
        parentvo.put("custshortname", (Object)headVO.getSupplierName());
        parentvo.put("legalbody", (Object)headVO.getLegalPersonName());
        parentvo.put("taxpayerid", (Object)headVO.getTaxNumber());
        parentvo.put("pk_areacl", (Object)headVO.getFbk1().split(" ")[0]);
        parentvo.put("createtime", (Object)headVO.getCreateTime());
        parentvo.put("creator", (Object)headVO.getCreateBy());
        return parentvo;
    }

    private void checkSupplierMasterDataVO(SupplierMasterDataVO headVO) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)headVO.getFbk1()), (String)"\u6240\u5c5e\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO headVO = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        SupplierMasterData updateMasterData = new SupplierMasterData();
        updateMasterData.setId(headVO.getId());
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u65b0\u589e\u63a8\u9001U8C\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)interfaceResult.toJSONString());
        if (interfaceResult.getIntValue("code") != 200) {
            throw new ELSBootException("U8C\u8fd4\u56de\u9519\u8bef\u6d88\u606f:" + interfaceResult.getString("message"));
        }
        JSONObject result = interfaceResult.getJSONObject("result");
        if (!result.getString("status").equals("success")) {
            updateMasterData.setReturnState("2");
            updateMasterData.setInterfaceMsg(result.getString("errormsg"));
            this.supplierMasterDataService.updateById((Object)updateMasterData);
            throw new ELSBootException("U8C\u8fd4\u56de\u9519\u8bef\u6d88\u606f:" + result.getString("errormsg"));
        }
        JSONArray array = JSONArray.parseArray((String)result.getString("data"));
        JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(0));
        JSONObject parentvo = (JSONObject)Convert.convert(JSONObject.class, (Object)object.get((Object)"parentvo"));
        updateMasterData.setReturnState("1");
        updateMasterData.setInterfaceMsg("\u64cd\u4f5c\u6210\u529f");
        updateMasterData.setSupplierCode(parentvo.getString("custcode"));
        updateMasterData.setFbk10(parentvo.getString("pk_cubasdoc"));
        this.supplierMasterDataService.updateById((Object)updateMasterData);
        return null;
    }

    private String handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        if (!result.getString("status").equals("success")) {
            throw new IllegalArgumentException(result.getString("errormsg"));
        }
        return result.getString("data");
    }
}

