/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.u8.api.extend;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.entity.SupplierContactsInfo;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PushSupplierToShiWeiU8Impl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushSupplierToShiWeiU8Impl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private SupplierMasterDataService supplierMasterDataService;

    public boolean invokeCheck(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO headVO = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        return StringUtils.isNotBlank((CharSequence)headVO.getSupplierCode()) && StringUtils.isBlank((CharSequence)headVO.getSourceId());
    }

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO headVO = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        obj.put("body", (Object)this.getBody(headVO));
        log.info("PushSupplierToShiWeiU8Impl.before -> obj \u3010{}\u3011 custom \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj), custom);
        return obj;
    }

    public JSONObject after(JSONObject result, JSONObject obj, Object custom) {
        log.info("PushSupplierToShiWeiU8Impl.after -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)result));
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO headVO = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        String elsAccount = customObj.getString("bus_account");
        if (result.getIntValue("code") != 200) {
            throw new ELSBootException(result.getString("message"));
        }
        JSONObject result2 = result.getJSONObject("result");
        SupplierMasterData supplierMasterData = new SupplierMasterData();
        supplierMasterData.setId(headVO.getId());
        if (!result2.getBooleanValue("IsSucceed")) {
            supplierMasterData.setReturnState("2");
            supplierMasterData.setInterfaceMsg(result2.getString("Dsc"));
            log.error("PushSupplierToShiWeiU8Impl \u63a8\u9001\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u5931\u8d25\uff1a" + result2.getString("Dsc"));
            ((PushSupplierToShiWeiU8Impl)SpringContextUtils.getBean(PushSupplierToShiWeiU8Impl.class)).updateQuantity(supplierMasterData);
            throw new ELSBootException(result2.getString("Dsc"));
        }
        supplierMasterData.setSourceId(headVO.getSupplierCode());
        supplierMasterData.setReturnState("1");
        supplierMasterData.setInterfaceMsg("success");
        this.supplierMasterDataService.updateById((Object)supplierMasterData);
        return result;
    }

    private JSONArray getBody(SupplierMasterDataVO headVO) {
        JSONArray array = new JSONArray();
        JSONObject body = new JSONObject();
        body.put("cVenName", (Object)headVO.getSupplierName());
        body.put("cVenCode", (Object)headVO.getSupplierCode());
        body.put("cVCCode", (Object)headVO.getSupplierClassify());
        List supplierContactsInfoList = headVO.getSupplierContactsInfoList();
        JSONArray linkdata = new JSONArray();
        if (CollUtil.isNotEmpty((Collection)supplierContactsInfoList)) {
            for (SupplierContactsInfo supplierContactsInfo : supplierContactsInfoList) {
                JSONObject contactsInfo = new JSONObject();
                contactsInfo.put("cVenPerson", (Object)(supplierContactsInfo.getName() == null ? "" : supplierContactsInfo.getName()));
                contactsInfo.put("cVenHand", (Object)(supplierContactsInfo.getTelphone() == null ? "" : supplierContactsInfo.getTelphone()));
                contactsInfo.put("cVenEmail", (Object)(supplierContactsInfo.getEmail() == null ? "" : supplierContactsInfo.getEmail()));
                linkdata.add((Object)contactsInfo);
            }
        }
        body.put("linkdata", (Object)linkdata);
        List supplierAddressInfoList = headVO.getSupplierAddressInfoList();
        if (CollUtil.isNotEmpty((Collection)supplierAddressInfoList)) {
            SupplierAddressInfo supplierAddressInfo = (SupplierAddressInfo)supplierAddressInfoList.get(0);
            body.put("country", (Object)(supplierAddressInfo.getCountry() == null ? "" : supplierAddressInfo.getCountry()));
            body.put("province", (Object)(supplierAddressInfo.getProvince() == null ? "" : supplierAddressInfo.getProvince()));
            body.put("city", (Object)(supplierAddressInfo.getCity() == null ? "" : supplierAddressInfo.getCity()));
            body.put("address", (Object)(supplierAddressInfo.getAddress() == null ? "" : supplierAddressInfo.getAddress()));
            body.put("telphone", (Object)(supplierAddressInfo.getTelphone() == null ? "" : supplierAddressInfo.getTelphone()));
        }
        List supplierBankInfoList = headVO.getSupplierBankInfoList();
        JSONArray bankdata = new JSONArray();
        if (CollUtil.isNotEmpty((Collection)supplierBankInfoList)) {
            for (SupplierBankInfo supplierBankInfo : supplierBankInfoList) {
                JSONObject bankInfo = new JSONObject();
                bankInfo.put("bankCountry", (Object)(supplierBankInfo.getBankCountry() == null ? "" : supplierBankInfo.getBankCountry()));
                bankInfo.put("bankProvince", (Object)(supplierBankInfo.getBankProvince() == null ? "" : supplierBankInfo.getBankProvince()));
                bankInfo.put("bankCity", (Object)(supplierBankInfo.getBankCity() == null ? "" : supplierBankInfo.getBankCity()));
                bankInfo.put("bankBranchName", (Object)(supplierBankInfo.getBankBranchName() == null ? "" : supplierBankInfo.getBankBranchName()));
                bankInfo.put("bankAccount", (Object)(supplierBankInfo.getBankAccount() == null ? "" : supplierBankInfo.getBankAccount()));
                bankInfo.put("bankAccountName", (Object)(supplierBankInfo.getBankAccountName() == null ? "" : supplierBankInfo.getBankAccountName()));
                bankInfo.put("cooperationBankType", (Object)(supplierBankInfo.getCooperationBankType() == null ? "" : supplierBankInfo.getCooperationBankType()));
                bankInfo.put("bankCode", (Object)(supplierBankInfo.getBankCode() == null ? "" : supplierBankInfo.getBankCode()));
                bankdata.add((Object)bankInfo);
            }
        }
        body.put("bankdata", (Object)bankdata);
        array.add((Object)body);
        return array;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateQuantity(SupplierMasterData supplierMasterData) {
        this.supplierMasterDataService.updateById((Object)supplierMasterData);
    }
}

