/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.third.u8.api.extend;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.InterfaceUtil;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.supplier.entity.SupplierAddressInfo;
import com.els.modules.supplier.entity.SupplierBankInfo;
import com.els.modules.supplier.vo.SupplierMasterDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PushUpdateSupplierMasterDataToLuoShiU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushUpdateSupplierMasterDataToLuoShiU8ServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InterfaceUtil interfaceUtil;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject bodyJson = new JSONObject();
        JSONObject cbdocvo = new JSONObject();
        JSONObject customObj = (JSONObject)custom;
        SupplierMasterDataVO headVO = (SupplierMasterDataVO)customObj.get((Object)"supplierMasterDataVO");
        JSONObject parentvo = this.paramParentvo(headVO);
        JSONArray banks = this.paramBanks(headVO);
        JSONArray addrs = this.paramAddrs(headVO);
        cbdocvo.put("addrs", (Object)addrs);
        cbdocvo.put("parentvo", (Object)parentvo);
        cbdocvo.put("banks", (Object)banks);
        bodyJson.put("cbdocvo", (Object)cbdocvo);
        obj.put("body", (Object)bodyJson);
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u66f4\u65b0\u63a8\u9001U8C\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)obj.toJSONString());
        return obj;
    }

    private JSONArray paramAddrs(SupplierMasterDataVO headVO) {
        JSONArray addrsArray = new JSONArray();
        List supplierAddressInfoList = headVO.getSupplierAddressInfoList();
        for (SupplierAddressInfo item : supplierAddressInfoList) {
            JSONObject addrs = new JSONObject();
            addrs.put("addrname", (Object)item.getAddress());
            addrs.put("defaddrflag", (Object)true);
            addrs.put("pk_areacl", (Object)headVO.getFbk1().split(" ")[0]);
            addrsArray.add((Object)addrs);
        }
        return addrsArray;
    }

    private JSONArray paramBanks(SupplierMasterDataVO headVO) {
        JSONArray banksArray = new JSONArray();
        List supplierBankInfoList = headVO.getSupplierBankInfoList();
        for (SupplierBankInfo item : supplierBankInfoList) {
            JSONObject banks = new JSONObject();
            banks.put("account", (Object)item.getBankAccount());
            banks.put("banktypename", (Object)item.getCooperationBankType());
            banks.put("defflag", (Object)"1");
            banks.put("pk_currtype", (Object)headVO.getCurrency());
            banks.put("accname", (Object)item.getBankCode());
            banksArray.add((Object)banks);
        }
        return banksArray;
    }

    private JSONObject paramParentvo(SupplierMasterDataVO headVO) {
        JSONObject parentvo = new JSONObject();
        this.checkSupplierMasterDataVO(headVO);
        parentvo.put("custcode", (Object)headVO.getSupplierCode());
        parentvo.put("custname", (Object)headVO.getSupplierName());
        parentvo.put("custprop", (Object)"0");
        parentvo.put("custshortname", (Object)headVO.getSupplierName());
        parentvo.put("legalbody", (Object)headVO.getLegalPersonName());
        parentvo.put("taxpayerid", (Object)headVO.getTaxNumber());
        parentvo.put("pk_areacl", (Object)headVO.getFbk1().split(" ")[0]);
        parentvo.put("createtime", (Object)headVO.getCreateTime());
        parentvo.put("creator", (Object)headVO.getCreateBy());
        parentvo.put("pk_cubasdoc", (Object)headVO.getFbk10());
        return parentvo;
    }

    private void checkSupplierMasterDataVO(SupplierMasterDataVO headVO) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)headVO.getFbk1()), (String)"\u6240\u5c5e\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u66f4\u65b0\u63a8\u9001U8C\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)interfaceResult.toJSONString());
        String result = this.handlerResultListInfo(interfaceResult);
        return null;
    }

    private String handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        if (!result.getString("status").equals("success")) {
            throw new IllegalArgumentException(result.getString("errormsg"));
        }
        return result.getString("data");
    }
}

